/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * LABEL レンデラーは、カラムの値を#FFFFFFの色として表示する場合に
 * 使用するクラスです。
 * #FFFFFFのように#付き7桁のデータで設定して下さい。
 *
 * このクラスは、不変オブジェクトとして、共有されます。
 *
 * @og.group データ表示
 *
 * @og.rev 5.5.4.0 (2012/07/02) 新規作成
 * @og.rev 5.6.3.1 (2013/04/05) input タグから、div へ全面変更
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_COLOR extends AbstractRenderer {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.0.4.0 (2014/11/28)" ;

	private static final CellRenderer dbCell = new Renderer_COLOR() ;

	private static final String		DIV1 = "<div style=\"background-color:" ;
	private static final String		DIV2 = "; color:" ;
	private static final String		DIV3 = ";\">" ;
	private static final String		DIV4 = "</div>" ;

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellRendererオブジェクト
	 * @og.rtnNotNull
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return dbCell;
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param   value 入力値
	 *
	 * @return  データの表示用文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final String value ) {
		if( value == null || value.trim().isEmpty() ) {
			return "";
		}

		return DIV1 + value + DIV2 + value + DIV3 + value + DIV4;
	}

	/**
	 * データ出力用の文字列を作成します。
	 * ファイル等に出力する形式を想定しますので、HTMLタグを含まない
	 * データを返します。
	 * 基本は、#getValue( String ) をそのまま返します。
	 *
	 * @og.rev 6.0.4.0 (2014/11/28) データ出力用のレンデラー
	 *
	 * @param   value 入力値
	 *
	 * @return  データ出力用の文字列
	 * @og.rtnNotNull
	 * @see		#getValue( String )
	 */
	@Override
	public String getWriteValue( final String value ) {
		return value == null ? "" : value;
	}
}
