/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.EDbid;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.xml.DomParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseConfig {
    private static final String DEFAULT_DRIVER = "oracle.jdbc.OracleDriver";
    private final String xmlFilename;
    private final Map<String, EDbid> dbidMap = Collections.synchronizedMap(new LinkedHashMap());
    private final List<String> driverList = Collections.synchronizedList(new ArrayList());
    private String codeKeyVal;
    private static final String[] DBID_INFO_KEYS = new String[]{"dbidKey", "title", "url", "user", "password", "readonly", "mincount", "maxcount", "pooltime", "applicationInfo", "property"};
    private static final String DBDRIVER_CLASS_KEY = "class";

    public DatabaseConfig() {
        this("../DBConfig.xml");
    }

    public DatabaseConfig(String string) {
        Object object;
        String string2 = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL != null) {
            string2 = uRL.getFile();
            if (!new File(string2).exists()) {
                string2 = null;
            }
        } else {
            uRL = classLoader.getResource("/");
            if (uRL != null && ((File)(object = new File(uRL.getPath(), string))).exists()) {
                string2 = ((File)object).getAbsolutePath();
            }
        }
        if (string2 == null && new File(string).exists()) {
            string2 = string;
        }
        if (string2 == null) {
            object = "DBConfig.xml\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002File=[" + string + "]\n" + " WEB-INF/classes \u30d5\u30a9\u30eb\u30c0\u304c\u306a\u3044\u3068\u3001\u76f8\u5bfe\u30d1\u30b9\u3067\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new RuntimeException((String)object);
        }
        this.xmlFilename = string2;
        this.init();
    }

    public EDbid getDbid(String string) {
        return this.dbidMap.get(string.toUpperCase(Locale.JAPAN));
    }

    public void reload() {
        this.dbidMap.clear();
        this.driverList.clear();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Document document = DomParser.read(new File(this.xmlFilename));
        Element element = document.getDocumentElement();
        this.makeDriverList(element);
        Object object = this;
        synchronized (object) {
            for (String string : this.driverList) {
                try {
                    Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string2 = "\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + string + "]";
                    LogWriter.log(string2);
                    LogWriter.log(classNotFoundException);
                }
            }
        }
        object = new EDbid();
        ((EDbid)object).setUrl(System.getenv("REALM_URL"));
        ((EDbid)object).setUser(System.getenv("REALM_NAME"));
        ((EDbid)object).setPassword(System.getenv("REALM_PASSWORD"));
        this.makeDbidMap(element, (EDbid)object);
    }

    private void makeDriverList(Element element) {
        String string;
        NodeList nodeList = element.getElementsByTagName(DBDRIVER_CLASS_KEY);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            this.driverList.add(element2.getTextContent());
        }
        if (this.driverList.isEmpty() && (string = System.getenv("REALM_DRIVER")) != null && string.length() > 0) {
            this.driverList.add(string);
        }
        if (this.driverList.isEmpty()) {
            this.driverList.add(DEFAULT_DRIVER);
        }
    }

    private void makeDbidMap(Element element, EDbid eDbid) {
        Object object;
        NodeList nodeList = element.getElementsByTagName("dbid");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object = (Element)nodeList.item(i);
            NodeList nodeList2 = object.getChildNodes();
            int n2 = nodeList2.getLength();
            EDbid eDbid2 = eDbid.clone();
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if ("dbidKey".equals(string)) {
                    String string2 = element2.getTextContent();
                    if (string2 == null || string2.length() <= 0) continue;
                    eDbid2.setDbidKey(string2.toUpperCase(Locale.JAPAN));
                    continue;
                }
                if ("title".equals(string)) {
                    eDbid2.setTitle(element2.getTextContent());
                    continue;
                }
                if ("url".equals(string)) {
                    eDbid2.setUrl(element2.getTextContent());
                    continue;
                }
                if ("user".equals(string)) {
                    eDbid2.setUser(element2.getTextContent());
                    continue;
                }
                if ("password".equals(string)) {
                    eDbid2.setPassword(element2.getTextContent());
                    continue;
                }
                if ("readonly".equals(string)) {
                    eDbid2.setReadonly(element2.getTextContent());
                    continue;
                }
                if ("mincount".equals(string)) {
                    eDbid2.setMincount(element2.getTextContent());
                    continue;
                }
                if ("maxcount".equals(string)) {
                    eDbid2.setMaxcount(element2.getTextContent());
                    continue;
                }
                if ("pooltime".equals(string)) {
                    eDbid2.setPooltime(element2.getTextContent());
                    continue;
                }
                if ("applicationInfo".equals(string)) {
                    eDbid2.setApplicationInfo(element2.getTextContent());
                    continue;
                }
                if ("property".equals(string)) {
                    eDbid2.addProp(element2.getTextContent());
                    continue;
                }
                System.err.println("\u8b66\u544a\uff1adbid \u306b\u65b0\u3057\u3044\u5c5e\u6027\u304c\u3001\u8ffd\u52a0\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
            this.dbidMap.put(eDbid2.getDbidKey(), eDbid2);
        }
        EDbid eDbid3 = this.dbidMap.get("DEFAULT");
        if (eDbid3 == null) {
            eDbid3 = eDbid.clone();
            eDbid3.setDbidKey("DEFAULT");
            this.dbidMap.put("DEFAULT", eDbid3);
        }
        if ((object = this.dbidMap.get("RESOURCE")) == null) {
            object = eDbid3.clone();
            ((EDbid)object).setDbidKey("RESOURCE");
            ((EDbid)object).setTitle("RESOURCE");
            this.dbidMap.put("RESOURCE", (EDbid)object);
        }
    }

    public static String[] getDbidInfoKeys() {
        return (String[])DBID_INFO_KEYS.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getDbidInfo() {
        Map<String, EDbid> map = this.dbidMap;
        synchronized (map) {
            String[][] stringArray = new String[this.dbidMap.size()][DBID_INFO_KEYS.length];
            int n = 0;
            for (EDbid eDbid : this.dbidMap.values()) {
                stringArray[n][0] = eDbid.getDbidKey();
                stringArray[n][1] = eDbid.getTitle();
                stringArray[n][2] = eDbid.getUrl();
                stringArray[n][3] = eDbid.getUser();
                stringArray[n][4] = eDbid.getPassword();
                stringArray[n][5] = String.valueOf(eDbid.isReadonly());
                stringArray[n][6] = String.valueOf(eDbid.getMincount());
                stringArray[n][7] = String.valueOf(eDbid.getMaxcount());
                stringArray[n][8] = String.valueOf(eDbid.getPooltime());
                stringArray[n][9] = String.valueOf(eDbid.isApplicationInfo());
                stringArray[n][10] = String.valueOf(eDbid.getProps().toString());
                ++n;
            }
            return stringArray;
        }
    }

    public void setDbidInfo(String[][] stringArray) {
        FileUtil.copy(this.xmlFilename, this.xmlFilename + "_" + System.currentTimeMillis());
        Document document = DomParser.read(new File(this.xmlFilename));
        Element element = document.getDocumentElement();
        this.deleteChildElements(element, "dbid");
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = document.createElement("dbid");
                for (int j = 0; j < stringArray[i].length; ++j) {
                    Element element3 = document.createElement(DBID_INFO_KEYS[j]);
                    element3.setTextContent(stringArray[i][j]);
                    element2.appendChild(element3);
                }
                element.appendChild(element2);
                element.appendChild(document.createTextNode("\n\n"));
            }
        }
        DomParser.write(new File(this.xmlFilename), document);
        this.reload();
    }

    public static String getDriverKey() {
        return DBDRIVER_CLASS_KEY;
    }

    public String[] getDriverList() {
        return this.driverList.toArray(new String[this.driverList.size()]);
    }

    public void setDriverList(String ... stringArray) {
        FileUtil.copy(this.xmlFilename, this.xmlFilename + "_" + System.currentTimeMillis());
        Document document = DomParser.read(new File(this.xmlFilename));
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagName("dbDriver").item(0);
        this.deleteChildElements(element2, DBDRIVER_CLASS_KEY);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                Element element3 = document.createElement(DBDRIVER_CLASS_KEY);
                element3.setTextContent(stringArray[i]);
                element2.appendChild(element3);
            }
        }
        DomParser.write(new File(this.xmlFilename), document);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodeKeyVal() {
        if (this.codeKeyVal == null) {
            StringBuilder stringBuilder = new StringBuilder(200);
            Map<String, EDbid> map = this.dbidMap;
            synchronized (map) {
                for (EDbid eDbid : this.dbidMap.values()) {
                    String string = eDbid.getDbidKey();
                    String string2 = StringUtil.nval(eDbid.getTitle(), string);
                    if (string2.indexOf(32) >= 0) {
                        stringBuilder.append('\"').append(string).append(':').append(string2).append('\"');
                    } else {
                        stringBuilder.append(string).append(':').append(string2);
                    }
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            this.codeKeyVal = stringBuilder.toString();
        }
        return this.codeKeyVal;
    }

    private void deleteChildElements(Element element, String string) {
        Node node = element.getFirstChild();
        boolean bl = false;
        while (node != null) {
            if (node.getNodeType() == 1) {
                bl = ((Element)node).getTagName().equalsIgnoreCase(string);
            }
            Node node2 = node.getNextSibling();
            if (bl) {
                element.removeChild(node);
            }
            node = node2;
        }
    }
}

