/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.javadoc.Tag;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.opengion.fukurou.taglet.DocletUtil;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;

public final class DocletTagWriter {
    private final PrintWriter outFile;
    private final boolean rtn2br;
    private static final String ENCODE = "UTF-8";
    public static final String BR = "&lt;br&gt;" + HybsConst.CR;

    public DocletTagWriter(String string) throws IOException {
        this(string, ENCODE, false);
    }

    public DocletTagWriter(String string, String string2) throws IOException {
        this(string, string2, false);
    }

    public DocletTagWriter(String string, String string2, boolean bl) throws IOException {
        this.outFile = FileUtil.getPrintWriter(new File(string), string2);
        this.rtn2br = bl;
    }

    public void close() {
        this.outFile.close();
    }

    public void printTag(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.rtn2br) {
                this.outFile.print(stringArray[i].replaceAll(HybsConst.CR, BR));
                continue;
            }
            this.outFile.print(stringArray[i]);
        }
        this.outFile.println();
    }

    public void printTag(Tag ... tagArray) {
        for (int i = 0; i < tagArray.length; ++i) {
            String string;
            Tag tag = tagArray[i];
            try {
                String string2 = tag.name();
                string = "";
                if ("@og.value".equalsIgnoreCase(string2)) {
                    string = DocletUtil.valueTag(tag);
                } else if ("@og.doc03Link".equalsIgnoreCase(string2)) {
                    string = DocletUtil.doc03LinkTag(tag);
                } else if ("Text".equalsIgnoreCase(string2)) {
                    string = StringUtil.htmlFilter(tag.text()).trim();
                } else {
                    this.printTag(tag.inlineTags());
                }
                if (this.rtn2br) {
                    this.outFile.print(string.replaceAll(HybsConst.CR, BR));
                    continue;
                }
                this.outFile.print(string);
                continue;
            }
            catch (Throwable throwable) {
                string = "\u51e6\u7406\u30a8\u30e9\u30fc:\u4f4d\u7f6e=" + tag.position() + HybsConst.CR + throwable.getMessage() + HybsConst.CR + tagArray[i];
                System.err.println(string);
            }
        }
    }

    public void printTag(String string, Tag[] tagArray, String string2) {
        this.outFile.print(string);
        this.printTag(tagArray);
        this.outFile.println(string2);
    }

    public void printCSVTag(Tag ... tagArray) {
        for (int i = 0; i < tagArray.length; ++i) {
            String string = StringUtil.htmlFilter(tagArray[i].text());
            if (i > 0) {
                this.outFile.print(",");
            }
            this.outFile.print(string);
        }
    }

    public void printTagsInfo(Tag ... tagArray) {
        for (int i = 0; i < tagArray.length; ++i) {
            String string = tagArray[i].name();
            if ("@og.rev".equalsIgnoreCase(string)) continue;
            this.outFile.print(string);
            this.outFile.print(" ");
            this.outFile.print(StringUtil.htmlFilter(tagArray[i].text()));
            if (this.rtn2br) {
                this.outFile.print(BR);
                continue;
            }
            this.outFile.println();
        }
    }

    public void printChar(String string, Tag[] tagArray, String string2) {
        String string3;
        this.outFile.print(string);
        if (tagArray.length > 0 && (string3 = tagArray[0].text()) != null && string3.length() > 0) {
            this.outFile.print(string3.charAt(0));
        }
        this.outFile.println(string2);
    }
}

