<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC30"
	title	= "対訳"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- 変更はここからです。 -->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command = "COPY" がセットされて遷移してくるので、複写画面となります。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" >
	<og:columnSet command="MODIFY" columnId="KBHORYU" action="SET" value="{@KBHORYU}" caseNN="{@KBHORYU}" />
</og:entry>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="LANG_YAKU" must="true" />
<og:columnEditor column="KBYAKU"	must="true" />
<og:columnEditor column="GENBUN"	must="true" size="100" />
<og:columnEditor column="YAKU"					size="100" />
<og:columnEditor column="COMMENTS"	editor="TEXTAREA" />

<!-- メッセージ表示を行います。必ずリソースファイルに表示するメッセージを登録し、 -->
<og:message command="{@command}" /><br />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

	<!-- 登録、取消、リセットボタンを作成します。 -->
	<og:writeCheck>
		<og:submit  action="ENTRY" />
		<og:submit  action="RESET" />
		<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
	</og:writeCheck>

	<!-- 入力画面を表示します。 -->
	<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
	<og:view
		viewFormType	= "HTMLFormatTable"
		command			= "{@command}"
		noWritable		= "{@noWritable}"
		columnWritable	= "{@columnWritable}"
		columnBulkSet	= "GENBUN,YAKU,KBHORYU,LANG_YAKU,SYSTEM_ID,KBYAKU,ID,KEYWORD"
		noDisplay		= "UNIQ,FGJ"
		startNo			= "{@startNo}" 
		pageSize		= "{@pageSize}"
		checked			= "{@checked}"
		rowspan			= "2"
	>
		<tr><td>[KBHORYU]  </td><td>[GENBUN]</td><td>[SYSTEM_ID]</td><td>[ID]     </td><td rowspan="2">[COMMENTS]</td></tr>
		<tr><td>[LANG_YAKU]</td><td>[YAKU]  </td><td>[KBYAKU]   </td><td>[KEYWORD]</td></tr>
	</og:view>

	<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
