/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.StringUtil;

public class Process_StringUtil
extends AbstractProcess
implements ChainProcess {
    private static final String STR_ACTION_BASE = "org.opengion.fukurou.process.Process_StringUtil$SU_";
    private String keys;
    private int[] clmNos;
    private boolean display;
    private boolean debug;
    private boolean firstRow = true;
    private int count;
    private StrAction stAction;
    private static final Map<String, String> MUST_PROPARTY = new LinkedHashMap<String, String>();
    private static final Map<String, String> USABLE_PROPARTY;

    public Process_StringUtil() {
        super("org.opengion.fukurou.process.Process_StringUtil", MUST_PROPARTY, USABLE_PROPARTY);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.keys = argument.getProparty("keys", this.keys);
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        String string = argument.getProparty("action");
        this.stAction = (StrAction)StringUtil.newInstance(STR_ACTION_BASE + string);
    }

    @Override
    public LineModel action(LineModel lineModel) {
        ++this.count;
        try {
            if (this.firstRow) {
                this.makeColumnNos(lineModel);
                this.firstRow = false;
                if (this.display) {
                    this.println(lineModel.nameLine());
                }
            }
            if (this.debug) {
                this.println("Before:" + lineModel.dataLine());
            }
            for (int i = 0; i < this.clmNos.length; ++i) {
                String string = (String)lineModel.getValue(this.clmNos[i]);
                lineModel.setValue(this.clmNos[i], this.stAction.change(string));
            }
            if (this.debug) {
                this.println("After :" + lineModel.dataLine());
            } else if (this.display) {
                this.println(lineModel.dataLine());
            }
        }
        catch (Throwable throwable) {
            String string = "row=[" + this.count + "]" + CR + "    data=[" + lineModel + "]" + CR;
            throw new OgRuntimeException(string, throwable);
        }
        return lineModel;
    }

    @Override
    public void end(boolean bl) {
        this.keys = null;
        this.clmNos = null;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + '\t' + "Output Count : " + this.count;
        return string;
    }

    private void makeColumnNos(LineModel lineModel) {
        String[] stringArray = StringUtil.csv2Array(this.keys);
        int n = stringArray.length;
        this.clmNos = new int[n];
        for (int i = 0; i < n; ++i) {
            this.clmNos[i] = lineModel.getColumnNo(stringArray[i]);
        }
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(500).append("Process_StringUtil \u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f\u30c7\u30fc\u30bf\u3092StringUtil\u30af\u30e9\u30b9\u306e\u7279\u5b9a\u306e").append(CR).append("\u30e1\u30bd\u30c3\u30c9\u3067\u30c7\u30fc\u30bf\u5909\u63db\u3059\u308b\u3001CainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append(CR).append("\u4e0a\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002)\u304b\u3089").append(CR).append(" LineModel \u3092\u5143\u306b\u3001\u6307\u5b9a\u306e\u30ab\u30e9\u30e0\u306e\u6587\u5b57\u3092\u3001\u5909\u63db\u3057\u307e\u3059\u3002").append(CR).append(CR).append("\u73fe\u6642\u70b9\u3067\u5229\u7528\u3067\u304d\u308bStringUtil \u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001\u4e0b\u8a18\u306e\u901a\u308a\u3067\u3059\u3002").append(CR).append("  urlEncode        : UTF-8 \u3067\u3001URL\u30a8\u30f3\u30b3\u30fc\u30c9\u3092\u884c\u3046\u3002").append(CR).append("  rTrim            : \u6587\u5b57\u5217\u306e\u5f8c\u308d\u306e\u30b9\u30da\u30fc\u30b9\u3092\u524a\u9664").append(CR).append("  htmlFilter       : HTML\u4e0a\u306e\u30a8\u30b9\u30b1\u30fc\u30d7\u6587\u5b57\u3092\u5909\u63db").append(CR).append("  code39           : CODE39 \u306e \u6587\u5b57\u5217\u3092\u4f5c\u6210(\u30c1\u30a7\u30c3\u30af\u30c7\u30b8\u30c3\u30c8\u4ed8\u304d)").append(CR).append("  getUnicodeEscape : HTML \u306e\u30a8\u30b9\u30b1\u30fc\u30d7\u8a18\u53f7(&amp;#xZZZZ;)\u306b\u5909\u63db").append(CR).append("  getReplaceEscape : HTML \u306e\u30a8\u30b9\u30b1\u30fc\u30d7\u8a18\u53f7(&amp;#xZZZZ;)\u3092\u623b\u3059").append(CR).append("  spanCut          : \u5f15\u6570\u304b\u3089span\u30bf\u30b0\u3092\u53d6\u308a\u9664\u304f").append(CR).append(CR).append("HybsCryptography \u306e\u30e1\u30bd\u30c3\u30c9\u3082\u547c\u3073\u51fa\u305b\u307e\u3059\u3002").append(CR).append("  getMD5           : MessageDigest\u306b\u3088\u308a\u3001MD5 \u3067\u30cf\u30c3\u30b7\u30e5\u3057\u305f\u6587\u5b57\u306b\u5909\u63db").append(CR).append("  encrypt          : Hybs\u72ec\u81ea\u306e\u6697\u53f7\u5316\u3092\u884c\u3044\u307e\u3059(Hybs\u5185\u90e8\u8a2d\u5b9a\u306e\u79d8\u5bc6\u9375)").append(CR).append("  decrypt          : Hybs\u72ec\u81ea\u306e\u5fa9\u53f7\u5316\u3092\u884c\u3044\u307e\u3059(Hybs\u5185\u90e8\u8a2d\u5b9a\u306e\u79d8\u5bc6\u9375)").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_StringUtil().usage());
    }

    static {
        MUST_PROPARTY.put("action", "StringUtil\u306e\u7279\u5b9a\u306e\u30e1\u30bd\u30c3\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059(\u5fc5\u9808)" + CR + "urlEncode , rTrim , htmlFilter , getMD5 , encrypt , decrypt , code39 , getUnicodeEscape , getReplaceEscape , spanCut");
        MUST_PROPARTY.put("keys", "\u5909\u63db\u3059\u308b\u30ab\u30e9\u30e0\u3092CSV\u5f62\u5f0f\u3067\u8907\u6570\u6307\u5b9a\u3067\u304d\u307e\u3059(\u5fc5\u9808)\u3002");
        USABLE_PROPARTY = new LinkedHashMap<String, String>();
        USABLE_PROPARTY.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + " (\u521d\u671f\u5024:false[\u8868\u793a\u3057\u306a\u3044])");
        USABLE_PROPARTY.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }

    public static class SU_decrypt
    extends StrAction {
        private HybsCryptography crpt;

        @Override
        public String change(String string) {
            if (this.crpt == null) {
                this.crpt = new HybsCryptography();
            }
            return this.crpt.decrypt(string);
        }
    }

    public static class SU_encrypt
    extends StrAction {
        private HybsCryptography crpt;

        @Override
        public String change(String string) {
            if (this.crpt == null) {
                this.crpt = new HybsCryptography();
            }
            return this.crpt.encrypt(string);
        }
    }

    public static class SU_getMD5
    extends StrAction {
        @Override
        public String change(String string) {
            return HybsCryptography.getMD5(string);
        }
    }

    public static class SU_spanCut
    extends StrAction {
        @Override
        public String change(String string) {
            return StringUtil.spanCut(string);
        }
    }

    public static class SU_getReplaceEscape
    extends StrAction {
        @Override
        public String change(String string) {
            return StringUtil.getReplaceEscape(string);
        }
    }

    public static class SU_getUnicodeEscape
    extends StrAction {
        @Override
        public String change(String string) {
            return StringUtil.getUnicodeEscape(string);
        }
    }

    public static class SU_code39
    extends StrAction {
        @Override
        public String change(String string) {
            return StringUtil.code39(string, true);
        }
    }

    public static class SU_htmlFilter
    extends StrAction {
        @Override
        public String change(String string) {
            return StringUtil.htmlFilter(string);
        }
    }

    public static class SU_rTrim
    extends StrAction {
        @Override
        public String change(String string) {
            return StringUtil.rTrim(string);
        }
    }

    public static class SU_urlEncode
    extends StrAction {
        @Override
        public String change(String string) {
            return StringUtil.urlEncode(string);
        }
    }

    public static class StrAction {
        public String change(String string) {
            return string;
        }
    }
}

