/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.HybsLoaderConfig;

public class HybsLoader {
    private static final String CONST_LOADER_KEY = "CONST_LOADER_KEY";
    private static final JavaCompiler COMPILER = ToolProvider.getSystemJavaCompiler();
    private static final StandardJavaFileManager FILE_MANAGER = COMPILER.getStandardFileManager(null, null, null);
    private final Map<String, HybsURLClassLoader> loaderMap = new WeakHashMap<String, HybsURLClassLoader>();
    private final Map<String, String> clsNameMap = new WeakHashMap<String, String>();
    private final String srcDir;
    private final String classDir;
    private final boolean isHotDeploy;
    private final boolean isAutoCompile;
    private final String classPath;

    public HybsLoader(HybsLoaderConfig hybsLoaderConfig) {
        this.srcDir = hybsLoaderConfig.getSrcDir();
        this.classDir = hybsLoaderConfig.getClassDir();
        this.isHotDeploy = hybsLoaderConfig.isHotDeploy();
        this.isAutoCompile = hybsLoaderConfig.isAutoCompile();
        this.classPath = hybsLoaderConfig.getClassPath();
    }

    public Class<?> load(String string) {
        String string2 = this.getQualifiedName(string);
        if (this.isAutoCompile) {
            this.compileClass(string2);
        }
        Class<?> clazz = this.loadClass(string2);
        return clazz;
    }

    public Object newInstance(String string) {
        Class<?> clazz = this.load(string);
        Object var3_3 = null;
        try {
            var3_3 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string2 = "\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]";
            throw new OgRuntimeException(string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string3 = "\u30a2\u30af\u30bb\u30b9\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002[" + string + "]";
            throw new OgRuntimeException(string3, illegalAccessException);
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQualifiedName(String string) {
        String string2 = null;
        if (string.indexOf(46) >= 0) {
            string2 = string;
        } else {
            Map<String, String> map = this.clsNameMap;
            synchronized (map) {
                string2 = this.clsNameMap.get(string);
                if (string2 == null) {
                    string2 = this.findFile("", string);
                }
                if (string2 == null) {
                    string2 = this.findFileByCls("", string);
                }
                this.clsNameMap.put(string, string2);
            }
            if (string2 == null) {
                throw new OgRuntimeException("\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb=[" + string + "]");
            }
        }
        return string2;
    }

    private String findFile(String string, String string2) {
        String string3 = this.srcDir + string;
        File[] fileArray = new File(string3).listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    String string4 = this.findFile(string + fileArray[i].getName() + File.separator, string2);
                    if (string4 == null || string4.length() <= 0) continue;
                    return string4;
                }
                if (!(string2 + ".java").equals(fileArray[i].getName())) continue;
                return string.replace(File.separatorChar, '.') + string2;
            }
        }
        return null;
    }

    private String findFileByCls(String string, String string2) {
        String string3 = this.classDir + string;
        File[] fileArray = new File(string3).listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    String string4 = this.findFile(string + fileArray[i].getName() + File.separator, string2);
                    if (string4 == null || string4.length() <= 0) continue;
                    return string4;
                }
                if (!(string2 + ".class").equals(fileArray[i].getName())) continue;
                return string.replace(File.separatorChar, '.') + string2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileClass(String string) {
        if (COMPILER == null) {
            throw new OgRuntimeException("\u30b3\u30f3\u30d1\u30a4\u30e9\u30af\u30e9\u30b9\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002tools.jar\u304c\u5b58\u5728\u3057\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
        }
        String string2 = this.srcDir + string.replace(".", File.separator) + ".java";
        File file = new File(string2);
        String string3 = this.classDir + string.replace(".", File.separator) + ".class";
        File file2 = new File(string3);
        if (!file.exists()) {
            if (file2.exists()) {
                return;
            }
            throw new OgRuntimeException("\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb=[" + string2 + "]");
        }
        if (file2.exists() && file.lastModified() <= file2.lastModified()) {
            return;
        }
        if (!file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            throw new OgRuntimeException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb=[" + file2 + "]");
        }
        StringWriter stringWriter = new StringWriter();
        File[] fileArray = new File[]{new File(string2)};
        String[] stringArray = new String[]{"-d", this.classDir, "-classpath", this.classPath, "-encoding", "UTF-8"};
        JavaCompiler.CompilationTask compilationTask = COMPILER.getTask(stringWriter, FILE_MANAGER, null, Arrays.asList(stringArray), null, FILE_MANAGER.getJavaFileObjects(fileArray));
        boolean bl = false;
        HybsLoader hybsLoader = this;
        synchronized (hybsLoader) {
            bl = compilationTask.call();
        }
        if (!bl) {
            throw new OgRuntimeException("\u30b3\u30f3\u30d1\u30a4\u30eb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + stringWriter.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(String string) {
        String string2 = this.classDir + string.replace(".", File.separator) + ".class";
        File file = new File(string2);
        if (!file.exists()) {
            throw new OgRuntimeException("\u30af\u30e9\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb=[" + string2 + "]");
        }
        long l = file.lastModified();
        HybsURLClassLoader hybsURLClassLoader = null;
        Object object = this.loaderMap;
        synchronized (object) {
            String string3 = this.isHotDeploy ? string : CONST_LOADER_KEY;
            hybsURLClassLoader = this.loaderMap.get(string3);
            if (hybsURLClassLoader == null || l > hybsURLClassLoader.getCreationTime()) {
                try {
                    hybsURLClassLoader = new HybsURLClassLoader(new URL[]{new File(this.classDir).toURI().toURL()}, Thread.currentThread().getContextClassLoader());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new OgRuntimeException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u306eURL\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb=[" + string2 + "]", malformedURLException);
                }
                this.loaderMap.put(string3, hybsURLClassLoader);
            }
        }
        try {
            object = hybsURLClassLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string4 = "\u30af\u30e9\u30b9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb=[" + string2 + "]";
            throw new OgRuntimeException(string4, classNotFoundException);
        }
        return object;
    }

    public String toString() {
        return "srcDir=" + this.srcDir + " , classDir=" + this.classDir;
    }

    private static final class HybsURLClassLoader {
        private final URLClassLoader loader;
        private final long creationTime;

        HybsURLClassLoader(URL[] uRLArray) {
            this(uRLArray, null);
        }

        HybsURLClassLoader(final URL[] uRLArray, final ClassLoader classLoader) {
            this.loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    return new URLClassLoader(uRLArray, classLoader);
                }
            });
            this.creationTime = System.currentTimeMillis();
        }

        Class<?> loadClass(String string) throws ClassNotFoundException {
            return this.loader.loadClass(string);
        }

        long getCreationTime() {
            return this.creationTime;
        }
    }
}

