/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.plugin.io.TableWriter_Default;

public class TableWriter_XML
extends TableWriter_Default {
    private static final String VERSION = "6.4.2.0 (2016/01/29)";
    private static final Map<String, String> KEYS_MAP = new LinkedHashMap<String, String>();
    private String tableName = "";
    private String firstExecSql = "";
    private String lastExecSql = "";
    private String mergeSql = "";

    @Override
    public void writeDBTable(PrintWriter printWriter) {
        super.setHeaderSequence("D");
        super.writeDBTable(printWriter);
    }

    protected void writeHeader(PrintWriter printWriter) {
        String string = this.getEncode();
        printWriter.println("<?xml version='1.0' encoding='" + string + "'?>");
    }

    @Override
    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = dBTableModel.getRowCount();
        boolean bl = this.isUseRenderer();
        printWriter.print("<ROWSET");
        printWriter.print(this.tableName);
        printWriter.println(">");
        printWriter.print(this.firstExecSql);
        printWriter.print(this.mergeSql);
        for (int i = 0; i < n; ++i) {
            printWriter.print("<ROW num=\"");
            printWriter.print(i + 1);
            printWriter.println("\">");
            for (int j = 0; j < this.numberOfColumns; ++j) {
                int n2 = this.clmNo[j];
                if (n2 < 0) continue;
                String string = (String)dBTableModel.getValue(i, n2);
                if (this.dbType[j] == 1) {
                    string = StringUtil.getReplaceEscape((String)string);
                } else if (bl) {
                    string = this.dbColumn[n2].getWriteValue(string);
                }
                printWriter.print("<");
                printWriter.print(dBTableModel.getColumnName(n2));
                printWriter.print(">");
                printWriter.print(StringUtil.htmlFilter((String)string));
                printWriter.print("</");
                printWriter.print(dBTableModel.getColumnName(n2));
                printWriter.println(">");
            }
            printWriter.println("</ROW>");
        }
        printWriter.print(this.lastExecSql);
        printWriter.println("</ROWSET>");
    }

    public void setParam(List<HybsEntry> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(200);
            StringBuilder stringBuilder2 = new StringBuilder(200);
            StringBuilder stringBuilder3 = new StringBuilder(200);
            for (HybsEntry hybsEntry : list) {
                String string = hybsEntry.getKey();
                this.checkParam(string, KEYS_MAP);
                String string2 = hybsEntry.getValue();
                if (string2 == null || string2.length() <= 0) continue;
                if ("TableName".equalsIgnoreCase(string)) {
                    this.tableName = " tableName=\"" + string2 + "\"";
                    continue;
                }
                if ("First".equalsIgnoreCase(string)) {
                    stringBuilder.append("<EXEC_SQL>");
                    stringBuilder.append(StringUtil.htmlFilter((String)string2));
                    stringBuilder.append("</EXEC_SQL>");
                    stringBuilder.append(CR);
                    continue;
                }
                if ("Last".equalsIgnoreCase(string)) {
                    stringBuilder2.append("<EXEC_SQL>");
                    stringBuilder2.append(StringUtil.htmlFilter((String)string2));
                    stringBuilder2.append("</EXEC_SQL>");
                    stringBuilder2.append(CR);
                    continue;
                }
                if (!"MergeSql".equalsIgnoreCase(string)) continue;
                stringBuilder3.append("<MERGE_SQL>");
                stringBuilder3.append(StringUtil.htmlFilter((String)string2));
                stringBuilder3.append("</MERGE_SQL>");
                stringBuilder3.append(CR);
            }
            this.firstExecSql = stringBuilder.toString();
            this.lastExecSql = stringBuilder2.toString();
            this.mergeSql = stringBuilder3.toString();
        }
    }

    static {
        KEYS_MAP.put("TABLENAME", "\u51e6\u7406\u3092\u5b9f\u65bd\u3059\u308b\u30c6\u30fc\u30d6\u30eb\u540d\u3092\u6307\u5b9a");
        KEYS_MAP.put("FIRST", "\u6700\u521d\u306b\u8a18\u8f09\u3057\u3066\u3001\u521d\u671f\u51e6\u7406(\u30c7\u30fc\u30bf\u30af\u30ea\u30a2\u7b49)\u3092\u5b9f\u884c\u3055\u305b\u308b\u3001EXEC_SQL\u3092\u6307\u5b9a");
        KEYS_MAP.put("LAST", "\u6700\u5f8c\u306b\u8a18\u8f09\u3057\u3066\u3001\u9805\u76ee\u306e\u8a2d\u5b9a(\u6574\u5408\u6027\u767b\u9332)\u3092\u884c\u3046\u3001EXEC_SQL\u3092\u6307\u5b9a");
        KEYS_MAP.put("MERGESQL", "\u3053\u306eSQL\u6587\u3067 UPDATE\u3057\u3066\u3001\u7d50\u679c\u304c\uff10\u4ef6\u306a\u3089INSERT\u3092\u884c\u3046\u3001MERGE_SQL\u3092\u6307\u5b9a");
    }
}

