/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.system.HybsConst;

public final class EnumType<T extends Comparable<T>> {
    private static final String SPACE = "    ";
    private final Map<String, Types<T>> typemap = new LinkedHashMap<String, Types<T>>();
    private final String title;
    private final T defVal;

    public EnumType(String string, T t) {
        this.title = string;
        this.defVal = t;
    }

    public EnumType<T> append(T t, String string) {
        this.typemap.put(String.valueOf(t).toUpperCase(Locale.JAPAN), new Types<T>(t, string));
        return this;
    }

    public T nval(String string) {
        if (string != null && string.length() > 0) {
            String string2 = string.toUpperCase(Locale.JAPAN);
            if (this.typemap.containsKey(string2)) {
                Types<T> types = this.typemap.get(string2);
                return (T)((Comparable)types.getKey());
            }
            String string3 = this.title + " \u7bc4\u56f2\u8a2d\u5b9a\u30a8\u30e9\u30fc" + HybsConst.CR + "\u5f15\u6570 [" + string + "] \u306f\u3001\u5185\u90e8\u306b\u30de\u30c3\u30d7\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + HybsConst.CR + this.toString();
            throw new IllegalArgumentException(string3);
        }
        return this.defVal;
    }

    public T getDefault() {
        return this.defVal;
    }

    public boolean contains(T t) {
        return t != null && this.typemap.containsKey(String.valueOf(t).toUpperCase(Locale.JAPAN));
    }

    public String toString() {
        Iterator<Types<T>> iterator = this.typemap.values().iterator();
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(HybsConst.CR);
        while (iterator.hasNext()) {
            stringBuilder.append(SPACE).append(iterator.next()).append(HybsConst.CR);
        }
        return stringBuilder.toString();
    }

    private static class Types<T> {
        private final T key;
        private final String msg;

        public Types(T t, String string) {
            if (t == null) {
                throw new IllegalArgumentException("key \u306b\u306f null \u3092\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            this.key = t;
            this.msg = string;
        }

        public T getKey() {
            return this.key;
        }

        public String getMsg() {
            return this.msg;
        }

        public String toString() {
            return this.key + " : " + this.msg;
        }
    }
}

