/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class TabLinkTag
extends CommonTagSupport {
    private static final String VERSION = "6.4.2.0 (2016/01/29)";
    private static final long serialVersionUID = 642020160129L;
    private static final String UL_TAG_START = "<ul class=\"tabList\">";
    private static final String UL_TAG_END = "</ul>";
    private static final String CHANGE_TAB_SCRIPT = "changeTab";
    private static final String INITIAL_TAB_SCRIPT = "initialTabSelect";
    private static final String FIRST_TAB_ID = "firstTab";
    private String query;
    private transient List<TabData> tabData = new ArrayList<TabData>();
    private LIST_TYPE type = LIST_TYPE.AUTO;
    private String href = "result.jsp";
    private String target = "RESULT";
    private boolean openTab = true;
    private String openTabName;
    private String[] constKeys;
    private String[] constVals;
    private int listCount = 10;
    private String selClass = "selTab";
    private String unselClass = "unselTab";
    private boolean isHorizontal = true;
    private String width = "auto";
    private String height = "auto";

    @Override
    public int doStartTag() {
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.query = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.type == LIST_TYPE.AUTO) {
            this.type = this.query == null || this.query.isEmpty() ? LIST_TYPE.TAG : (this.query.toUpperCase(Locale.JAPAN).indexOf("SELECT") >= 0 ? LIST_TYPE.DB : LIST_TYPE.TAG);
        }
        if (this.type == LIST_TYPE.DB) {
            this.makeTabsFromQuery();
        } else if (this.type == LIST_TYPE.TAG) {
            this.makeTabsFromTag();
        }
        if (!this.tabData.isEmpty()) {
            this.makeTag();
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.query = null;
        this.tabData = new ArrayList<TabData>();
        this.type = LIST_TYPE.AUTO;
        this.href = "result.jsp";
        this.target = "RESULT";
        this.openTab = true;
        this.openTabName = null;
        this.constKeys = null;
        this.constVals = null;
        this.listCount = 10;
        this.selClass = "selTab";
        this.unselClass = "unselTab";
        this.isHorizontal = true;
        this.width = "auto";
        this.height = "auto";
    }

    private void makeTabsFromQuery() {
        DBTableModel dBTableModel = DBTableModelUtil.makeDBTable(this.query, new String[0], this.getResource(), this.getApplicationInfo());
        if (dBTableModel == null || dBTableModel.getRowCount() == 0) {
            return;
        }
        boolean bl = dBTableModel.getColumnCount() > 1;
        boolean bl2 = dBTableModel.getColumnCount() > 2;
        boolean bl3 = dBTableModel.getColumnCount() > 3;
        boolean bl4 = dBTableModel.getColumnCount() > 4;
        boolean bl5 = dBTableModel.getColumnCount() > 5;
        int n = dBTableModel.getRowCount();
        String string = dBTableModel.getColumnName(0);
        for (int i = 0; i < n; ++i) {
            boolean bl6;
            boolean bl7 = bl6 = !(bl4 && !this.getUser().isAccess((String)dBTableModel.getValue(i, 4)) || bl5 && Boolean.valueOf((String)dBTableModel.getValue(i, 5)) == false);
            if (!bl6) continue;
            String string2 = (String)dBTableModel.getValue(i, 0);
            String string3 = bl ? StringUtil.nval((String)((String)dBTableModel.getValue(i, 1)), (String)string2) : string2;
            String string4 = bl2 ? StringUtil.nval((String)((String)dBTableModel.getValue(i, 2)), (String)this.href) : this.href;
            string4 = XHTMLTag.addUrlEncode((String)string4, (String)XHTMLTag.urlEncode((String)string, (String)string2));
            String string5 = bl3 ? StringUtil.nval((String)((String)dBTableModel.getValue(i, 3)), (String)this.unselClass) : this.unselClass;
            this.tabData.add(new TabData(string4, string2, string3, string5, bl6));
        }
    }

    private void makeTabsFromTag() {
    }

    protected void addTag(String string, String string2, String string3, String string4, boolean bl, String[] stringArray, String[] stringArray2) {
        String string5 = StringUtil.nval((String)string, (String)this.href);
        if (stringArray != null && stringArray.length > 0) {
            string5 = XHTMLTag.addUrlEncode((String)string5, (String)XHTMLTag.urlEncode((String[])stringArray, (String[])stringArray2));
        }
        if (bl) {
            this.tabData.add(new TabData(string5, string2, StringUtil.nval((String)string3, (String)this.getLabel(string2)), StringUtil.nval((String)string4, (String)this.unselClass), bl));
        }
    }

    private void makeTag() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(CR);
        boolean bl = false;
        for (int i = 0; i < this.tabData.size(); ++i) {
            TabData tabData = this.tabData.get(i);
            if (i % this.listCount == 0) {
                if (i > 0) {
                    stringBuilder.append(UL_TAG_END).append(CR);
                }
                stringBuilder.append(UL_TAG_START).append(CR);
            }
            if (!bl && tabData.visible && (this.openTabName == null || this.openTabName.isEmpty() || this.openTabName.equals(tabData.name))) {
                stringBuilder.append(tabData.makeLiTag(i, true));
                bl = true;
                continue;
            }
            stringBuilder.append(tabData.makeLiTag(i, false));
        }
        stringBuilder.append(UL_TAG_END).append(CR);
        if (this.openTab || this.openTabName != null && this.openTabName.length() > 0) {
            stringBuilder.append("<script type=\"text/javascript\">addEvent(window,\"load\", function() { initialTabSelect(");
            stringBuilder.append(this.openTab);
            stringBuilder.append("); } );</script>");
        }
        this.jspPrint(stringBuilder.toString());
    }

    public void setListType(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        try {
            this.type = LIST_TYPE.valueOf(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("listType \u306f");
            for (LIST_TYPE lIST_TYPE : LIST_TYPE.values()) {
                stringBuilder.append(',');
                stringBuilder.append(lIST_TYPE.name());
            }
            stringBuilder.append("\u304b\u3089\u9078\u3093\u3067\u304f\u3060\u3055\u3044\u3002");
            throw new HybsSystemException(stringBuilder.toString(), illegalArgumentException);
        }
    }

    public void setHref(String string) {
        this.href = StringUtil.nval((String)this.getRequestParameter(string), (String)this.href);
    }

    public void setTarget(String string) {
        this.target = StringUtil.nval((String)this.getRequestParameter(string), (String)this.target);
    }

    public void setOpenTab(String string) {
        this.openTab = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.openTab);
    }

    public void setOpenTabName(String string) {
        this.openTabName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.openTabName);
    }

    public void setConstKeys(String string) {
        this.constKeys = this.getCSVParameter(string);
    }

    public void setConstVals(String string) {
        this.constVals = this.getCSVParameter(string);
    }

    public void setListCount(String string) {
        this.listCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.listCount);
    }

    public void setSelClass(String string) {
        this.selClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.selClass);
    }

    public void setUnselClass(String string) {
        this.unselClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.unselClass);
    }

    public void setOrientation(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null && string2.length() > 0) {
            char c = string2.toUpperCase(Locale.JAPAN).charAt(0);
            if (c == 'H') {
                this.isHorizontal = true;
            } else if (c == 'V') {
                this.isHorizontal = false;
            } else {
                String string3 = "orientation \u306e\u6307\u5b9a\u306f\u3001H(orizontal) \u307e\u305f\u306f\u3001V(ertical) \u3067\u3059\u3002 orientation=" + string2;
                throw new HybsSystemException(string3);
            }
        }
    }

    public void setWidth(String string) {
        this.width = StringUtil.nval((String)this.getRequestParameter(string), (String)this.width);
    }

    public void setHeight(String string) {
        this.height = StringUtil.nval((String)this.getRequestParameter(string), (String)this.height);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.tabData = new ArrayList<TabData>();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("listType", (Object)this.type.toString()).println("href", (Object)this.href).println("target", (Object)this.target).println("openTab", (Object)this.openTab).println("openTabName", (Object)this.openTabName).println("constKeys", (Object[])this.constKeys).println("constVals", (Object[])this.constVals).println("listCount", (Object)this.listCount).println("selClass", (Object)this.selClass).println("unselClass", (Object)this.unselClass).println("isHorizontal", (Object)this.isHorizontal).println("width", (Object)this.width).println("height", (Object)this.height).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private final class TabData {
        private final String href;
        private final String name;
        private final String label;
        private final String clazz;
        private final boolean visible;

        public TabData(String string, String string2, String string3, String string4, boolean bl) {
            this.href = string;
            this.name = string2;
            this.label = string3;
            this.clazz = string4;
            this.visible = bl;
        }

        private String makeLiTag(int n, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(200).append("<li class=\"").append(this.clazz).append('\"').append(" style=\"").append(" width: ").append(TabLinkTag.this.width).append(';').append(" height: ").append(TabLinkTag.this.height).append(';');
            if (TabLinkTag.this.isHorizontal) {
                stringBuilder.append(" float: left;");
                if (n % TabLinkTag.this.listCount == 0) {
                    stringBuilder.append(" clear: left; margin-left: ").append(n / TabLinkTag.this.listCount * 10).append("px;");
                }
            }
            stringBuilder.append(" \">").append(this.makeLinkTag(bl)).append("</li>").append(CommonTagSupport.CR);
            return stringBuilder.toString();
        }

        private String makeLinkTag(boolean bl) {
            String string = XHTMLTag.addUrlEncode((String)this.href, (String)XHTMLTag.urlEncode((String[])TabLinkTag.this.constKeys, (String[])TabLinkTag.this.constVals));
            string = XHTMLTag.addUrlEncode((String)string, (String)("GAMENID=" + TabLinkTag.this.getGUIInfoAttri("KEY")));
            return new TagBuffer("a").add("href", string).add("name", this.name).add("target", TabLinkTag.this.target).add("onClick", "changeTab( this, \"" + TabLinkTag.this.selClass + "\" );").add("id", TabLinkTag.FIRST_TAB_ID, bl).addBody(this.label).makeTag();
        }
    }

    private static enum LIST_TYPE {
        AUTO,
        DB,
        TAG;

    }
}

