/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.FirstProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;

public class Process_LDAPReader
extends AbstractProcess
implements FirstProcess {
    private static final String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String PROVIDER = "ldap://ldap.opengion.org:389";
    private static final String PASSWORD = "password";
    private static final String SEARCH_BASE = "soouid=employeeuser,o=opengion,c=JP";
    private static final String ENTRYDN = "cn=inquiry-sys,o=opengion,c=JP";
    private static final String REFERRAL = "";
    private static final String[] SCOPE_LIST = new String[]{"OBJECT", "ONELEVEL", "SUBTREE"};
    private static final String SEARCH_SCOPE = "SUBTREE";
    private static final long COUNT_LIMIT = 0L;
    private static final boolean RETURN_OBJ_FLAG = false;
    private static final boolean DEREF_LINK_FLAG = false;
    private String filter;
    private int timeLimit;
    private String[] attrs;
    private String[] columns;
    private int executeCount;
    private int maxRowCount;
    private String[] matchKey;
    private boolean display;
    private boolean debug;
    private static final Map<String, String> MUST_PROPARTY = new LinkedHashMap<String, String>();
    private static final Map<String, String> USABLE_PROPARTY;
    private NamingEnumeration<SearchResult> nameEnum;
    private LineModel newData;
    private int count;

    public Process_LDAPReader() {
        super("org.opengion.fukurou.process.Process_LDAPReader", MUST_PROPARTY, USABLE_PROPARTY);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.timeLimit = argument.getProparty("timeLimit", this.timeLimit);
        this.maxRowCount = argument.getProparty("maxRowCount", this.maxRowCount);
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        this.attrs = StringUtil.csv2Array(argument.getProparty("attrs"));
        if (this.attrs.length == 0) {
            this.attrs = null;
        }
        this.columns = StringUtil.csv2Array(argument.getProparty("columns"));
        if (this.columns.length == 0) {
            this.columns = this.attrs;
        }
        if (this.attrs != null && this.attrs.length != this.columns.length) {
            String string = "attrs \u3068 columns \u3067\u6307\u5b9a\u306e\u5f15\u6570\u306e\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002 attrs=[" + argument.getProparty("attrs") + "] , columns=[" + argument.getProparty("columns") + "]";
            throw new OgRuntimeException(string);
        }
        HybsEntry[] hybsEntryArray = argument.getEntrys("match_");
        int n = hybsEntryArray.length;
        this.matchKey = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            this.matchKey[i] = null;
            for (int j = 0; j < n; ++j) {
                if (!this.columns[i].equalsIgnoreCase(hybsEntryArray[j].getKey())) continue;
                this.matchKey[i] = hybsEntryArray[j].getValue();
            }
        }
        this.filter = argument.getProparty("filter", this.filter);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = argument.getProparty("initctx ", INITCTX);
        hashtable.put("java.naming.factory.initial", string);
        String string2 = argument.getProparty("providerURL", PROVIDER);
        hashtable.put("java.naming.provider.url", string2);
        String string3 = argument.getProparty(PASSWORD, PASSWORD);
        hashtable.put("java.naming.security.credentials", string3);
        String string4 = argument.getProparty("entrydn", ENTRYDN);
        hashtable.put("java.naming.security.principal", string4);
        String string5 = argument.getProparty("referral", REFERRAL);
        hashtable.put("java.naming.referral", string5);
        try {
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String string6 = argument.getProparty("searchScope", SEARCH_SCOPE, SCOPE_LIST);
            SearchControls searchControls = new SearchControls(this.changeScopeString(string6), 0L, this.timeLimit, this.attrs, false, false);
            String string7 = argument.getProparty("searchbase", SEARCH_BASE);
            this.nameEnum = initialDirContext.search(string7, this.filter, searchControls);
        }
        catch (NamingException namingException) {
            String string8 = "NamingException !" + namingException.getMessage();
            throw new OgRuntimeException(string8, namingException);
        }
    }

    @Override
    public void end(boolean bl) {
        try {
            if (this.nameEnum != null) {
                this.nameEnum.close();
                this.nameEnum = null;
            }
        }
        catch (NamingException namingException) {
            throw new OgRuntimeException("\u30c7\u30a3\u30b9\u30b3\u30cd\u30af\u30c8\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002", namingException);
        }
    }

    @Override
    public boolean next() {
        try {
            return this.nameEnum != null && this.nameEnum.hasMore();
        }
        catch (NamingException namingException) {
            throw new OgRuntimeException("\u30cd\u30af\u30b9\u30c8\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002", namingException);
        }
    }

    @Override
    public LineModel makeLineModel(int n) {
        ++this.count;
        try {
            if (this.maxRowCount > 0 && this.maxRowCount <= this.executeCount) {
                return null;
            }
            SearchResult searchResult = this.nameEnum.next();
            Attributes attributes = searchResult.getAttributes();
            if (this.newData == null) {
                this.newData = this.createLineModel(attributes);
                if (this.display) {
                    this.println(this.newData.nameLine());
                }
            }
            StringBuilder stringBuilder = new StringBuilder(200);
            for (int i = 0; i < this.attrs.length; ++i) {
                Attribute attribute = attributes.get(this.attrs[i]);
                if (attribute == null) continue;
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                stringBuilder.setLength(0);
                if (namingEnumeration.hasMore()) {
                    this.getDataChange(namingEnumeration.next(), stringBuilder);
                }
                while (namingEnumeration.hasMore()) {
                    stringBuilder.append(',');
                    this.getDataChange(namingEnumeration.next(), stringBuilder);
                }
                String string = stringBuilder.toString();
                String string2 = this.matchKey[i];
                if (string2 != null && string != null && !string.matches(string2)) {
                    return null;
                }
                this.newData.setValue(i, string);
                ++this.executeCount;
            }
            this.newData.setRowNo(n);
            if (this.display) {
                this.println(this.newData.dataLine());
            }
        }
        catch (NamingException namingException) {
            String string = "\u30c7\u30fc\u30bf\u3092\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + n + "]\u4ef6\u76ee";
            if (this.newData != null) {
                string = string + this.newData.toString();
            }
            throw new OgRuntimeException(string, namingException);
        }
        return this.newData;
    }

    private StringBuilder getDataChange(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            return stringBuilder;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            char[] cArray = new char[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                cArray[i] = (char)byArray[i];
            }
            stringBuilder.append(cArray);
        } else {
            stringBuilder.append(object);
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineModel createLineModel(Attributes attributes) {
        LineModel lineModel = new LineModel();
        try {
            if (this.attrs == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                try (NamingEnumeration<String> namingEnumeration = attributes.getIDs();){
                    while (namingEnumeration.hasMore()) {
                        arrayList.add(namingEnumeration.next());
                    }
                }
                this.attrs = arrayList.toArray(new String[arrayList.size()]);
                this.columns = this.attrs;
            }
            int n = this.columns.length;
            lineModel.init(n);
            for (int i = 0; i < n; ++i) {
                lineModel.setName(i, StringUtil.nval(this.columns[i], this.attrs[i]));
            }
        }
        catch (NamingException namingException) {
            throw new OgRuntimeException("ResultSetMetaData \u304b\u3089\u3001\u30ab\u30e9\u30e0\u540d\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", namingException);
        }
        return lineModel;
    }

    private int changeScopeString(String string) {
        int n;
        if ("OBJECT".equals(string)) {
            n = 0;
        } else if ("ONELEVEL".equals(string)) {
            n = 1;
        } else if (SEARCH_SCOPE.equals(string)) {
            n = 2;
        } else {
            String string2 = "Search Scope in \u300eOBJECT\u300f\u300eONELEVEL\u300f\u300eSUBTREE\u300fSelected[" + string + "]";
            throw new OgRuntimeException(string2);
        }
        return n;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + '\t' + "Search Filter : " + this.filter + CR + '\t' + "Input Count   : " + this.count;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(500).append("Process_LDAPReader\u306f\u3001LDAP\u304b\u3089\u8aad\u307f\u53d6\u3063\u305f\u5185\u5bb9\u3092\u3001LineModel \u306b\u8a2d\u5b9a\u5f8c\u3001").append(CR).append("\u4e0b\u6d41\u306b\u6e21\u3059\u3001FirstProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append(CR).append("LDAP\u304b\u3089\u8aad\u307f\u53d6\u3063\u305f\u5185\u5bb9\u3088\u308a\u3001LineModel\u3092\u4f5c\u6210\u3057\u3001\u4e0b\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306f\u3001").append(CR).append("\u30c1\u30a7\u30a4\u30f3\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002)\u306b\u6e21\u3057\u307e\u3059\u3002").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_LDAPReader().usage());
    }

    static {
        MUST_PROPARTY.put("filter", "\u691c\u7d22\u6761\u4ef6(\u5fc5\u9808) \u4f8b: (&(objectClass=person)(|(belongOUID=61200)(belongOUID=61100)))");
        USABLE_PROPARTY = new LinkedHashMap<String, String>();
        USABLE_PROPARTY.put("initctx", "\u521d\u671f\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u30d5\u30a1\u30af\u30c8\u30ea\u3002" + CR + " (\u521d\u671f\u5024:com.sun.jndi.ldap.LdapCtxFactory)");
        USABLE_PROPARTY.put("providerURL", "\u30b5\u30fc\u30d3\u30b9\u30d7\u30ed\u30d0\u30a4\u30c0\u30ea (\u521d\u671f\u5024:ldap://ldap.opengion.org:389)");
        USABLE_PROPARTY.put("entrydn", "\u5c5e\u6027\u306e\u53d6\u5f97\u5143\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u540d\u524d\u3002" + CR + " (\u521d\u671f\u5024:cn=inquiry-sys,o=opengion,c=JP)");
        USABLE_PROPARTY.put(PASSWORD, "\u5c5e\u6027\u306e\u53d6\u5f97\u5143\u306e\u30d1\u30b9\u30ef\u30fc\u30c9(\u521d\u671f\u5024:******)");
        USABLE_PROPARTY.put("searchbase", "\u691c\u7d22\u3059\u308b\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u306e\u30d9\u30fc\u30b9\u540d\u3002" + CR + " (\u521d\u671f\u5024:soouid=employeeuser,o=opengion,c=JP)");
        USABLE_PROPARTY.put("searchScope", "\u691c\u7d22\u7bc4\u56f2\u3002\u300eOBJECT\u300f\u300eONELEVEL\u300f\u300eSUBTREE\u300f\u306e\u3069\u308c\u304b\u3002" + CR + " (\u521d\u671f\u5024:SUBTREE)");
        USABLE_PROPARTY.put("timeLimit", "\u7d50\u679c\u304c\u8fd4\u3055\u308c\u308b\u307e\u3067\u306e\u30df\u30ea\u79d2\u6570\u30020 \u306e\u5834\u5408\u7121\u5236\u9650(\u521d\u671f\u5024:0)");
        USABLE_PROPARTY.put("attrs", "\u30a8\u30f3\u30c8\u30ea\u3068\u4e00\u7dd2\u306b\u8fd4\u3055\u308c\u308b\u5c5e\u6027\u306e\u8b58\u5225\u5b50\u3002null \u306e\u5834\u5408\u3059\u3079\u3066\u306e\u5c5e\u6027");
        USABLE_PROPARTY.put("columns", "\u5c5e\u6027\u306e\u8b58\u5225\u5b50\u306b\u5bfe\u3059\u308b\u5225\u540d\u3002\u8b58\u5225\u5b50\u3068\u540c\u3058\u5834\u5408\u306f\u300e,\u300f\u306e\u307f\u3067\u533a\u5207\u308b\u3002");
        USABLE_PROPARTY.put("maxRowCount", "\u6700\u5927\u691c\u7d22\u6570(0\u306f\u7121\u5236\u9650)  (\u521d\u671f\u5024:0)");
        USABLE_PROPARTY.put("match_", "\u6307\u5b9a\u306e\u30ab\u30e9\u30e0\u3068\u6b63\u898f\u8868\u73fe\u3067\u4e00\u81f4\u6642\u306e\u307f\u51e6\u7406" + CR + " ( -match_LANG=ABC=[a-zA-Z]* \u306a\u3069\u3002)");
        USABLE_PROPARTY.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        USABLE_PROPARTY.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

