/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.system;

import java.util.LinkedHashSet;
import org.opengion.fukurou.system.HybsConst;

public final class ThrowUtil {
    private static final int MAX_NORMAL_STACK = 3;
    private static final StackTraceElement ST_TR_EL = new StackTraceElement("...", "", "", 0);

    private ThrowUtil() {
    }

    public static String ogStackTrace(Throwable throwable) {
        return ThrowUtil.ogStackTrace(null, throwable);
    }

    public static String ogStackTrace(String string, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(200).append("Error  :").append(throwable).append(HybsConst.CR).append("Version:").append("openGion 6.4.2.0 Release6 Builds (2016029)");
        if (string != null) {
            stringBuilder.append(HybsConst.CR).append("Message:").append(string);
        }
        Throwable throwable2 = throwable;
        while (throwable2 != null) {
            for (StackTraceElement stackTraceElement : ThrowUtil.getStackTrace(throwable2)) {
                stringBuilder.append(HybsConst.CR).append("    at ").append(stackTraceElement);
            }
            if ((throwable2 = throwable2.getCause()) == null) continue;
            stringBuilder.append(HybsConst.CR).append("Cause  :").append(throwable2);
        }
        return stringBuilder.append(HybsConst.CR).toString();
    }

    private static StackTraceElement[] getStackTrace(Throwable throwable) {
        LinkedHashSet<StackTraceElement> linkedHashSet = new LinkedHashSet<StackTraceElement>();
        if (throwable != null) {
            int n = 0;
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                if (n++ < 3) {
                    linkedHashSet.add(stackTraceElement);
                    continue;
                }
                String string = stackTraceElement.getClassName();
                if (string.contains("org.opengion")) {
                    linkedHashSet.add(stackTraceElement);
                    continue;
                }
                linkedHashSet.add(ST_TR_EL);
            }
        }
        return linkedHashSet.toArray(new StackTraceElement[linkedHashSet.size()]);
    }

    public static String ogThrowMsg(String string) {
        return ThrowUtil.ogThrowMsg(string, null);
    }

    public static String ogThrowMsg(String string, Throwable throwable) {
        Throwable throwable2 = throwable == null ? new Throwable() : throwable;
        StringBuilder stringBuilder = new StringBuilder(200).append("Error  :").append(throwable).append(HybsConst.CR).append("Version:").append("openGion 6.4.2.0 Release6 Builds (2016029)");
        if (string != null) {
            stringBuilder.append(HybsConst.CR).append("Message:").append(string);
        }
        int n = 0;
        for (StackTraceElement stackTraceElement : ThrowUtil.getStackTrace(throwable2)) {
            stringBuilder.append(HybsConst.CR).append("    at ").append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append('(').append(stackTraceElement.getFileName()).append(':').append(stackTraceElement.getLineNumber()).append(')');
            if (n++ >= 3) break;
        }
        return stringBuilder.append(HybsConst.CR).toString();
    }
}

