/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.resource.ResourceManager;

public final class ResourceFactory {
    private static final String SYSTEM_ID = HybsSystem.sys("SYSTEM_ID");
    private static final ResourceManager JA_MANAGER = new ResourceManager(SYSTEM_ID, "ja", true);
    private static final Map<String, ResourceManager> POOL = Collections.synchronizedMap(new HashMap());

    private ResourceFactory() {
    }

    public static ResourceManager newInstance(String string) {
        return string == null || "ja".equalsIgnoreCase(string) ? JA_MANAGER : ResourceFactory.newInstance(SYSTEM_ID, string, true);
    }

    public static ResourceManager newInstance(String string, String string2, boolean bl) {
        String string3;
        String string4 = string == null ? SYSTEM_ID : string;
        String string5 = string3 = string2 == null ? "ja" : string2;
        if (SYSTEM_ID.equalsIgnoreCase(string4) && "ja".equalsIgnoreCase(string3)) {
            return JA_MANAGER;
        }
        String string6 = string4 + string3;
        ResourceManager resourceManager = POOL.get(string6);
        if (resourceManager == null) {
            resourceManager = new ResourceManager(string4, string3, bl);
            POOL.put(string6, resourceManager);
        }
        return resourceManager;
    }

    public static void clear() {
        JA_MANAGER.clear();
        Set<String> set = POOL.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            ResourceManager resourceManager = POOL.remove(stringArray[i]);
            resourceManager.clear();
        }
        POOL.clear();
    }

    public static void guiClear() {
        JA_MANAGER.guiClear();
        Set<String> set = POOL.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            ResourceManager resourceManager = POOL.get(stringArray[i]);
            resourceManager.guiClear();
        }
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                ResourceFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }
}

