/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.db;

import org.opengion.fukurou.db.ApplicationInfo;

/**
 * Transaction インターフェースを継承した、リアルタイムトランザクションクラスです。
 *
 * これは、トランザクション処理のためのクラスというより、トランザクション処理を行わない
 * コネクションを、共通的に使用する為のクラスになります。
 * つまり、Connection のラップクラスになります。
 * ただし、このクラスが生成されてから、クローズされるまでは、内部に保留した Connection は、
 * ずっと使い続けられますので、ConnectionFactory から取り出した Connection と同様に
 * トランザクション性は維持されます。
 * このクラスでは、close()処理で、commit/rollback が実行されます。
 *
 * 6.3.6.1 (2015/08/28)
 *   selectを実行した後で明示的にcommit,rollbackを行わないのはOracle位
 *   らしいので、検索終了時でも、commit か、rollback を行うようにします。
 *   つまり、commit されない(=途中で処理が打ち切られた)場合は、
 *   rollback するように仕様変更しますので、Transactionオブジェクトを
 *   呼び出した処理の最後には、検索であろうとなかろうと、commit()を入れてください。
 *   ただし、Transaction オブジェクトは、DBアクセス以外にも適用可能に
 *   作成しているため、Connection がある場合のみ、実際の commit/rollback が
 *   実行されます。
 *
 * @og.rev 5.1.9.0 (2010/08/01) 新規作成
 * @og.rev 5.3.8.0 (2011/08/01) クラスの内部構造変更
 *
 * @version  5.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK6.0,
 */
public class TransactionReal extends TransactionImpl {

	/**
	 * ApplicationInfo を指定して作成する、コンストラクター
	 *
	 * このクラスは、トランザクション処理をしない場合に、従来の Connection の
	 * 代わりに使用することを想定したクラスのオブジェクトを作成します。
	 *
	 * @og.rev 5.3.7.0 (2011/07/01) dbidを引数から削除
	 * @og.rev 5.3.8.0 (2011/08/01) 親クラスを呼ぶように変更
	 *
	 * @param	appInfo	内部統制用のアクセス情報
	 */
	public TransactionReal( final ApplicationInfo appInfo ) {
		super( appInfo );
	}

//	/**
//	 * コネクションの、終了時処理を行います。
//	 *
//	 * 引数は、正常かどうかを判定するフラグです。異常の場合は、true をセットします。
//	 * これは、ConnectionFactory のプールに戻すかどうかを判断するのに使われます。
//	 * 一度でも、エラーが発生したコネクションは、破棄します。
//	 * それ以外は、プールに戻します。
//	 *
//	 * @og.rev 5.3.7.0 (2011/07/01) close時に、コネクションを null 化しておく。
//	 * @og.rev 5.3.8.0 (2011/08/01) 終了処理を行い、親クラスのrealClose() を呼ぶ。
//	 * @og.rev 6.3.6.1 (2015/08/28) AutoCloseable の close() メソッドに対応。廃止
//	 *
//	 * @param	errFlag  [true:エラー状態/false:通常]
//	 *
//	 * @return 正常:true/異常:false
//	 */
//	@Override
//	public boolean close( final boolean errFlag ) {
//		// 5.3.8.0 (2011/08/01) 終了処理を行い、親クラスのrealClose() を呼ぶ。
//		super.close( errFlag );
//		finish();
//		realClose();
//
//		return true;
//	}

	/**
	 * コネクションの、終了時処理を行います。
	 *
	 * 毎回クローズ処理を行う事になります。
	 * ここで、commit されていれば、実際の commit が行われます。
	 * commit が行われていない場合は、rollback が実行されます。
	 * Connectionは、ConnectionFactory のプールに戻されます。
	 * ただし、明示的に rollback が実行された場合は、rollback 処理後に
	 * コネクションは、破棄します。
	 *
	 * @og.rev 6.3.6.1 (2015/08/28) AutoCloseable の close() メソッドに対応。
	 */
	@Override
	public void close() {
		// 5.3.8.0 (2011/08/01) 終了処理を行い、親クラスのrealClose() を呼ぶ。
		finish();
//		realClose();
	}
}
