/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.report;

import java.util.Map;

import org.opengion.hayabusa.db.DBTableModel;

/**
 * RFID発行処理のためのBPELサービスを起動するためのインターフェースです。
 *
 * @og.group 帳票システム
 *
 * @version  4.0
 * @author   Hiroki Nakamura
 * @since    JDK5.0,
 */
public interface RFIDPrintPointService {

	/**
	 * 帳票起動された要求番号をセットします。
	 *
	 * @param   ykno 要求NO
	 */
	void setYkno( String ykno ) ;

	/**
	 * システムIDをセットします。
	 *
	 * @param   systemId システムID
	 */
	void setSystemId( String systemId ) ;

	/**
	 * 実行方法をセットします。
	 *
	 * @param   fgrun 実行方法
	 */
	void setFgrun( String fgrun ) ;

	/**
	 * 帳票デーモンが実行されているホスト名をセットします。
	 *
	 * @param   hostName ホスト名
	 */
	void setHostName( String hostName ) ;

	/**
	 * プリンター名をセットします。
	 *
	 * @param   printerName プリンタ名
	 */
	void setPrinterName( String printerName ) ;

	/**
	 * DBTableModel をセットします。
	 *
	 * @param	table	DBTableModelオブジェクト
	 */
	void setTable( DBTableModel table ) ;

	/**
	 * RFIDのレイアウトデータをセットします。
	 * キーはカラム名です。
	 * 値はGE58で定義された出力区分及びパラメーターの配列です。
	 * 配列の各インデックス番号の意味は、RFIDPrintRequestを参照して下さい。
	 *
	 * @og.rev 6.4.3.1 (2016/02/12) 実態を、HashMap → ConcurrentHashMap に置き換えたので、key,val ともに not null 制限です。
	 *
	 * @param   layout RFIDレイアウト
	 */
	void setLayout( Map<String, String[]> layout ) ;

	/**
	 * REPORT_RFID_SERVICE_CLASSから起動するプログラムのディレクトリをセットします。
	 *
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 * @param	dir	PG起動ディレクトリ
	 */
	void setPrgDir( String dir );

	/**
	 * REPORT_RFID_SERVICE_CLASSから起動するプログラムをセットします。
	 *
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 * @param	file	PGファイル名
	 */
	void setPrgFile( String file );

	/**
	 * ファイル出力時のディレクトリを指定します。
	 *
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 * @param	dir	出力ディレクトリ
	 */
	void setOutDir( String dir );

	/**
	 * プリンタIDをセットします。
	 *
	 * @og.rev 5.4.3.0 (2011/12/26) _DEFAULT対応
	 * @param	id	プリンタID
	 */
	void setPrtId( String id );

	/**
	 * プリンターポート名をセットします。
	 *
	 * @og.rev 5.4.3.1 (2011/12/27)
	 * @param	port	ポート名
	 */
	void setPortnm( String port ) ;

	/**
	 * 帳票IDをセットします。
	 *
	 * @og.rev 5.4.3.4 (2012/01/12)
	 * @param	id	帳票ID
	 */
	void setListId( String id ) ;

	/**
	 * レイアウトファイルをセットします。
	 *
	 * @og.rev 5.4.3.9 (2012/01/25) 追加要望
	 * @param	file	レイアウトファイル
	 */
	void setLayoutFile( String file );

	/**
	 * 現在の印刷状況を返します。
	 *
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 *
	 * @return	完成フラグ
	 */
	String getFgkan();

	/**
	 * エラーメッセージを返します。
	 *
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 *
	 * @return	エラーメッセージ
	 */
	String getErrMsg();

	/**
	 * RFID発行処理を実行します。
	 *
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID voidからbooleanに変更
	 *
	 * @return	実行結果[true:正常/false:異常]
	 */
	// void execute() ;
	boolean execute() ;
}
