<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false"/>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "FAQ"
	title	= "標準(FAQ表示)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>

<!-- この画面限定動作、スタイルのためとりあえずcommonには持ち込みません -->
<script style="text/javascript">
	$(function(){
	     $("#qtable a").click(function(){
	     $('html,body').animate({ scrollTop: $($(this).attr("href")).offset().top-60 }, 'fast','swing');
	     $('#back-title-link a').attr('href','#'+$(this).attr('id'));
	     $('#back-title-link').css('display','block');
	     return false;
	     })
	});

	$(function(){
	     $("#back-title-link a").click(function(){
	     $('html,body').animate({ scrollTop: $($(this).attr("href")).offset().top-60 }, 'fast','swing');
	     $('#back-title-link').css('display','none');
	     return false;
	     })
	});

</script>

<!-- 明細ｽﾀｲﾙ指定-->
<style type="text/css">
	div#atable{
		padding:2px;
	}
	div#qtable{
		padding:2px;
	}
	div.FAQBUNRUI1	{
		font-weight:bold;
		font-size:medium;
		width:80%;
		border-left: 5px solid #1e50a2;
		border-bottom: 1px solid #1e50a2;
		margin:4px;
		padding:5px;
	}
	div.FAQBUNRUI2	{
		font-weight:bold;
		 font-size:small;
		 text-indent:1em;
		 margin:4px;
	}
	div.FAQBUNRUI3	{
		font-weight:bold;
		text-indent:1em;
		font-size:x-small;
	}
	div.FAQ_TITLEWRAP{
		margin:5px 0 0 0;
	}
	div.FAQTITLE{
		border-left: 5px solid #d3381c;
		padding-left: 5px;
		margin:5px 0px 0px 2em;
		font-weight:bold;
		font-size:small;
	}
	div#atable div.FAQTITLE{
		color:#17184b;
	}
	span.FAQNO{
		font-size:small;
		margin-left:15px;
	}
	div.FAQNAIYO	{
		
		margin-left:2em;
		margin-bottom:15px;
		padding-left:5px;
		border-left: 1px solid #ce5242;
		border-bottom: 1px solid #ce5242;
		width:90%
	}
	pre {
		white-space: -moz-pre-wrap; /* Mozilla */
		white-space: -pre-wrap;     /* Opera 4-6 */
		white-space: -o-pre-wrap;   /* Opera 7 */
		white-space: pre-wrap;      /* CSS3 */
		word-wrap: break-word;      /* IE 5.5+ */
	}

</style>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- とりあえず小分類が増えた時の事は考えずに作成します -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="request" dbid="RESOURCE">
		SELECT	 CDBNRUI
				,TITLE
				,NAIYO
				,QANO
		FROM	GE80
		WHERE	SYSTEM_ID	IN	('{@SYS.SYSTEM_ID}','**')
		<og:where startKey="and">
			<og:and value = "FGJ		=	 '1'"			/>	<!-- GE80(FAQ)》状態ﾌﾗｸﾞ IN ('0','1')	-->
			<og:and value = "KBFAQ		=	 '0'"			/>	<!-- GE80(FAQ)》FAQ区分 = '0'			-->
			<og:and value = "KNRNGUI	like '{@KNRNGUI}'"	/>	<!-- GE80(関連画面ID)					-->
			<og:and value = "CDBNRUI	like '{@CDBNRUI}%'"	/>	<!-- GE80(分類CD)						-->
		</og:where>
		<og:appear startKey = "order by" value = "{@ORDER_BY}"
					defaultVal = "SEQNO" />
</og:query>
<og:columnEditor columns="NAIYO" renderer="PRE" scope="request" />
<og:columnEditor columns="CDBNRUI" renderer="DBMENU" scope="request" addKeyLabel="true"
	param="select CDBNRUI,TITLE from GE80 WHERE KBFAQ!='0' AND FGJ IN ('0','1') AND SYSTEM_ID='{@SYS.SYSTEM_ID}' ORDER BY SEQNO"
/>

<!-- ViewMarkerTag	-->
<og:viewMarker command="{@command}">
	<!-- 分類名-->
	<og:columnMarker column="CDBNRUI">
		<div class="FAQBUNRUI1">[CDBNRUI]</div>
	</og:columnMarker>
	<!-- ﾀｲﾄﾙ-->
	<og:columnMarker column="TITLE">
		<div class="FAQTITLE">[TITLE]<span class="FAQNO"><og:message lbl="MSG0084" val0="[QANO]"/></span></div>
	</og:columnMarker>
	<!-- 内容-->
	<og:columnMarker column="NAIYO">
		<span class="FAQNAIYO">[NAIYO]</span>
	</og:columnMarker>
</og:viewMarker>

<!-- 上矢印 -->
<div style="position:fixed;top:10px;right:10px;display:none;" id="back-title-link">
	<a href="#faqtable"><og:img src="{@SYS.JSP}/image/arrow-up.png" alt="back to question"/></a>
</div>

<!-- DB検索結果を表示させます。 -->
<og:img src="{@SYS.JSP}/image/speech-balloon-orange-q48.png" alt="Question" />
<div id="qtable">
<og:view
	viewFormType = "CustomData" 
	command      = "{@command}" 
	writable     = "false"
	columnGroup  = "CDBNRUI"
	useAfterHtmlTag  = "false"
	noDisplay    = ""
	scope="request">
	<og:thead rowspan="1">
		<tr><td><!-- --></td></tr>
	</og:thead>
	<!-- 分類表示	-->
	<og:tbody rowspan="1">
			[CDBNRUI]				<!-- 分類-->
			<div class="FAQ_TITLEWRAP"><a href="#[$QANO]" id="[$QANO]TITLE">[$TITLE]</a></div>	<!-- ﾀｲﾄﾙ-->
	</og:tbody>
</og:view>
</div>

<!-- DB検索結果を表示させます。 -->
<hr width="95%"/>
<og:img src="{@SYS.JSP}/image/speech-balloon-green-a48.png" alt="Answer" />
<div id="atable">
<og:view
	viewFormType = "CustomData" 
	command      = "VIEW" 
	writable     = "false"
	useAfterHtmlTag  = "false"
	columnGroup  = "CDBNRUI"
	noDisplay    = ""
	scope="request">
	<og:thead rowspan="1">
		<tr><td><!-- --></td></tr>
	</og:thead>
	<!-- 分類表示	-->
	<og:tbody rowspan="1">
			[TITLE]
			[CDBNRUI]				<!-- 分類-->
			<div class="FAQ_TITLEWRAP">[$TITLE]</div>	<!-- ﾀｲﾄﾙ-->
		<div  id="[$QANO]">
			<div class="FAQNAIYO">[$NAIYO]</div>													<!-- 内容-->
		</div>
	</og:tbody>
</og:view>
</div>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
