/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.FileUtil;

public class CommentLineParser {
    private final List<CommentSet> cmntSetList;

    public CommentLineParser(String string) {
        String string2;
        String string3 = string2 = string == null ? "null" : string.toLowerCase(Locale.JAPAN);
        this.cmntSetList = "sql , tri , spc".contains(string2) ? Arrays.asList(new CommentSet("--", "/*", "*/")) : ("xml , htm , html".contains(string2) ? Arrays.asList(new CommentSet("//", "/*", "*/"), new CommentSet(null, "<!--", "-->")) : ("jsp".contains(string2) ? Arrays.asList(new CommentSet("//", "/*", "*/"), new CommentSet(null, "<!--", "-->"), new CommentSet("--", "/*", "*/"), new CommentSet(null, "<og:comment", "/>", "</og:comment>"), new CommentSet(null, "comment=\"", "\"")) : Arrays.asList(new CommentSet("//", "/*", "*/"))));
    }

    public String line(String string) {
        String string2 = string;
        for (CommentSet commentSet : this.cmntSetList) {
            string2 = this.line(string2, commentSet);
        }
        return string2;
    }

    private String line(String string, CommentSet commentSet) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (!commentSet.checkEsc(c)) {
                if (commentSet.isBlockIn(string, n)) {
                    int n3 = commentSet.blockOut(string, n);
                    if (n3 < 0) break;
                    n = n3;
                    continue;
                }
                if (commentSet.isLineCmnt(string, n)) break;
            }
            stringBuilder.append(c);
        }
        for (n = stringBuilder.length(); 0 < n && stringBuilder.charAt(n - 1) <= ' '; --n) {
        }
        stringBuilder.setLength(n);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java org.opengion.fukurou.util.CommentLineParser inFile outFile [encode] [-rowTrim]");
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        String string = "UTF-8";
        boolean bl = false;
        for (int i = 2; i < stringArray.length; ++i) {
            if ("-rowTrim".equalsIgnoreCase(stringArray[i])) {
                bl = true;
                continue;
            }
            string = stringArray[i];
        }
        BufferedReader bufferedReader = FileUtil.getBufferedReader(file, string);
        PrintWriter printWriter = FileUtil.getPrintWriter(file2, string);
        CommentLineParser commentLineParser = new CommentLineParser(FileInfo.getSUFIX(file));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = commentLineParser.line(string2);
                if (bl && string2.isEmpty()) continue;
                printWriter.println(string2);
            }
        }
        catch (CharacterCodingException characterCodingException) {
            String string3 = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + " [" + file.getPath() + "] , Encode=[" + string + "]";
            throw new OgRuntimeException(string3, characterCodingException);
        }
        catch (IOException iOException) {
            String string4 = "\u30d5\u30a1\u30a4\u30eb\u30b3\u30d4\u30fc\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n inFile=[" + file + "] , outFile=[" + file2 + "]\n";
            throw new OgRuntimeException(string4, iOException);
        }
        finally {
            Closer.ioClose(bufferedReader);
            Closer.ioClose(printWriter);
        }
    }

    private static final class CommentSet {
        private final String LINE_CMNT;
        private final String BLOCK_CMNT1;
        private final String[] BLOCK_CMNT2;
        private static final char ESC_CHAR1 = '\"';
        private static final char ESC_CHAR2 = '\'';
        private static final char CHAR_ESC = '\\';
        private boolean escIn1;
        private boolean escIn2;
        private boolean chEsc;
        private boolean isBlkIn;

        CommentSet(String string, String string2, String ... stringArray) {
            this.LINE_CMNT = string;
            this.BLOCK_CMNT1 = string2;
            this.BLOCK_CMNT2 = stringArray;
        }

        boolean checkEsc(char c) {
            if (this.isBlkIn || this.chEsc) {
                this.chEsc = false;
            } else {
                boolean bl = this.chEsc = '\\' == c;
                if (!this.escIn2 && '\"' == c) {
                    boolean bl2 = this.escIn1 = !this.escIn1;
                }
                if (!this.escIn1 && '\'' == c) {
                    this.escIn2 = !this.escIn2;
                }
            }
            return this.escIn1 || this.escIn2;
        }

        boolean isBlockIn(String string, int n) {
            if (!this.isBlkIn) {
                this.isBlkIn = string.startsWith(this.BLOCK_CMNT1, n);
            }
            return this.isBlkIn;
        }

        boolean isLineCmnt(String string, int n) {
            return this.LINE_CMNT != null && string.startsWith(this.LINE_CMNT, n);
        }

        int blockOut(String string, int n) {
            int n2 = string.length();
            for (String string2 : this.BLOCK_CMNT2) {
                int n3 = string.indexOf(string2, n + this.BLOCK_CMNT1.length());
                if (n3 < 0 || n3 >= n2) continue;
                n2 = n3 + string2.length();
                this.isBlkIn = false;
            }
            return this.isBlkIn ? -1 : n2;
        }
    }
}

