/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.FileString;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class URLCheckFilter
implements Filter {
    private static final HybsCryptography HYBS_CRYPTOGRAPHY = new HybsCryptography(HybsSystem.sys("URL_CHECK_CRYPT"));
    private String filename = "jsp/custom/refuseAccess.html";
    private boolean isDebug;
    private boolean isDecode = true;
    private String ignoreURL;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isValidAccess(servletRequest)) {
            servletResponse.setContentType("text/html; charset=UTF-8");
            PrintWriter printWriter = servletResponse.getWriter();
            printWriter.println(this.refuseMsg());
            printWriter.flush();
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) {
        this.filename = HybsSystem.getRealPath() + StringUtil.nval((String)filterConfig.getInitParameter("filename"), (String)this.filename);
        this.isDecode = StringUtil.nval((String)filterConfig.getInitParameter("decode"), (boolean)true);
        this.ignoreURL = filterConfig.getInitParameter("ignoreURL");
        this.isDebug = StringUtil.nval((String)filterConfig.getInitParameter("debug"), (boolean)false);
    }

    public void destroy() {
    }

    private String refuseMsg() {
        FileString fileString = new FileString();
        fileString.setFilename(this.filename);
        fileString.setEncode("UTF-8");
        return fileString.getValue();
    }

    private boolean isValidAccess(ServletRequest servletRequest) {
        boolean bl;
        block14: {
            String string;
            if (this.isDebug) {
                System.out.println(((HttpServletRequest)servletRequest).getRequestURI());
            }
            if ((string = servletRequest.getParameter("h_urlCheck")) == null || string.isEmpty()) {
                if (this.isDebug) {
                    System.out.println("  check NG [ No Check Key ]");
                }
                return false;
            }
            bl = false;
            try {
                string = HYBS_CRYPTOGRAPHY.decrypt(string).replace("&amp;", "&");
                if (this.isDebug) {
                    System.out.println("  checkKey=" + string);
                }
                int n = string.lastIndexOf(",time=");
                int n2 = string.lastIndexOf(",userid=");
                String string2 = string.substring(0, n);
                long l = Long.parseLong(string.substring(n + 6, n2));
                String string3 = string.substring(n2 + 8);
                String[] stringArray = StringUtil.csv2Array((String)string3);
                if (this.ignoreURL != null && this.ignoreURL.length() > 0 && string2.indexOf(this.ignoreURL) == 0) {
                    string2 = string2.substring(this.ignoreURL.length());
                }
                if (this.isDebug) {
                    System.out.println("   [ignoreURL]=" + this.ignoreURL);
                    System.out.println("   [url]      =" + string2);
                    System.out.println("   [vtime]    =" + l);
                    System.out.println("   [userid]   =" + string3);
                }
                String string4 = ((HttpServletRequest)servletRequest).getRequestURL().toString() + "?" + ((HttpServletRequest)servletRequest).getQueryString();
                if (this.isDecode) {
                    if (this.isDebug) {
                        System.out.println("[BeforeURIDecode]=" + string4);
                    }
                    string4 = StringUtil.urlDecode((String)string4);
                    string2 = StringUtil.urlDecode((String)string2);
                }
                string4 = string4.substring(0, string4.lastIndexOf("h_urlCheck") - 1);
                String string5 = ((HttpServletRequest)servletRequest).getRemoteUser();
                if (this.isDebug) {
                    System.out.println("   [reqURL] =" + string4);
                    System.out.println("   [ctime]  =" + System.currentTimeMillis());
                    System.out.println("   [reqUser]=" + string5);
                }
                if (!string4.endsWith(string2) || System.currentTimeMillis() - l >= 0L || stringArray == null || stringArray.length <= 0) break block14;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!"*".equals(stringArray[i]) && !string5.equals(stringArray[i])) continue;
                    bl = true;
                    if (this.isDebug) {
                        System.out.println("  check OK");
                    }
                    break;
                }
            }
            catch (RuntimeException runtimeException) {
                if (this.isDebug) {
                    String string6 = "\u30c1\u30a7\u30c3\u30af\u30a8\u30e9\u30fc\u3002  checkKey=" + string + " " + runtimeException.getMessage();
                    System.out.println(string6);
                    System.err.println(ThrowUtil.ogStackTrace((Throwable)runtimeException));
                }
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("UrlCheckFilter").append("filename=[").append(this.filename).append("],").append("isDecode=[").append(this.isDecode).append(']');
        return stringBuilder.toString();
    }
}

