/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * クロス集計テーブル作成クラス用のパラメータ定数設定クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public static final で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.rev 3.5.4.0 (2003/11/25) 新規作成
 * @og.rev 5.0.0.3 (2009/09/22) FIRST_CLM_GOKEI_KEY追加
 * @og.group その他
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public final class ViewCrossTableParam {

	/** パラメータ定数 {@value} */
	public static final String SHOKEI	= "row_hs" ;
	/** パラメータ定数 {@value} */
	public static final String HEADER1	= "row_h1" ;
	/** パラメータ定数 {@value} */
	public static final String HEADER2	= "row_h2" ;

	/** パラメータ定数 {@value} */
	public static final String BREAK_COLUMN_KEY		= "h_breakColumn" ;
	/** パラメータ定数 {@value} */
	public static final String NO_GROUP_COLUMNS_KEY = "h_noGroupColumns" ;
	/** パラメータ定数 {@value} */
	public static final String SUM_NUMBER_KEY		= "h_sumNumber"   ;
	/** パラメータ定数 {@value} */
	public static final String CUBE_X_COLUMN_KEY	= "h_cubeXColumn" ;
	/** パラメータ定数 {@value} */
	public static final String CUBE_Y_COLUMN_KEY	= "h_cubeYColumn" ;
	/** パラメータ定数 {@value} */
	public static final String SHOKEI_LABEL_KEY 	= "h_shokeiLabel" ;
	/** パラメータ定数 {@value} */
	public static final String GOKEI_LABEL_KEY		= "h_gokeiLabel"  ;
	/** パラメータ定数 {@value} */
	public static final String CUBE_SORT_TYPE_KEY	= "h_cubeSortType" ;
	/** パラメータ定数 {@value} */
	public static final String GOKEI_SORT_DIR_KEY	= "h_gokeiSortDir" ;
	/** パラメータ定数 {@value} */
	public static final String FIRST_CLM_GOKEI_KEY	= "h_firstClmGokei" ;	// 5.0.0.3 (2009/09/22)
	/** パラメータ定数 {@value} */
	public static final String USE_HEADER_COLUMN	= "h_useHeaderColumn" ;	// 5.2.2.0 (2010/11/01)
	/** パラメータ定数 {@value} */
	public static final String USE_CLASS_ADD		= "h_useClassAdd" ;		// 5.2.2.0 (2010/11/01)
	/** パラメータ定数 {@value} */
	public static final String SAVE_TABLEID_KEY 	= "h_saveTableId" ;		// 5.2.2.0 (2010/11/01)
	/** パラメータ定数 {@value} */
	public static final String SAVE_SCOPE_KEY		= "h_saveScope" ;		// 5.2.2.0 (2010/11/01)
	/** パラメータ定数 {@value} */
	public static final String USE_HEADER_RSC		= "h_useHeaderResource" ;	// 5.5.5.0 (2012/07/20)
	/** パラメータ定数 {@value} */
	public static final String HEADER_CODE_KEY		= "h_headerCode" ;		// 5.5.5.0 (2012/07/20)

	/**
	 * デフォルトコンストラクター
	 * 定数クラスなので、オブジェクトを生成できないように、private にしておきます。
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	private ViewCrossTableParam() {
		super();		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	}
}
