/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.ModifyFileFilter;

public final class HybsFileFilter
implements FileFilter {
    private final List<FileFilter> list = new ArrayList<FileFilter>();
    private final boolean isUseDIR;
    private final boolean isUseFile;
    private final boolean ignoreCase;

    public HybsFileFilter() {
        this("false", true);
    }

    public HybsFileFilter(String string, boolean bl) {
        this.ignoreCase = bl;
        this.isUseDIR = "true".equalsIgnoreCase(string) || "only".equalsIgnoreCase(string);
        this.isUseFile = "true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string);
    }

    @Override
    public boolean accept(File file) {
        if (file != null && (file.isFile() && this.isUseFile || file.isDirectory() && this.isUseDIR)) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                FileFilter fileFilter = this.list.get(i);
                if (fileFilter.accept(file)) continue;
                return false;
            }
        }
        return true;
    }

    public HybsFileFilter addFileFilter(FileFilter fileFilter) {
        if (fileFilter != null) {
            this.list.add(fileFilter);
        }
        return this;
    }

    public HybsFileFilter startsWith(String string) {
        return this.startsWith(string, false);
    }

    public HybsFileFilter startsWith(String string, boolean bl) {
        if (string != null) {
            this.list.add(new StartsWithFilter(string, bl, this.ignoreCase));
        }
        return this;
    }

    public HybsFileFilter startsDir(String string) {
        return this.startsDir(string, false);
    }

    public HybsFileFilter startsDir(String string, boolean bl) {
        if (string != null) {
            this.list.add(new StartsDirFilter(string, bl, this.ignoreCase));
        }
        return this;
    }

    public HybsFileFilter endsWith(String string) {
        return this.endsWith(string, false);
    }

    public HybsFileFilter endsWith(String string, boolean bl) {
        if (string != null) {
            this.list.add(new EndsWithFilter(string, bl, this.ignoreCase));
        }
        return this;
    }

    public HybsFileFilter instr(String string) {
        return this.instr(string, false);
    }

    public HybsFileFilter instr(String string, boolean bl) {
        if (string != null) {
            this.list.add(new InstrFilter(string, bl, this.ignoreCase));
        }
        return this;
    }

    public HybsFileFilter fileEquals(String string) {
        return this.fileEquals(string, false);
    }

    public HybsFileFilter fileEquals(String string, boolean bl) {
        if (string != null) {
            this.list.add(new EqualsFilter(string, bl, this.ignoreCase));
        }
        return this;
    }

    public HybsFileFilter matches(String string) {
        return this.matches(string, false);
    }

    public HybsFileFilter matches(String string, boolean bl) {
        if (string != null) {
            this.list.add(new MatchesFilter(string, bl, this.ignoreCase));
        }
        return this;
    }

    public HybsFileFilter lastModified(String string) {
        if (string != null) {
            this.list.add(new ModifyFileFilter(string));
        }
        return this;
    }

    private long getByteSize(String string) {
        if (string == null) {
            return -1L;
        }
        String string2 = string;
        int n = string2.length();
        if (n > 0 && 'B' == string2.charAt(n - 1)) {
            string2 = string2.substring(0, n - 1);
            --n;
        }
        long l = -1L;
        long l2 = -1L;
        if (n > 0) {
            char c = string2.charAt(n - 1);
            switch (c) {
                case 'K': {
                    l2 = 1024L;
                    break;
                }
                case 'M': {
                    l2 = 0x100000L;
                    break;
                }
                case 'G': {
                    l2 = 0x40000000L;
                    break;
                }
            }
            if (l2 > 0L) {
                string2 = string2.substring(0, n - 1);
                --n;
            } else {
                l2 = 1L;
            }
        }
        if (n > 0) {
            l = l2 * Long.parseLong(string2);
        }
        return l;
    }

    public HybsFileFilter isLarger(String string) {
        long l = this.getByteSize(string);
        if (l >= 0L) {
            this.list.add(new IsLargerFilter(l));
        }
        return this;
    }

    public HybsFileFilter isSmaller(String string) {
        long l = this.getByteSize(string);
        if (l >= 0L) {
            this.list.add(new IsSmallerFilter(l));
        }
        return this;
    }

    public HybsFileFilter isHidden(String string) {
        return this.isHidden(string, false);
    }

    public HybsFileFilter isHidden(String string, boolean bl) {
        if (string != null) {
            this.list.add(new IsHiddenFilter(string, bl));
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("no[").append(i).append("]=");
            stringBuilder.append(this.list.get(i)).append(HybsConst.CR);
        }
        return stringBuilder.toString();
    }

    private static final class IsHiddenFilter
    implements FileFilter {
        private final boolean flg;
        private final boolean rvse;

        IsHiddenFilter(String string, boolean bl) {
            this.flg = Boolean.parseBoolean(string);
            this.rvse = bl;
        }

        @Override
        public boolean accept(File file) {
            return file.isHidden() ^ !this.flg ^ this.rvse;
        }
    }

    private static final class IsSmallerFilter
    implements FileFilter {
        private final long size;

        IsSmallerFilter(long l) {
            this.size = l;
        }

        @Override
        public boolean accept(File file) {
            return file.length() < this.size;
        }
    }

    private static final class IsLargerFilter
    implements FileFilter {
        private final long size;

        IsLargerFilter(long l) {
            this.size = l;
        }

        @Override
        public boolean accept(File file) {
            return file.length() >= this.size;
        }
    }

    private static final class MatchesFilter
    implements FileFilter {
        private final Pattern pattern;
        private final boolean rvse;

        MatchesFilter(String string, boolean bl, boolean bl2) {
            this.pattern = bl2 ? Pattern.compile(string, 2) : Pattern.compile(string);
            this.rvse = bl;
        }

        @Override
        public boolean accept(File file) {
            Matcher matcher = this.pattern.matcher(file.getName());
            return matcher.find() ^ this.rvse;
        }
    }

    private static final class EqualsFilter
    implements FileFilter {
        private final String[] eqstr;
        private final int cnt;
        private final boolean rvse;
        private final boolean igCase;

        EqualsFilter(String string, boolean bl, boolean bl2) {
            this.rvse = bl;
            this.igCase = bl2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.eqstr = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                this.eqstr[i] = stringTokenizer.nextToken();
            }
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            for (int i = 0; i < this.cnt; ++i) {
                if (!(this.igCase ? string.equalsIgnoreCase(this.eqstr[i]) : string.equals(this.eqstr[i]))) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static final class InstrFilter
    implements FileFilter {
        private final String[] instr;
        private final int cnt;
        private final boolean rvse;
        private final boolean igCase;

        InstrFilter(String string, boolean bl, boolean bl2) {
            this.rvse = bl;
            this.igCase = bl2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.instr = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                String string2 = stringTokenizer.nextToken();
                this.instr[i] = this.igCase ? string2.toLowerCase(Locale.JAPAN) : string2;
            }
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            String string2 = this.igCase ? string.toLowerCase(Locale.JAPAN) : string;
            for (int i = 0; i < this.cnt; ++i) {
                if (string2.indexOf(this.instr[i]) < 0) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static final class EndsWithFilter
    implements FileFilter {
        private final String[] sfix;
        private final int cnt;
        private final boolean rvse;
        private final boolean igCase;

        EndsWithFilter(String string, boolean bl, boolean bl2) {
            this.rvse = bl;
            this.igCase = bl2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.sfix = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                String string2 = stringTokenizer.nextToken();
                this.sfix[i] = this.igCase ? string2.toLowerCase(Locale.JAPAN) : string2;
            }
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            String string2 = this.igCase ? string.toLowerCase(Locale.JAPAN) : string;
            for (int i = 0; i < this.cnt; ++i) {
                if (!string2.endsWith(this.sfix[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static final class StartsDirFilter
    implements FileFilter {
        private final String[] pfix;
        private final int cnt;
        private final boolean rvse;
        private final boolean igCase;

        StartsDirFilter(String string, boolean bl, boolean bl2) {
            this.rvse = bl;
            this.igCase = bl2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.pfix = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                String string2 = stringTokenizer.nextToken();
                this.pfix[i] = this.igCase ? string2.toLowerCase(Locale.JAPAN) : string2;
            }
        }

        @Override
        public boolean accept(File file) {
            File file2 = file.getParentFile();
            if (file2 != null && file2.isDirectory()) {
                String string = file2.getName();
                String string2 = this.igCase ? string.toLowerCase(Locale.JAPAN) : string;
                for (int i = 0; i < this.cnt; ++i) {
                    if (!string2.startsWith(this.pfix[i])) continue;
                    return !this.rvse;
                }
            }
            return this.rvse;
        }
    }

    private static final class StartsWithFilter
    implements FileFilter {
        private final String[] pfix;
        private final int cnt;
        private final boolean rvse;
        private final boolean igCase;

        StartsWithFilter(String string, boolean bl, boolean bl2) {
            this.rvse = bl;
            this.igCase = bl2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.pfix = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                String string2 = stringTokenizer.nextToken();
                this.pfix[i] = this.igCase ? string2.toLowerCase(Locale.JAPAN) : string2;
            }
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            String string2 = this.igCase ? string.toLowerCase(Locale.JAPAN) : string;
            for (int i = 0; i < this.cnt; ++i) {
                if (!string2.startsWith(this.pfix[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }
}

