<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9110"
	title	= "標準(タグ)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- SELECT文は、キー、日時、状況コードが、必須項目 -->
		select 	NAME_JA AS KEY ,DYSET , LABEL_NAME as flag ,
				 CLM ,DYUPD
		from GF41
		where SYSTEM_ID = 'XX'
		order by 1,2
</og:query>

<og:columnEditor column="KEY" label="登録完了" />

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "ImageTimeBar"
	command    = "{@command}"
	noDisplay  = "{@extDisplay}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	useParam   = "true" >
	<og:timeBarParam
		startDate		= "{@startDate}"
		timeSpan		= "{@timeSpan}"
		useLegend		= "{@useLegend}"
		maxLabelWidth	= "{@maxLabelWidth}"
		maxTimeWidth	= "{@maxTimeWidth}"
		chartHeight		= "{@chartHeight}"
		headerHeight	= "{@headerHeight}"
		padding			= "{@padding}"
		margin			= "{@margin}"
		useLastData		= "{@useLastData}"
	/>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
