/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.business;

import org.opengion.fukurou.system.OgRuntimeException ;		// 6.4.2.0 (2016/01/29)

/**
 * カーソル定義による配列型テーブルモデルをメインカーソルとした業務ロジックの構造を定義します。
 *
 * 配列型テーブルモデルについては、cursor()メソッドを実装により定義します。
 * cursor()メソッドを実装し、この戻り値をSQL文として実行し、その結果セットから配列型
 * テーブルモデルを生成し、これをメインカーソルとして使用します。
 * 配列型テーブルモデルが定義されていない場合、エラーとなります。
 *
 * このクラスでは、以下に示すメソッドが呼び出されるタイミングのみを定義しています。
 * メソッドの中身については、{@link BizLogic_TABLE}を参照して下さい。
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 * @og.group 業務ロジック
 *
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class BizLogic_CURSOR extends BizLogic_TABLE {

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public BizLogic_CURSOR() {
		super();		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	}

	/**
	 * 配列型テーブルモデルを生成するためのSQL文を定義します。
	 * このメソッドからSQL文から返された場合、この結果セットから配列型テーブルモデルを生成し、
	 * メインカーソルとして使用します。
	 *
	 * @return 配列型テーブルモデルを生成するためのSQL文
	 */
	protected String cursor() {
		return null;
	}

	/**
	 * 処理のメインロジックの前処理を記述します。
	 *
	 * @og.rev 5.6.7.0 (2013/07/27) Exception を throw するとき、一旦、errMsg 変数にセットします。
	 *
	 * このメソッド自体は、protected属性であるため、サブクラスから直接参照することができます。
	 * 但し、これは、各業務ロジックで直接参照することを想定したものではなく、BizLogicの
	 * メイン構造を拡張するサブクラスを定義する際に使用することを想定しています。
	 * (この想定がなければ、本来は、package privateにすべきです)
	 * このため、業務ロジックを各実装クラスでは直接参照しないで下さい。
	 */
	@Override
	protected void init() {
		if( cursor() == null ) {
			// 5.6.7.0 (2013/07/27) Exception を throw するとき、一旦、errMsg 変数にセットします。
			final String errMsg = "カーソルが定義されていません。" ;
			throw new OgRuntimeException( errMsg );
		}
		table = createTableBySql( cursor() );
	}

	/**
	 * このクラスは、テーブルモデルが外部から指定されている必要はありません。
	 *
	 * このメソッド自体は、protected属性であるため、サブクラスから直接参照することができます。
	 * 但し、これは、各業務ロジックで直接参照することを想定したものではなく、BizLogicの
	 * メイン構造を拡張するサブクラスを定義する際に使用することを想定しています。
	 * (この想定がなければ、本来は、package privateにすべきです)
	 * このため、業務ロジックを各実装クラスでは直接参照しないで下さい。
	 *
	 * @see AbstractBizLogic#isRequireTable()
	 *
	 * @return	テーブルモデルが外部から指定されているかどうか(常にfalse)
	 */
	@Override
	protected boolean isRequireTable() {
		return false;
	}
}
