<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP14"
	title    = "RFIDレイアウト"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここからです。 -->
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_CLM" value="COLUMN_NAME" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_CLM" value="CLM" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。-->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DBを検索するための SQL文を記述します。 debug="true" で画面からSQL文を確認できます。 -->
<og:query command = "{@command}" debug="{@debug}">
		select
			B.LISTID,B.{@C_CLM} CLM,KBOUT,A.SEQ,B.SYSTEM_ID,
			DATA1,DATA2,DATA3,DATA4,DATA5,DATA6,DATA7,DATA8,DATA9,DATA10,
			DATA11,DATA12,DATA13,DATA14,DATA15,
			B.FGJ,B.DYSET,B.DYUPD,B.USRSET,B.USRUPD,B.PGUPD
		from GE58 B LEFT JOIN GE52 A ON (A.{@C_CLM} = B.{@C_CLM} AND A.SYSTEM_ID = B.SYSTEM_ID AND A.LISTID = B.LISTID AND A.KBTEXT = 'B')

	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "B.KBOUT = '{@KBOUT}'" />
		<og:and value = "B.SYSTEM_ID = '{@SYSTEM_ID}'"		/>
		<og:and value = "B.LISTID LIKE '{@LISTID}'"			/>
		<og:and value = "B.{@C_CLM} LIKE '{@CLM}'"	/>
		<og:and value = "B.FGJ in ('0','1')" />
		<og:and value = "B.DYUPD  &gt;= '{@DYUPDFROM}'"  />
		<og:and value = "B.DYUPD  &lt;= '{@DYUPDTO}99'"  />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@ORDER_BY}" defaultVal="SYSTEM_ID,LISTID,KBTEXT,SEQ" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="SYSTEM_ID"	must="true" />
<og:columnEditor column="LISTID"	must="true" />
<og:columnEditor column="CLM"		must="true" />
<og:columnEditor column="KBOUT"		must="true" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="Z" />

</og:writeCheck>

<a href="./datax.htm" target="_blank"><strong>【DATA入力形式一覧】</strong></a>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}" 
	pageSize     = "{@pageSize}"
/>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
