/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import java.io.UnsupportedEncodingException;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.GDSWarning;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscStmtHandle;
import org.firebirdsql.gds.IscSvcHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.impl.AbstractGDS;
import org.firebirdsql.gds.impl.AbstractIscTrHandle;
import org.firebirdsql.gds.impl.DatabaseParameterBufferExtension;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.impl.jni.BlobParameterBufferImp;
import org.firebirdsql.gds.impl.jni.DatabaseParameterBufferImp;
import org.firebirdsql.gds.impl.jni.EventHandleImp;
import org.firebirdsql.gds.impl.jni.ServiceParameterBufferImp;
import org.firebirdsql.gds.impl.jni.ServiceRequestBufferImp;
import org.firebirdsql.gds.impl.jni.TransactionParameterBufferImpl;
import org.firebirdsql.gds.impl.jni.isc_blob_handle_impl;
import org.firebirdsql.gds.impl.jni.isc_db_handle_impl;
import org.firebirdsql.gds.impl.jni.isc_stmt_handle_impl;
import org.firebirdsql.gds.impl.jni.isc_svc_handle_impl;
import org.firebirdsql.gds.impl.jni.isc_tr_handle_impl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class BaseGDSImpl
extends AbstractGDS {
    private static Logger log = LoggerFactory.getLogger(BaseGDSImpl.class, false);
    private static final String WARNING_CONNECT_TIMEOUT_NATIVE = "WARNING: The native driver does not apply connectTimeout for establishing the socket connection (only for protocol negotiation with the Firebird server), it will not detect unreachable hosts within the specified timeout";
    protected static final byte[] DESCRIBE_DATABASE_INFO_BLOCK = new byte[]{62, 103, 32, 33, 11, 102, 13, 1};
    private static byte[] stmtInfo = new byte[]{23, 21, 1};
    private static int INFO_SIZE = 128;
    public int isc_api_handle;

    public BaseGDSImpl() {
    }

    public BaseGDSImpl(GDSType gdsType) {
        super(gdsType);
    }

    protected abstract String getServerUrl(String var1) throws GDSException;

    @Override
    public BlobParameterBuffer createBlobParameterBuffer() {
        return new BlobParameterBufferImp();
    }

    @Override
    public DatabaseParameterBuffer createDatabaseParameterBuffer() {
        return new DatabaseParameterBufferImp();
    }

    @Override
    public IscBlobHandle createIscBlobHandle() {
        return new isc_blob_handle_impl();
    }

    @Override
    public IscDbHandle createIscDbHandle() {
        return new isc_db_handle_impl();
    }

    @Override
    public IscStmtHandle createIscStmtHandle() {
        return new isc_stmt_handle_impl();
    }

    @Override
    public IscSvcHandle createIscSvcHandle() {
        return new isc_svc_handle_impl();
    }

    @Override
    public IscTrHandle createIscTrHandle() {
        return new isc_tr_handle_impl();
    }

    @Override
    public ServiceParameterBuffer createServiceParameterBuffer() {
        return new ServiceParameterBufferImp();
    }

    @Override
    public ServiceRequestBuffer createServiceRequestBuffer(int taskIdentifier) {
        return new ServiceRequestBufferImp(taskIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscAttachDatabase(String file_name, IscDbHandle db_handle, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        byte[] urlData;
        String filenameCharset;
        byte[] dpbBytes;
        this.validateHandle(db_handle);
        if (databaseParameterBuffer != null) {
            DatabaseParameterBuffer cleanDPB = ((DatabaseParameterBufferExtension)databaseParameterBuffer).removeExtensionParams();
            if (cleanDPB.hasArgument(57)) {
                if (log != null) {
                    log.warn(WARNING_CONNECT_TIMEOUT_NATIVE);
                }
                db_handle.addWarning(new GDSWarning(WARNING_CONNECT_TIMEOUT_NATIVE));
            }
            if (!cleanDPB.hasArgument(63)) {
                cleanDPB.addArgument(63, 3);
            }
            dpbBytes = ((DatabaseParameterBufferImp)cleanDPB).getBytesForNativeCode();
            filenameCharset = databaseParameterBuffer.getArgumentAsString(139);
        } else {
            dpbBytes = null;
            filenameCharset = null;
        }
        String serverUrl = this.getServerUrl(file_name);
        try {
            urlData = filenameCharset != null ? serverUrl.getBytes(filenameCharset) : serverUrl.getBytes();
            byte[] nullTerminated = new byte[urlData.length + 1];
            System.arraycopy(urlData, 0, nullTerminated, 0, urlData.length);
            urlData = nullTerminated;
        }
        catch (UnsupportedEncodingException ex) {
            throw new GDSException(335544325);
        }
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            this.native_isc_attach_database(urlData, db_handle, dpbBytes);
        }
        this.parseAttachDatabaseInfo(this.iscDatabaseInfo(db_handle, DESCRIBE_DATABASE_INFO_BLOCK, 1024), db_handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] iscBlobInfo(IscBlobHandle handle, byte[] items, int buffer_length) throws GDSException {
        isc_db_handle_impl db;
        isc_blob_handle_impl blob = this.validateHandle(handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(blob.getDb());
        synchronized (isc_db_handle_impl2) {
            return this.native_isc_blob_info(blob, items, buffer_length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscCloseBlob(IscBlobHandle blob_handle) throws GDSException {
        isc_blob_handle_impl blob = this.validateHandle(blob_handle);
        isc_db_handle_impl db = this.validateHandle(blob.getDb());
        isc_tr_handle_impl tr = this.validateHandle(blob.getTr());
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_close_blob(blob_handle);
        }
        tr.removeBlob(blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscCommitRetaining(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(tr.getDbHandle());
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            this.native_isc_commit_retaining(tr_handle);
            tr.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscCommitTransaction(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(tr.getDbHandle());
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            this.native_isc_commit_transaction(tr_handle);
            tr.setState(0);
            tr.unsetDbHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscCreateBlob2(IscDbHandle db_handle, IscTrHandle tr_handle, IscBlobHandle blob_handle, BlobParameterBuffer blobParameterBuffer) throws GDSException {
        isc_db_handle_impl db = this.validateHandle(db_handle);
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        isc_blob_handle_impl blob = this.validateHandle(blob_handle);
        byte[] bpb = blobParameterBuffer == null ? null : ((BlobParameterBufferImp)blobParameterBuffer).getBytesForNativeCode();
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_create_blob2(db_handle, tr_handle, blob_handle, bpb);
            blob.setDb(db);
            blob.setTr(tr);
            tr.addBlob(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscCreateDatabase(String file_name, IscDbHandle db_handle, DatabaseParameterBuffer dpb) throws GDSException {
        String filenameCharset;
        byte[] dpbBytes;
        this.validateHandle(db_handle);
        if (dpb != null) {
            DatabaseParameterBuffer cleanDPB = ((DatabaseParameterBufferExtension)dpb).removeExtensionParams();
            if (cleanDPB.hasArgument(57)) {
                if (log != null) {
                    log.warn(WARNING_CONNECT_TIMEOUT_NATIVE);
                }
                db_handle.addWarning(new GDSWarning(WARNING_CONNECT_TIMEOUT_NATIVE));
            }
            if (!cleanDPB.hasArgument(63)) {
                cleanDPB.addArgument(63, 3);
            }
            dpbBytes = ((DatabaseParameterBufferImp)cleanDPB).getBytesForNativeCode();
            filenameCharset = dpb.getArgumentAsString(139);
        } else {
            dpbBytes = null;
            filenameCharset = null;
        }
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            byte[] urlData;
            String serverUrl = this.getServerUrl(file_name);
            try {
                urlData = filenameCharset != null ? serverUrl.getBytes(filenameCharset) : serverUrl.getBytes();
                byte[] nullTerminated = new byte[urlData.length + 1];
                System.arraycopy(urlData, 0, nullTerminated, 0, urlData.length);
                urlData = nullTerminated;
            }
            catch (UnsupportedEncodingException ex) {
                throw new GDSException(335544325);
            }
            this.native_isc_create_database(urlData, db_handle, dpbBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] iscDatabaseInfo(IscDbHandle db_handle, byte[] items, int buffer_length) throws GDSException {
        this.validateHandle(db_handle);
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            byte[] returnValue = new byte[buffer_length];
            this.native_isc_database_info(db_handle, items.length, items, buffer_length, returnValue);
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscDetachDatabase(IscDbHandle db_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(db_handle);
        synchronized (isc_db_handle_impl2) {
            this.native_isc_detach_database(db_handle);
            db.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscDropDatabase(IscDbHandle db_handle) throws GDSException {
        this.validateHandle(db_handle);
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            this.native_isc_drop_database(db_handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscDsqlAllocateStatement(IscDbHandle db_handle, IscStmtHandle stmt_handle) throws GDSException {
        isc_db_handle_impl db = this.validateHandle(db_handle);
        isc_stmt_handle_impl stmt = this.validateHandle(stmt_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_dsql_allocate_statement(db_handle, stmt_handle);
            stmt.setRsr_rdb((isc_db_handle_impl)db_handle);
            stmt.setAllRowsFetched(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XSQLDA iscDsqlDescribe(IscStmtHandle stmt_handle, int da_version) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = this.validateHandle(stmt_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(stmt.getRsr_rdb());
        synchronized (isc_db_handle_impl2) {
            stmt.setInSqlda(this.native_isc_dsql_describe(stmt_handle, da_version));
            return stmt_handle.getInSqlda();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XSQLDA iscDsqlDescribeBind(IscStmtHandle stmt_handle, int da_version) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = this.validateHandle(stmt_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(stmt.getRsr_rdb());
        synchronized (isc_db_handle_impl2) {
            stmt.setInSqlda(this.native_isc_dsql_describe_bind(stmt_handle, da_version));
            return stmt_handle.getInSqlda();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscDsqlExecImmed2(IscDbHandle db_handle, IscTrHandle tr_handle, byte[] statement, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        this.validateHandle(db_handle);
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            this.native_isc_dsql_exec_immed2(db_handle, tr_handle, this.getZeroTerminatedArray(statement), dialect, in_xsqlda, out_xsqlda);
        }
    }

    @Override
    public void iscDsqlExecImmed2(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, "NONE", dialect, in_xsqlda, out_xsqlda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscDsqlExecImmed2(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, String encoding, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        this.validateHandle(db_handle);
        try {
            IscDbHandle iscDbHandle = db_handle;
            synchronized (iscDbHandle) {
                this.native_isc_dsql_exec_immed2(db_handle, tr_handle, this.getByteArrayForString(statement, encoding), dialect, in_xsqlda, out_xsqlda);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new GDSException("Unsupported encoding. " + e.getMessage());
        }
    }

    @Override
    public void iscDsqlExecute(IscTrHandle tr_handle, IscStmtHandle stmt_handle, int da_version, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecute2(tr_handle, stmt_handle, da_version, xsqlda, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscDsqlExecute2(IscTrHandle tr_handle, IscStmtHandle stmt_handle, int da_version, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = this.validateHandle(stmt_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(stmt.getRsr_rdb());
        synchronized (isc_db_handle_impl2) {
            this.native_isc_dsql_execute2(tr_handle, stmt_handle, da_version, in_xsqlda, out_xsqlda);
            if (stmt.getOutSqlda() != null) {
                stmt.notifyOpenResultSet();
            }
            if (out_xsqlda != null) {
                stmt.ensureCapacity(1);
                this.readSQLData(out_xsqlda, stmt);
                stmt.setAllRowsFetched(true);
                stmt.setSingletonResult(true);
            } else {
                stmt.setAllRowsFetched(false);
                stmt.setSingletonResult(false);
            }
            stmt.registerTransaction((AbstractIscTrHandle)tr_handle);
        }
    }

    @Override
    public void iscDsqlExecuteImmediate(IscDbHandle db_handle, IscTrHandle tr_handle, byte[] statement, int dialect, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, dialect, xsqlda, null);
    }

    @Override
    public void iscDsqlExecuteImmediate(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, int dialect, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, dialect, xsqlda, null);
    }

    @Override
    public void iscDsqlExecuteImmediate(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, String encoding, int dialect, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, encoding, dialect, xsqlda, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscDsqlFetch(IscStmtHandle stmt_handle, int da_version, XSQLDA xsqlda, int fetchSize) throws GDSException {
        isc_db_handle_impl db;
        fetchSize = 1;
        if (xsqlda == null) {
            throw new GDSException(335544583);
        }
        if (fetchSize <= 0) {
            throw new GDSException(335544583);
        }
        isc_stmt_handle_impl stmt = this.validateHandle(stmt_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(stmt.getRsr_rdb());
        synchronized (isc_db_handle_impl2) {
            stmt.ensureCapacity(fetchSize);
            for (int i = 0; i < fetchSize; ++i) {
                try {
                    boolean isRowPresent = this.native_isc_dsql_fetch(stmt_handle, da_version, xsqlda, fetchSize);
                    if (isRowPresent) {
                        this.readSQLData(xsqlda, stmt);
                        continue;
                    }
                    stmt.setAllRowsFetched(true);
                    return;
                }
                finally {
                    stmt.notifyOpenResultSet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscDsqlFreeStatement(IscStmtHandle stmt_handle, int option) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = this.validateHandle(stmt_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(stmt.getRsr_rdb());
        synchronized (isc_db_handle_impl2) {
            if (stmt.isSingletonResult() && option == 1) {
                return;
            }
            if (option == 2) {
                stmt.setInSqlda(null);
                stmt.setOutSqlda(null);
                stmt.setRsr_rdb(null);
            }
            this.native_isc_dsql_free_statement(stmt_handle, option);
            try {
                AbstractIscTrHandle tr = stmt.getTransaction();
                if (tr != null) {
                    tr.unregisterStatementFromTransaction(stmt);
                }
            }
            finally {
                stmt.unregisterTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XSQLDA iscDsqlPrepare(IscTrHandle tr_handle, IscStmtHandle stmt_handle, byte[] statement, int dialect) throws GDSException {
        isc_db_handle_impl db;
        this.validateHandle(tr_handle);
        isc_stmt_handle_impl stmt = this.validateHandle(stmt_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(stmt.getRsr_rdb());
        synchronized (isc_db_handle_impl2) {
            stmt.setInSqlda(null);
            stmt.setOutSqlda(null);
            stmt.setOutSqlda(this.native_isc_dsql_prepare(tr_handle, stmt_handle, this.getZeroTerminatedArray(statement), dialect));
            this.getStatementType(stmt);
            return stmt_handle.getOutSqlda();
        }
    }

    private void getStatementType(isc_stmt_handle_impl stmt) throws GDSException {
        byte[] REQUEST = new byte[]{21, 1};
        int bufferSize = 1024;
        byte[] buffer = this.iscDsqlSqlInfo(stmt, REQUEST, bufferSize);
        int dataLength = -1;
        block4: for (int i = 0; i < buffer.length; ++i) {
            switch (buffer[i]) {
                case 21: {
                    dataLength = this.iscVaxInteger(buffer, ++i, 2);
                    stmt.setStatementType(this.iscVaxInteger(buffer, i += 2, dataLength));
                    i += dataLength;
                    continue block4;
                }
                case 0: 
                case 1: {
                    continue block4;
                }
                default: {
                    throw new GDSException("Unknown data block [" + buffer[i] + "]");
                }
            }
        }
    }

    @Override
    public XSQLDA iscDsqlPrepare(IscTrHandle tr_handle, IscStmtHandle stmt_handle, String statement, int dialect) throws GDSException {
        return this.iscDsqlPrepare(tr_handle, stmt_handle, statement, "NONE", dialect);
    }

    @Override
    public XSQLDA iscDsqlPrepare(IscTrHandle tr_handle, IscStmtHandle stmt_handle, String statement, String encoding, int dialect) throws GDSException {
        try {
            return this.iscDsqlPrepare(tr_handle, stmt_handle, this.getByteArrayForString(statement, encoding), dialect);
        }
        catch (UnsupportedEncodingException e) {
            throw new GDSException("Unsupported encoding. " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscDsqlSetCursorName(IscStmtHandle stmt_handle, String cursor_name, int type) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = this.validateHandle(stmt_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(stmt.getRsr_rdb());
        synchronized (isc_db_handle_impl2) {
            this.native_isc_dsql_set_cursor_name(stmt_handle, cursor_name, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] iscDsqlSqlInfo(IscStmtHandle stmt_handle, byte[] items, int buffer_length) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = this.validateHandle(stmt_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(stmt.getRsr_rdb());
        synchronized (isc_db_handle_impl2) {
            return this.native_isc_dsql_sql_info(stmt_handle, items, buffer_length);
        }
    }

    public byte[] iscExpandDpb(byte[] dpb, int dpb_length, int param, Object[] params) throws GDSException {
        return dpb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] iscGetSegment(IscBlobHandle blob, int maxread) throws GDSException {
        isc_db_handle_impl db;
        isc_blob_handle_impl blb = this.validateHandle(blob);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(blb.getDb());
        synchronized (isc_db_handle_impl2) {
            return this.native_isc_get_segment(blob, maxread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscOpenBlob2(IscDbHandle db_handle, IscTrHandle tr_handle, IscBlobHandle blob_handle, BlobParameterBuffer blobParameterBuffer) throws GDSException {
        isc_db_handle_impl db = this.validateHandle(db_handle);
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        isc_blob_handle_impl blob = this.validateHandle(blob_handle);
        byte[] bpb = blobParameterBuffer == null ? null : ((BlobParameterBufferImp)blobParameterBuffer).getBytesForNativeCode();
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_open_blob2(db_handle, tr_handle, blob_handle, bpb);
            blob.setDb(db);
            blob.setTr(tr);
            tr.addBlob(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscPrepareTransaction(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(tr.getDbHandle());
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            this.native_isc_prepare_transaction(tr_handle);
            tr.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscPrepareTransaction2(IscTrHandle tr_handle, byte[] bytes) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(tr.getDbHandle());
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            this.native_isc_prepare_transaction2(tr_handle, bytes);
            tr.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscPutSegment(IscBlobHandle blob_handle, byte[] buffer) throws GDSException {
        isc_db_handle_impl db;
        isc_blob_handle_impl blob = this.validateHandle(blob_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(blob.getDb());
        synchronized (isc_db_handle_impl2) {
            this.native_isc_put_segment(blob_handle, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscReconnectTransaction(IscTrHandle tr_handle, IscDbHandle db_handle, long transactionId) throws GDSException {
        this.validateHandle(db_handle);
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        byte[] buffer = new byte[4];
        for (int i = 0; i < 4; ++i) {
            buffer[i] = (byte)(transactionId >>> i * 8);
        }
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            tr.setState(1);
            this.native_isc_reconnect_transaction(db_handle, tr_handle, buffer);
            tr.setDbHandle((isc_db_handle_impl)db_handle);
            tr.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscRollbackRetaining(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(tr.getDbHandle());
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            this.native_isc_rollback_retaining(tr_handle);
            tr.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscRollbackTransaction(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(tr.getDbHandle());
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() == 0) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            this.native_isc_rollback_transaction(tr_handle);
            tr.setState(0);
            tr.unsetDbHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] iscTransactionInformation(IscTrHandle trHandle, byte[] requestBuffer, int bufferLen) throws GDSException {
        isc_db_handle_impl db;
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(trHandle.getDbHandle());
        synchronized (isc_db_handle_impl2) {
            return this.native_isc_transaction_info(trHandle, requestBuffer, bufferLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscSeekBlob(IscBlobHandle handle, int position, int mode) throws GDSException {
        isc_db_handle_impl db;
        isc_blob_handle_impl blob = this.validateHandle(handle);
        isc_db_handle_impl isc_db_handle_impl2 = db = this.validateHandle(blob.getDb());
        synchronized (isc_db_handle_impl2) {
            this.native_isc_seek_blob(blob, position, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscServiceAttach(String service, IscSvcHandle serviceHandle, ServiceParameterBuffer serviceParameterBuffer) throws GDSException {
        if (serviceHandle == null) {
            throw new GDSException(335544559);
        }
        ServiceParameterBufferImp serviceParameterBufferImp = (ServiceParameterBufferImp)serviceParameterBuffer;
        byte[] serviceParameterBufferBytes = serviceParameterBufferImp == null ? null : serviceParameterBufferImp.toByteArray();
        IscSvcHandle iscSvcHandle = serviceHandle;
        synchronized (iscSvcHandle) {
            if (serviceHandle.isValid()) {
                throw new GDSException("serviceHandle is already attached.");
            }
            this.native_isc_service_attach(service, serviceHandle, serviceParameterBufferBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscServiceDetach(IscSvcHandle serviceHandle) throws GDSException {
        this.validateHandle(serviceHandle);
        IscSvcHandle iscSvcHandle = serviceHandle;
        synchronized (iscSvcHandle) {
            this.native_isc_service_detach(serviceHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscServiceQuery(IscSvcHandle serviceHandle, ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, byte[] resultBuffer) throws GDSException {
        this.validateHandle(serviceHandle);
        ServiceParameterBufferImp serviceParameterBufferImp = (ServiceParameterBufferImp)serviceParameterBuffer;
        byte[] serviceParameterBufferBytes = serviceParameterBufferImp == null ? null : serviceParameterBufferImp.toByteArray();
        ServiceRequestBufferImp serviceRequestBufferImp = (ServiceRequestBufferImp)serviceRequestBuffer;
        byte[] serviceRequestBufferBytes = serviceRequestBufferImp == null ? null : serviceRequestBufferImp.toByteArray();
        IscSvcHandle iscSvcHandle = serviceHandle;
        synchronized (iscSvcHandle) {
            this.native_isc_service_query(serviceHandle, serviceParameterBufferBytes, serviceRequestBufferBytes, resultBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscServiceStart(IscSvcHandle serviceHandle, ServiceRequestBuffer serviceRequestBuffer) throws GDSException {
        this.validateHandle(serviceHandle);
        ServiceRequestBufferImp serviceRequestBufferImp = (ServiceRequestBufferImp)serviceRequestBuffer;
        byte[] serviceRequestBufferBytes = serviceRequestBufferImp == null ? null : serviceRequestBufferImp.toByteArray();
        IscSvcHandle iscSvcHandle = serviceHandle;
        synchronized (iscSvcHandle) {
            this.native_isc_service_start(serviceHandle, serviceRequestBufferBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscStartTransaction(IscTrHandle tr_handle, IscDbHandle db_handle, TransactionParameterBuffer tpb) throws GDSException {
        isc_tr_handle_impl tr = this.validateHandle(tr_handle);
        isc_db_handle_impl db = this.validateHandle(db_handle);
        TransactionParameterBufferImpl tpbImpl = (TransactionParameterBufferImpl)tpb;
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 0) {
                throw new GDSException(335544468);
            }
            tr.setState(1);
            byte[] arg = tpbImpl.getBytesForNativeCode();
            this.native_isc_start_transaction(tr_handle, db_handle, arg);
            tr.setDbHandle((isc_db_handle_impl)db_handle);
            tr.setState(2);
        }
    }

    @Override
    public int iscVaxInteger(byte[] buffer, int pos, int length) {
        int shift = 0;
        int value = 0;
        int i = pos;
        while (--length >= 0) {
            value += (buffer[i++] & 0xFF) << shift;
            shift += 8;
        }
        return value;
    }

    public int iscVaxInteger2(byte[] buffer, int pos) {
        return buffer[pos] & 0xFF | (buffer[pos + 1] & 0xFF) << 8;
    }

    public abstract void native_isc_attach_database(byte[] var1, IscDbHandle var2, byte[] var3);

    public abstract byte[] native_isc_blob_info(isc_blob_handle_impl var1, byte[] var2, int var3) throws GDSException;

    public abstract void native_isc_close_blob(IscBlobHandle var1) throws GDSException;

    public abstract void native_isc_commit_retaining(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_commit_transaction(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_create_blob2(IscDbHandle var1, IscTrHandle var2, IscBlobHandle var3, byte[] var4);

    public abstract void native_isc_create_database(byte[] var1, IscDbHandle var2, byte[] var3);

    public abstract void native_isc_database_info(IscDbHandle var1, int var2, byte[] var3, int var4, byte[] var5) throws GDSException;

    public abstract void native_isc_detach_database(IscDbHandle var1) throws GDSException;

    public abstract void native_isc_drop_database(IscDbHandle var1) throws GDSException;

    public abstract void native_isc_dsql_alloc_statement2(IscDbHandle var1, IscStmtHandle var2) throws GDSException;

    public abstract void native_isc_dsql_allocate_statement(IscDbHandle var1, IscStmtHandle var2) throws GDSException;

    public abstract XSQLDA native_isc_dsql_describe(IscStmtHandle var1, int var2) throws GDSException;

    public abstract XSQLDA native_isc_dsql_describe_bind(IscStmtHandle var1, int var2) throws GDSException;

    public abstract void native_isc_dsql_exec_immed2(IscDbHandle var1, IscTrHandle var2, byte[] var3, int var4, XSQLDA var5, XSQLDA var6) throws GDSException;

    public abstract void native_isc_dsql_execute2(IscTrHandle var1, IscStmtHandle var2, int var3, XSQLDA var4, XSQLDA var5) throws GDSException;

    public abstract boolean native_isc_dsql_fetch(IscStmtHandle var1, int var2, XSQLDA var3, int var4) throws GDSException;

    public abstract void native_isc_dsql_free_statement(IscStmtHandle var1, int var2) throws GDSException;

    public abstract XSQLDA native_isc_dsql_prepare(IscTrHandle var1, IscStmtHandle var2, byte[] var3, int var4) throws GDSException;

    public abstract void native_isc_dsql_set_cursor_name(IscStmtHandle var1, String var2, int var3) throws GDSException;

    public abstract byte[] native_isc_dsql_sql_info(IscStmtHandle var1, byte[] var2, int var3) throws GDSException;

    public abstract byte[] native_isc_get_segment(IscBlobHandle var1, int var2) throws GDSException;

    public abstract void native_isc_open_blob2(IscDbHandle var1, IscTrHandle var2, IscBlobHandle var3, byte[] var4);

    public abstract void native_isc_prepare_transaction(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_prepare_transaction2(IscTrHandle var1, byte[] var2) throws GDSException;

    public abstract void native_isc_put_segment(IscBlobHandle var1, byte[] var2) throws GDSException;

    public abstract void native_isc_rollback_retaining(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_rollback_transaction(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_seek_blob(isc_blob_handle_impl var1, int var2, int var3) throws GDSException;

    public abstract void native_isc_service_attach(String var1, IscSvcHandle var2, byte[] var3) throws GDSException;

    public abstract void native_isc_service_detach(IscSvcHandle var1) throws GDSException;

    public abstract void native_isc_service_query(IscSvcHandle var1, byte[] var2, byte[] var3, byte[] var4) throws GDSException;

    public abstract void native_isc_service_start(IscSvcHandle var1, byte[] var2) throws GDSException;

    public abstract void native_isc_start_transaction(IscTrHandle var1, IscDbHandle var2, byte[] var3) throws GDSException;

    public abstract void native_isc_reconnect_transaction(IscDbHandle var1, IscTrHandle var2, byte[] var3) throws GDSException;

    public abstract byte[] native_isc_transaction_info(IscTrHandle var1, byte[] var2, int var3) throws GDSException;

    public abstract int native_isc_que_events(IscDbHandle var1, EventHandleImp var2, EventHandler var3) throws GDSException;

    public abstract long native_isc_event_block(EventHandleImp var1, String var2) throws GDSException;

    public abstract void native_isc_event_counts(EventHandleImp var1) throws GDSException;

    public abstract void native_isc_cancel_events(IscDbHandle var1, EventHandleImp var2) throws GDSException;

    public abstract void native_fb_cancel_operation(IscDbHandle var1, int var2) throws GDSException;

    @Override
    public TransactionParameterBuffer newTransactionParameterBuffer() {
        return new TransactionParameterBufferImpl();
    }

    private void parseAttachDatabaseInfo(byte[] info, IscDbHandle handle) throws GDSException {
        boolean debug;
        boolean bl = debug = log != null && log.isDebugEnabled();
        if (debug) {
            log.debug("parseDatabaseInfo: first 2 bytes are " + this.iscVaxInteger(info, 0, 2) + " or: " + info[0] + ", " + info[1]);
        }
        int value = 0;
        int len = 0;
        int i = 0;
        isc_db_handle_impl db = (isc_db_handle_impl)handle;
        block10: while (info[i] != 1) {
            switch (info[i++]) {
                case 62: {
                    len = this.iscVaxInteger(info, i, 2);
                    value = this.iscVaxInteger(info, i += 2, len);
                    i += len;
                    db.setDialect(value);
                    if (!debug) continue block10;
                    log.debug("isc_info_db_sql_dialect:" + value);
                    continue block10;
                }
                case 32: {
                    len = this.iscVaxInteger(info, i, 2);
                    value = this.iscVaxInteger(info, i += 2, len);
                    i += len;
                    db.setODSMajorVersion(value);
                    if (!debug) continue block10;
                    log.debug("isc_info_ods_version:" + value);
                    continue block10;
                }
                case 33: {
                    len = this.iscVaxInteger(info, i, 2);
                    value = this.iscVaxInteger(info, i += 2, len);
                    i += len;
                    db.setODSMinorVersion(value);
                    if (!debug) continue block10;
                    log.debug("isc_info_ods_minor_version:" + value);
                    continue block10;
                }
                case 103: {
                    len = this.iscVaxInteger(info, i, 2);
                    byte[] fb_vers = new byte[len - 2];
                    System.arraycopy(info, (i += 2) + 2, fb_vers, 0, len - 2);
                    i += len;
                    String fb_versS = new String(fb_vers);
                    db.setVersion(fb_versS);
                    if (!debug) continue block10;
                    log.debug("isc_info_firebird_version:" + fb_versS);
                    continue block10;
                }
                case 11: {
                    len = this.iscVaxInteger(info, i, 2);
                    byte[] impl = new byte[len - 2];
                    System.arraycopy(info, (i += 2) + 2, impl, 0, len - 2);
                    i += len;
                    continue block10;
                }
                case 102: {
                    len = this.iscVaxInteger(info, i, 2);
                    byte[] db_class = new byte[len - 2];
                    System.arraycopy(info, (i += 2) + 2, db_class, 0, len - 2);
                    i += len;
                    continue block10;
                }
                case 13: {
                    len = this.iscVaxInteger(info, i, 2);
                    byte[] base_level = new byte[len - 2];
                    System.arraycopy(info, (i += 2) + 2, base_level, 0, len - 2);
                    i += len;
                    continue block10;
                }
                case 2: {
                    if (debug) {
                        log.debug("isc_info_truncated ");
                    }
                    return;
                }
            }
            throw new GDSException(335544583);
        }
    }

    public void readSQLData(XSQLDA xsqlda, isc_stmt_handle_impl stmt) {
        int numCols = xsqlda.sqld;
        byte[][] row = new byte[numCols][];
        for (int i = 0; i < numCols; ++i) {
            row[i] = xsqlda.sqlvar[i].sqldata;
        }
        if (stmt != null) {
            stmt.addRow(row);
        }
    }

    protected byte[] getByteArrayForString(String statement, String encoding) throws UnsupportedEncodingException {
        String javaEncoding = null;
        if (encoding != null && !"NONE".equals(encoding)) {
            javaEncoding = EncodingFactory.getJavaEncoding(encoding);
        }
        byte[] stringBytes = javaEncoding != null ? statement.getBytes(javaEncoding) : statement.getBytes();
        return this.getZeroTerminatedArray(stringBytes);
    }

    protected byte[] getZeroTerminatedArray(byte[] stringBytes) {
        byte[] zeroTermBytes = new byte[stringBytes.length + 1];
        System.arraycopy(stringBytes, 0, zeroTermBytes, 0, stringBytes.length);
        zeroTermBytes[stringBytes.length] = 0;
        return zeroTermBytes;
    }

    @Override
    public void getSqlCounts(IscStmtHandle stmt_handle) throws GDSException {
        byte type;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        byte[] buffer = this.iscDsqlSqlInfo(stmt, stmtInfo, INFO_SIZE);
        stmt.setInsertCount(0);
        stmt.setUpdateCount(0);
        stmt.setDeleteCount(0);
        stmt.setSelectCount(0);
        int pos = 0;
        block10: while ((type = buffer[pos++]) != 1) {
            int length = this.iscVaxInteger2(buffer, pos);
            pos += 2;
            switch (type) {
                case 23: {
                    byte t;
                    while ((t = buffer[pos++]) != 1) {
                        int l = this.iscVaxInteger2(buffer, pos);
                        pos += 2;
                        switch (t) {
                            case 14: {
                                stmt.setInsertCount(this.iscVaxInteger(buffer, pos, l));
                                break;
                            }
                            case 15: {
                                stmt.setUpdateCount(this.iscVaxInteger(buffer, pos, l));
                                break;
                            }
                            case 16: {
                                stmt.setDeleteCount(this.iscVaxInteger(buffer, pos, l));
                                break;
                            }
                            case 13: {
                                stmt.setSelectCount(this.iscVaxInteger(buffer, pos, l));
                                break;
                            }
                        }
                        pos += l;
                    }
                    continue block10;
                }
                case 21: {
                    stmt.setStatementType(this.iscVaxInteger(buffer, pos, length));
                    pos += length;
                    continue block10;
                }
            }
            pos += length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int iscQueueEvents(IscDbHandle dbHandle, EventHandle eventHandle, EventHandler eventHandler) throws GDSException {
        this.validateHandle(dbHandle);
        EventHandleImp eventHandleImp = (EventHandleImp)eventHandle;
        if (!eventHandleImp.isValid()) {
            throw new IllegalStateException("Can't queue events on an invalid EventHandle");
        }
        if (eventHandleImp.isCancelled()) {
            throw new IllegalStateException("Can't queue events on a cancelled EventHandle");
        }
        IscDbHandle iscDbHandle = dbHandle;
        synchronized (iscDbHandle) {
            return this.native_isc_que_events(dbHandle, eventHandleImp, eventHandler);
        }
    }

    @Override
    public void iscEventBlock(EventHandle eventHandle) throws GDSException {
        EventHandleImp eventHandleImp = (EventHandleImp)eventHandle;
        this.native_isc_event_block(eventHandleImp, eventHandle.getEventName());
    }

    @Override
    public void iscEventCounts(EventHandle eventHandle) throws GDSException {
        EventHandleImp eventHandleImp = (EventHandleImp)eventHandle;
        if (!eventHandleImp.isValid()) {
            throw new IllegalStateException("Can't get counts on an invalid EventHandle");
        }
        this.native_isc_event_counts(eventHandleImp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iscCancelEvents(IscDbHandle dbHandle, EventHandle eventHandle) throws GDSException {
        this.validateHandle(dbHandle);
        EventHandleImp eventHandleImp = (EventHandleImp)eventHandle;
        if (!eventHandleImp.isValid()) {
            throw new IllegalStateException("Can't cancel an invalid EventHandle");
        }
        if (eventHandleImp.isCancelled()) {
            throw new IllegalStateException("Can't cancel a previously cancelled EventHandle");
        }
        eventHandleImp.cancel();
        IscDbHandle iscDbHandle = dbHandle;
        synchronized (iscDbHandle) {
            this.native_isc_cancel_events(dbHandle, eventHandleImp);
        }
    }

    @Override
    public EventHandle createEventHandle(String eventName) {
        return new EventHandleImp(eventName);
    }

    @Override
    public void fbCancelOperation(IscDbHandle dbHandle, int kind) throws GDSException {
        this.validateHandle(dbHandle);
        this.native_fb_cancel_operation(dbHandle, kind);
    }

    protected final isc_db_handle_impl validateHandle(IscDbHandle dbHandle) throws GDSException {
        if (dbHandle == null || !dbHandle.isValid()) {
            throw new GDSException(0x14000004);
        }
        return (isc_db_handle_impl)dbHandle;
    }

    protected final isc_blob_handle_impl validateHandle(IscBlobHandle blobHandle) throws GDSException {
        if (blobHandle == null) {
            throw new GDSException(335544328);
        }
        return (isc_blob_handle_impl)blobHandle;
    }

    protected final isc_tr_handle_impl validateHandle(IscTrHandle transactionHandle) throws GDSException {
        if (transactionHandle == null) {
            throw new GDSException(335544332);
        }
        return (isc_tr_handle_impl)transactionHandle;
    }

    protected final isc_stmt_handle_impl validateHandle(IscStmtHandle statementHandle) throws GDSException {
        if (statementHandle == null) {
            throw new GDSException(335544485);
        }
        return (isc_stmt_handle_impl)statementHandle;
    }

    protected final isc_svc_handle_impl validateHandle(IscSvcHandle svcHandle) throws GDSException {
        if (svcHandle == null || svcHandle.isNotValid()) {
            throw new GDSException(335544559);
        }
        return (isc_svc_handle_impl)svcHandle;
    }
}

