/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.blip.ImagePainter;
import org.apache.poi.hslf.model.Picture;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class BitmapPainter
implements ImagePainter {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());

    @Override
    public void paint(Graphics2D graphics, PictureData pict, Picture parent) {
        BufferedImage img;
        try {
            img = ImageIO.read(new ByteArrayInputStream(pict.getData()));
        }
        catch (Exception e) {
            this.logger.log(5, (Object)("ImageIO failed to create image. image.type: " + pict.getType()));
            return;
        }
        boolean isClipped = true;
        Insets clip = parent.getBlipClip();
        if (clip == null) {
            isClipped = false;
            clip = new Insets(0, 0, 0, 0);
        }
        int iw = img.getWidth();
        int ih = img.getHeight();
        Rectangle anchor = parent.getLogicalAnchor2D().getBounds();
        double cw = (double)(100000 - clip.left - clip.right) / 100000.0;
        double ch = (double)(100000 - clip.top - clip.bottom) / 100000.0;
        double sx = anchor.getWidth() / ((double)iw * cw);
        double sy = anchor.getHeight() / ((double)ih * ch);
        double tx = anchor.getX() - (double)iw * sx * (double)clip.left / 100000.0;
        double ty = anchor.getY() - (double)ih * sy * (double)clip.top / 100000.0;
        AffineTransform at = new AffineTransform(sx, 0.0, 0.0, sy, tx, ty);
        Shape clipOld = graphics.getClip();
        if (isClipped) {
            graphics.clip(anchor.getBounds2D());
        }
        graphics.drawRenderedImage(img, at);
        graphics.setClip(clipOld);
    }
}

