/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.blip.Metafile;
import org.apache.poi.hslf.exceptions.HSLFException;

public final class EMF
extends Metafile {
    @Override
    public byte[] getData() {
        try {
            int count;
            byte[] rawdata = this.getRawData();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(rawdata);
            Metafile.Header header = new Metafile.Header();
            header.read(rawdata, 16);
            ((InputStream)is).skip(header.getSize() + 16);
            InflaterInputStream inflater = new InflaterInputStream(is);
            byte[] chunk = new byte[4096];
            while ((count = inflater.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
            inflater.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    @Override
    public void setData(byte[] data) throws IOException {
        byte[] compressed = this.compress(data, 0, data.length);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = data.length;
        header.bounds = new Rectangle(0, 0, 200, 200);
        header.size = new Dimension(header.bounds.width * 12700, header.bounds.height * 12700);
        header.zipsize = compressed.length;
        byte[] checksum = EMF.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getSignature() {
        return 15680;
    }
}

