/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.MaintenanceManager;

public class FBMaintenanceManager
extends FBServiceManager
implements MaintenanceManager {
    public FBMaintenanceManager() {
    }

    public FBMaintenanceManager(String gdsType) {
        super(gdsType);
    }

    public FBMaintenanceManager(GDSType gdsType) {
        super(gdsType);
    }

    @Override
    public void setDatabaseAccessMode(int mode) throws SQLException {
        if (mode != 40 && mode != 39) {
            throw new IllegalArgumentException("mode must be one of ACCESS_MODE_READ_WRITE or ACCESS_MODE_READ_ONLY");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(13, (byte)mode);
        this.executeServicesOperation(srb);
    }

    @Override
    public void setDatabaseDialect(int dialect) throws SQLException {
        if (dialect != 1 && dialect != 3) {
            throw new IllegalArgumentException("dialect must be either 1 or 3");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(14, dialect);
        this.executeServicesOperation(srb);
    }

    @Override
    public void setDefaultCacheBuffer(int pageCount) throws SQLException {
        if (pageCount < 1) {
            throw new IllegalArgumentException("page count must be positive");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(5, pageCount);
        this.executeServicesOperation(srb);
    }

    @Override
    public void setForcedWrites(boolean forced) throws SQLException {
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(12, (byte)(forced ? 38 : 37));
        this.executeServicesOperation(srb);
    }

    @Override
    public void setPageFill(int pageFill) throws SQLException {
        if (pageFill != 35 && pageFill != 36) {
            throw new IllegalArgumentException("Page fill must be either PAGE_FILL_FULL or PAGE_FILL_RESERVE");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(11, (byte)pageFill);
        this.executeServicesOperation(srb);
    }

    @Override
    public void shutdownDatabase(int shutdownMode, int timeout) throws SQLException {
        if (shutdownMode != 9 && shutdownMode != 10 && shutdownMode != 7) {
            throw new IllegalArgumentException("Shutdown mode must be one of: SHUTDOWN_ATTACH, SHUTDOWN_TRANSACTIONAL, SHUTDOWN_FORCE");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(shutdownMode, timeout);
        this.executeServicesOperation(srb);
    }

    @Override
    public void shutdownDatabase(byte operationMode, int shutdownModeEx, int timeout) throws SQLException {
        if (operationMode != 1 && operationMode != 2 && operationMode != 3) {
            throw new IllegalArgumentException("Operation mode must be one of: OPERATION_MODE_MULTI, OPERATION_MODE_SINGLE, OPERATION_MODE_FULL_SHUTDOWN");
        }
        if (shutdownModeEx != 41 && shutdownModeEx != 42 && shutdownModeEx != 43) {
            throw new IllegalArgumentException("Extended shutdown mode must be one of: SHUTDOWNEX_FORCE, SHUTDOWNEX_ATTACHMENTS, SHUTDOWNEX_TRANSACTIONS");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(44, operationMode);
        srb.addArgument(shutdownModeEx, timeout);
        this.executeServicesOperation(srb);
    }

    @Override
    public void bringDatabaseOnline() throws SQLException {
        this.executePropertiesOperation(512);
    }

    @Override
    public void bringDatabaseOnline(byte operationMode) throws SQLException {
        if (operationMode != 0 && operationMode != 1 && operationMode != 2) {
            throw new IllegalArgumentException("Operation mode must be one of: OPERATION_MODE_NORMAL, OPERATION_MODE_MULTI, OPERATION_MODE_SINGLE");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(45, operationMode);
        this.executeServicesOperation(srb);
    }

    @Override
    public void markCorruptRecords() throws SQLException {
        this.executeRepairOperation(4);
    }

    @Override
    public void validateDatabase() throws SQLException {
        this.executeRepairOperation(1);
    }

    @Override
    public void validateDatabase(int options) throws SQLException {
        if (options < 0 || options != 0 && options != 32 && (options & 0xFFFFFFDF) != 16 && (options & 0xFFFFFFDF) != 128 && (options | 0x30) != options && (options | 0xA0) != options) {
            throw new IllegalArgumentException("options must be either 0, VALIDATE_READ_ONLY, or VALIDATE_FULL, optionally combined with VALIDATE_IGNORE_CHECKSUM");
        }
        ServiceRequestBuffer srb = this.createRepairSRB(options | 1);
        this.executeServicesOperation(srb);
    }

    @Override
    public void setSweepThreshold(int transactions) throws SQLException {
        if (transactions < 0) {
            throw new IllegalArgumentException("transactions must be >= 0");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(6, transactions);
        this.executeServicesOperation(srb);
    }

    @Override
    public void sweepDatabase() throws SQLException {
        this.executeRepairOperation(2);
    }

    @Override
    public void activateShadowFile() throws SQLException {
        this.executePropertiesOperation(256);
    }

    @Override
    public void killUnavailableShadows() throws SQLException {
        this.executeRepairOperation(64);
    }

    @Override
    public void listLimboTransactions() throws SQLException {
        PrintStream ps = new PrintStream(this.getLogger());
        for (Integer trId : this.limboTransactionsAsList()) {
            ps.print(trId + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> limboTransactionsAsList() throws SQLException {
        OutputStream saveOut = this.getLogger();
        try {
            LinkedList<Integer> result = new LinkedList<Integer>();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.setLogger(out);
            this.executeRepairOperation(8);
            byte[] output = out.toByteArray();
            int idx = 0;
            block9: while (idx < output.length) {
                switch (output[idx++]) {
                    case 19: 
                    case 20: {
                        int trId = this.getGds().iscVaxInteger(output, idx, 4);
                        idx += 4;
                        result.add(trId);
                        continue block9;
                    }
                    case 18: {
                        idx += 4;
                        continue block9;
                    }
                    case 21: 
                    case 29: {
                        ++idx;
                        continue block9;
                    }
                    case 26: 
                    case 27: 
                    case 28: {
                        int length = this.getGds().iscVaxInteger(output, idx, 2);
                        idx += 2;
                        idx += length;
                        continue block9;
                    }
                }
                GDSException gdsException = new GDSException(1, 336986116);
                gdsException.setNext(new GDSException(4, output[idx - 1] & 0xFF));
                throw new FBSQLException(gdsException);
            }
            LinkedList<Integer> linkedList = result;
            return linkedList;
        }
        finally {
            this.setLogger(saveOut);
        }
    }

    public int[] getLimboTransactions() throws SQLException {
        List<Integer> limboTransactions = this.limboTransactionsAsList();
        int[] trans = new int[limboTransactions.size()];
        int idx = 0;
        for (Integer trId : limboTransactions) {
            trans[idx++] = trId;
        }
        return trans;
    }

    @Override
    public void commitTransaction(int transactionId) throws SQLException {
        ServiceRequestBuffer srb = this.createDefaultRepairSRB();
        srb.addArgument(15, transactionId);
        this.executeServicesOperation(srb);
    }

    @Override
    public void rollbackTransaction(int transactionId) throws SQLException {
        ServiceRequestBuffer srb = this.createDefaultRepairSRB();
        srb.addArgument(34, transactionId);
        this.executeServicesOperation(srb);
    }

    private void executeRepairOperation(int operation) throws SQLException {
        ServiceRequestBuffer srb = this.createRepairSRB(operation);
        this.executeServicesOperation(srb);
    }

    private void executePropertiesOperation(int operation) throws SQLException {
        ServiceRequestBuffer srb = this.createPropertiesSRB(operation);
        this.executeServicesOperation(srb);
    }

    private ServiceRequestBuffer createDefaultPropertiesSRB() {
        return this.createPropertiesSRB(0);
    }

    private ServiceRequestBuffer createDefaultRepairSRB() {
        return this.createRepairSRB(0);
    }

    private ServiceRequestBuffer createPropertiesSRB(int options) {
        return this.createRequestBuffer(8, options);
    }

    private ServiceRequestBuffer createRepairSRB(int options) {
        return this.createRequestBuffer(3, options);
    }
}

