/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityCorrelator;
import com.microsoft.sqlserver.jdbc.ActivityId;
import com.microsoft.sqlserver.jdbc.ApplicationIntent;
import com.microsoft.sqlserver.jdbc.AuthenticationJNI;
import com.microsoft.sqlserver.jdbc.AuthenticationScheme;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.FailoverInfo;
import com.microsoft.sqlserver.jdbc.FailoverMapSingleton;
import com.microsoft.sqlserver.jdbc.ISQLServerConnection;
import com.microsoft.sqlserver.jdbc.KerbAuthentication;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolProxy;
import com.microsoft.sqlserver.jdbc.SQLServerDatabaseMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerDriverBooleanProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverIntProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerNClob;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SQLServerSavepoint;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SSPIAuthentication;
import com.microsoft.sqlserver.jdbc.ServerPortPlaceHolder;
import com.microsoft.sqlserver.jdbc.StreamLoginAck;
import com.microsoft.sqlserver.jdbc.StreamSSPI;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Permission;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;

public class SQLServerConnection
implements ISQLServerConnection {
    private static final float TIMEOUTSTEP = 0.08f;
    private static final int INTERMITTENT_TLS_MAX_RETRY = 5;
    private boolean isRoutedInCurrentAttempt = false;
    private ServerPortPlaceHolder routingInfo = null;
    private static final String callAbortPerm = "callAbort";
    private boolean sendStringParametersAsUnicode = SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.getDefaultValue();
    private boolean lastUpdateCount;
    private boolean multiSubnetFailover;
    private ApplicationIntent applicationIntent = null;
    private int nLockTimeout;
    private String selectMethod;
    private String responseBuffering;
    private boolean sendTimeAsDatetime = SQLServerDriverBooleanProperty.SEND_TIME_AS_DATETIME.getDefaultValue();
    private byte requestedEncryptionLevel = (byte)-1;
    private boolean trustServerCertificate;
    private byte negotiatedEncryptionLevel = (byte)-1;
    Properties activeConnectionProperties;
    private boolean integratedSecurity = SQLServerDriverBooleanProperty.INTEGRATED_SECURITY.getDefaultValue();
    private AuthenticationScheme intAuthScheme = AuthenticationScheme.nativeAuthentication;
    ServerPortPlaceHolder currentConnectPlaceHolder = null;
    String sqlServerVersion;
    boolean xopenStates;
    private boolean databaseAutoCommitMode;
    private boolean inXATransaction = false;
    private byte[] transactionDescriptor = new byte[8];
    private boolean rolledBackTransaction;
    private State state = State.Initialized;
    static final int maxDecimalPrecision = 38;
    final String traceID;
    private int maxFieldSize;
    private int maxRows;
    private SQLCollation databaseCollation;
    private static int baseConnectionID = 0;
    private String sCatalog = "master";
    private String originalCatalog = "master";
    private int transactionIsolationLevel;
    private SQLServerPooledConnection pooledConnectionParent;
    private DatabaseMetaData databaseMetaData;
    private int nNextSavePointId = 10000;
    private static final Logger connectionlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerConnection");
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.Connection");
    private final String loggingClassName;
    private String failoverPartnerServerProvided = null;
    private int holdability;
    private int tdsPacketSize = 4096;
    private int requestedPacketSize = 8000;
    private TDSChannel tdsChannel;
    private TDSCommand currentCommand = null;
    private int tdsVersion = 0;
    private int serverMajorVersion;
    private SQLServerConnectionPoolProxy proxy;
    private UUID clientConnectionId = null;
    static final int MAX_SQL_LOGIN_NAME_WCHARS = 128;
    static final int DEFAULTPORT = SQLServerDriverIntProperty.PORT_NUMBER.getDefaultValue();
    private final Object schedulerLock = new Object();
    volatile SQLWarning sqlWarnings;
    Integer warningSynchronization = new Integer(1);
    private static final int ENVCHANGE_DATABASE = 1;
    private static final int ENVCHANGE_LANGUAGE = 2;
    private static final int ENVCHANGE_CHARSET = 3;
    private static final int ENVCHANGE_PACKETSIZE = 4;
    private static final int ENVCHANGE_SORTLOCALEID = 5;
    private static final int ENVCHANGE_SORTFLAGS = 6;
    private static final int ENVCHANGE_SQLCOLLATION = 7;
    private static final int ENVCHANGE_XACT_BEGIN = 8;
    private static final int ENVCHANGE_XACT_COMMIT = 9;
    private static final int ENVCHANGE_XACT_ROLLBACK = 10;
    private static final int ENVCHANGE_DTC_ENLIST = 11;
    private static final int ENVCHANGE_DTC_DEFECT = 12;
    private static final int ENVCHANGE_CHANGE_MIRROR = 13;
    private static final int ENVCHANGE_UNUSED_14 = 14;
    private static final int ENVCHANGE_DTC_PROMOTE = 15;
    private static final int ENVCHANGE_DTC_MGR_ADDR = 16;
    private static final int ENVCHANGE_XACT_ENDED = 17;
    private static final int ENVCHANGE_RESET_COMPLETE = 18;
    private static final int ENVCHANGE_USER_INFO = 19;
    private static final int ENVCHANGE_ROUTING = 20;
    static final char[] OUT = new char[]{' ', 'O', 'U', 'T'};
    private static final int BROWSER_PORT = 1434;

    boolean sendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    final boolean useLastUpdateCount() {
        return this.lastUpdateCount;
    }

    final boolean getMultiSubnetFailover() {
        return this.multiSubnetFailover;
    }

    final ApplicationIntent getApplicationIntent() {
        return this.applicationIntent;
    }

    final String getSelectMethod() {
        return this.selectMethod;
    }

    final String getResponseBuffering() {
        return this.responseBuffering;
    }

    final boolean sendTimeAsDatetime() {
        return !this.isKatmaiOrLater() || this.sendTimeAsDatetime;
    }

    final int baseYear() {
        return this.sendTimeAsDatetime() ? 1970 : 1900;
    }

    final byte getRequestedEncryptionLevel() {
        assert (-1 != this.requestedEncryptionLevel);
        return this.requestedEncryptionLevel;
    }

    final boolean trustServerCertificate() {
        return this.trustServerCertificate;
    }

    final byte getNegotiatedEncryptionLevel() {
        assert (-1 != this.negotiatedEncryptionLevel);
        return this.negotiatedEncryptionLevel;
    }

    final boolean rolledBackTransaction() {
        return this.rolledBackTransaction;
    }

    private void setState(State state) {
        this.state = state;
    }

    final boolean isSessionUnAvailable() {
        return !this.state.equals((Object)State.Opened);
    }

    final void setMaxFieldSize(int n) throws SQLServerException {
        if (this.maxFieldSize != n) {
            if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
                loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
            }
            this.connectionCommand("SET TEXTSIZE " + (0 == n ? Integer.MAX_VALUE : n), "setMaxFieldSize");
            this.maxFieldSize = n;
        }
    }

    final void initResettableValues() {
        this.rolledBackTransaction = false;
        this.transactionIsolationLevel = 2;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.nLockTimeout = -1;
        this.databaseAutoCommitMode = true;
        this.holdability = 1;
        this.sqlWarnings = null;
        this.sCatalog = this.originalCatalog;
        this.databaseMetaData = null;
    }

    final void setMaxRows(int n) throws SQLServerException {
        if (this.maxRows != n) {
            if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
                loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
            }
            this.connectionCommand("SET ROWCOUNT " + n, "setMaxRows");
            this.maxRows = n;
        }
    }

    final SQLCollation getDatabaseCollation() {
        return this.databaseCollation;
    }

    final int getHoldabilityInternal() {
        return this.holdability;
    }

    final int getTDSPacketSize() {
        return this.tdsPacketSize;
    }

    final boolean isKatmaiOrLater() {
        assert (0 != this.tdsVersion);
        assert (this.tdsVersion >= 1913192450);
        return this.tdsVersion >= 1930100739;
    }

    final boolean isDenaliOrLater() {
        return this.tdsVersion >= 0x74000004;
    }

    @Override
    public UUID getClientConnectionId() throws SQLServerException {
        this.checkClosed();
        return this.clientConnectionId;
    }

    final UUID getClientConIdInternal() {
        return this.clientConnectionId;
    }

    final boolean attachConnId() {
        return this.state.equals((Object)State.Connected);
    }

    SQLServerConnection(String string) {
        int n = SQLServerConnection.nextConnectionID();
        this.traceID = "ConnectionID:" + n;
        this.loggingClassName = "com.microsoft.sqlserver.jdbc.SQLServerConnection:" + n;
        if (connectionlogger.isLoggable(Level.FINE)) {
            connectionlogger.fine(this.toString() + " created by (" + string + ")");
        }
        this.initResettableValues();
    }

    void setFailoverPartnerServerProvided(String string) {
        this.failoverPartnerServerProvided = string;
    }

    final void setAssociatedProxy(SQLServerConnectionPoolProxy sQLServerConnectionPoolProxy) {
        this.proxy = sQLServerConnectionPoolProxy;
    }

    final Connection getConnection() {
        if (null != this.proxy) {
            return this.proxy;
        }
        return this;
    }

    final void resetPooledConnection() {
        this.tdsChannel.resetPooledConnection();
        this.initResettableValues();
    }

    private static synchronized int nextConnectionID() {
        return ++baseConnectionID;
    }

    Logger getConnectionLogger() {
        return connectionlogger;
    }

    String getClassNameLogging() {
        return this.loggingClassName;
    }

    public String toString() {
        if (null != this.clientConnectionId) {
            return this.traceID + " ClientConnectionId: " + this.clientConnectionId.toString();
        }
        return this.traceID;
    }

    void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    void checkClosed() throws SQLServerException {
        if (this.isSessionUnAvailable()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    private boolean booleanPropertyOn(String string, String string2) throws SQLServerException {
        if (null == string2) {
            return false;
        }
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals("true")) {
            return true;
        }
        if (string3.equals("false")) {
            return false;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidBooleanValue"));
        Object[] objectArray = new Object[]{new String(string)};
        SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        return false;
    }

    void ValidateMaxSQLLoginName(String string, String string2) throws SQLServerException {
        if (string2 != null && string2.length() > 128) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_propertyMaximumExceedsChars"));
            Object[] objectArray = new Object[]{string, Integer.toString(128)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
    }

    Connection connect(Properties properties, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        int n = 0;
        long l = System.currentTimeMillis();
        int n2 = 0;
        while (true) {
            try {
                return this.connectInternal(properties, sQLServerPooledConnection);
            }
            catch (SQLServerException sQLServerException) {
                if (7 != sQLServerException.getDriverErrorCode()) {
                    throw sQLServerException;
                }
                if (0 == n2) {
                    n = SQLServerDriverIntProperty.LOGIN_TIMEOUT.getDefaultValue();
                    String string = properties.getProperty(SQLServerDriverIntProperty.LOGIN_TIMEOUT.toString());
                    if (null != string && string.length() > 0) {
                        n = Integer.parseInt(string);
                    }
                }
                long l2 = (System.currentTimeMillis() - l) / 1000L;
                if (5 < ++n2) {
                    if (connectionlogger.isLoggable(Level.FINE)) {
                        connectionlogger.fine("Connection failed during SSL handshake. Maximum retry attempt (5) reached.  ");
                    }
                    throw sQLServerException;
                }
                if (l2 >= (long)n) {
                    if (connectionlogger.isLoggable(Level.FINE)) {
                        connectionlogger.fine("Connection failed during SSL handshake. Not retrying as timeout expired.");
                    }
                    throw sQLServerException;
                }
                if (!connectionlogger.isLoggable(Level.FINE)) continue;
                connectionlogger.fine("Connection failed during SSL handshake. Retrying due to an intermittent TLS 1.2 failure issue. Retry attempt = " + n2 + ".");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection connectInternal(Properties properties, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        try {
            Object[] objectArray;
            int n;
            Object object;
            Object[] objectArray2;
            Object object2;
            MessageFormat messageFormat;
            Object object3;
            Object[] objectArray3;
            this.activeConnectionProperties = (Properties)properties.clone();
            this.pooledConnectionParent = sQLServerPooledConnection;
            String string = null;
            String string2 = null;
            string = SQLServerDriverStringProperty.USER.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 == null) {
                string2 = SQLServerDriverStringProperty.USER.getDefaultValue();
                this.activeConnectionProperties.setProperty(string, string2);
            }
            this.ValidateMaxSQLLoginName(string, string2);
            string = SQLServerDriverStringProperty.PASSWORD.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 == null) {
                string2 = SQLServerDriverStringProperty.PASSWORD.getDefaultValue();
                this.activeConnectionProperties.setProperty(string, string2);
            }
            this.ValidateMaxSQLLoginName(string, string2);
            string = SQLServerDriverStringProperty.DATABASE_NAME.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            this.ValidateMaxSQLLoginName(string, string2);
            int n2 = SQLServerDriverIntProperty.LOGIN_TIMEOUT.getDefaultValue();
            string2 = this.activeConnectionProperties.getProperty(SQLServerDriverIntProperty.LOGIN_TIMEOUT.toString());
            if (null != string2 && string2.length() > 0) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    objectArray3 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    Object[] objectArray4 = new Object[]{string2};
                    SQLServerException.makeFromDriverError(this, this, objectArray3.format(objectArray4), null, false);
                }
                if (n2 < 0 || n2 > 65535) {
                    object3 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    objectArray3 = new Object[]{string2};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object3).format(objectArray3), null, false);
                }
            }
            if ((string2 = this.activeConnectionProperties.getProperty(string = SQLServerDriverStringProperty.SERVER_NAME.toString())) == null) {
                string2 = "localhost";
            }
            object3 = SQLServerDriverIntProperty.PORT_NUMBER.toString();
            objectArray3 = this.activeConnectionProperties.getProperty((String)object3);
            int n3 = string2.indexOf(92);
            Object var9_11 = null;
            String string3 = null;
            String string4 = SQLServerDriverStringProperty.INSTANCE_NAME.toString();
            if (n3 >= 0) {
                string3 = string2.substring(n3 + 1, string2.length());
                this.ValidateMaxSQLLoginName(string4, string3);
                string2 = string2.substring(0, n3);
            }
            this.activeConnectionProperties.setProperty(string, string2);
            String string5 = this.activeConnectionProperties.getProperty(string4);
            if (null != string5) {
                string3 = string5;
            }
            if (string3 != null) {
                this.ValidateMaxSQLLoginName(string4, string3);
                this.activeConnectionProperties.setProperty(string4, string3);
            }
            if ((string2 = this.activeConnectionProperties.getProperty(string = SQLServerDriverStringProperty.APPLICATION_NAME.toString())) != null) {
                this.ValidateMaxSQLLoginName(string, string2);
            } else {
                this.activeConnectionProperties.setProperty(string, "Microsoft JDBC Driver for SQL Server");
            }
            string = SQLServerDriverBooleanProperty.LAST_UPDATE_COUNT.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 == null) {
                string2 = Boolean.toString(SQLServerDriverBooleanProperty.LAST_UPDATE_COUNT.getDefaultValue());
                this.activeConnectionProperties.setProperty(string, string2);
            }
            if ((string2 = this.activeConnectionProperties.getProperty(string = SQLServerDriverBooleanProperty.MULTI_SUBNET_FAILOVER.toString())) == null) {
                string2 = Boolean.toString(SQLServerDriverBooleanProperty.MULTI_SUBNET_FAILOVER.getDefaultValue());
                this.activeConnectionProperties.setProperty(string, string2);
            }
            this.multiSubnetFailover = this.booleanPropertyOn(string, string2);
            string = SQLServerDriverBooleanProperty.ENCRYPT.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 == null) {
                string2 = Boolean.toString(SQLServerDriverBooleanProperty.ENCRYPT.getDefaultValue());
                this.activeConnectionProperties.setProperty(string, string2);
            }
            this.requestedEncryptionLevel = this.booleanPropertyOn(string, string2) ? (byte)1 : 0;
            string = SQLServerDriverBooleanProperty.TRUST_SERVER_CERTIFICATE.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 == null) {
                string2 = Boolean.toString(SQLServerDriverBooleanProperty.TRUST_SERVER_CERTIFICATE.getDefaultValue());
                this.activeConnectionProperties.setProperty(string, string2);
            }
            this.trustServerCertificate = this.booleanPropertyOn(string, string2);
            string = SQLServerDriverStringProperty.SELECT_METHOD.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 == null) {
                string2 = SQLServerDriverStringProperty.SELECT_METHOD.getDefaultValue();
            }
            if (string2.equalsIgnoreCase("cursor") || string2.equalsIgnoreCase("direct")) {
                this.activeConnectionProperties.setProperty(string, string2.toLowerCase());
            } else {
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidselectMethod"));
                object2 = new Object[]{new String(string2)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
            }
            string = SQLServerDriverStringProperty.RESPONSE_BUFFERING.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 == null) {
                string2 = SQLServerDriverStringProperty.RESPONSE_BUFFERING.getDefaultValue();
            }
            if (string2.equalsIgnoreCase("full") || string2.equalsIgnoreCase("adaptive")) {
                this.activeConnectionProperties.setProperty(string, string2.toLowerCase());
            } else {
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidresponseBuffering"));
                object2 = new Object[]{new String(string2)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
            }
            string = SQLServerDriverStringProperty.APPLICATION_INTENT.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 == null) {
                string2 = SQLServerDriverStringProperty.APPLICATION_INTENT.getDefaultValue();
            }
            this.applicationIntent = ApplicationIntent.valueOfString(string2);
            this.activeConnectionProperties.setProperty(string, this.applicationIntent.toString());
            string = SQLServerDriverBooleanProperty.SEND_TIME_AS_DATETIME.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 == null) {
                string2 = Boolean.toString(SQLServerDriverBooleanProperty.SEND_TIME_AS_DATETIME.getDefaultValue());
                this.activeConnectionProperties.setProperty(string, string2);
            }
            this.sendTimeAsDatetime = this.booleanPropertyOn(string, string2);
            string = SQLServerDriverBooleanProperty.DISABLE_STATEMENT_POOLING.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (string2 != null && !this.booleanPropertyOn(string, string2)) {
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_invaliddisableStatementPooling"));
                object2 = new Object[]{new String(string2)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
            }
            if ((string2 = this.activeConnectionProperties.getProperty(string = SQLServerDriverBooleanProperty.INTEGRATED_SECURITY.toString())) != null) {
                this.integratedSecurity = this.booleanPropertyOn(string, string2);
            }
            if (this.integratedSecurity && (string2 = this.activeConnectionProperties.getProperty(string = SQLServerDriverStringProperty.AUTHENTICATION_SCHEME.toString())) != null) {
                this.intAuthScheme = AuthenticationScheme.valueOfString(string2);
            }
            string = SQLServerDriverStringProperty.WORKSTATION_ID.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            this.ValidateMaxSQLLoginName(string, string2);
            int n4 = 0;
            string = SQLServerDriverIntProperty.PORT_NUMBER.toString();
            try {
                object2 = this.activeConnectionProperties.getProperty(string);
                if (null != object2 && ((n4 = new Integer((String)object2).intValue()) < 0 || n4 > 65535)) {
                    objectArray2 = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                    object = new Object[]{Integer.toString(n4)};
                    SQLServerException.makeFromDriverError(this, this, objectArray2.format(object), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                objectArray2 = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                object = new Object[]{this.activeConnectionProperties.getProperty(string)};
                SQLServerException.makeFromDriverError(this, this, objectArray2.format(object), null, false);
            }
            string = SQLServerDriverIntProperty.PACKET_SIZE.toString();
            string2 = this.activeConnectionProperties.getProperty(string);
            if (null != string2 && string2.length() > 0) {
                try {
                    this.requestedPacketSize = Integer.parseInt(string2);
                    if (-1 == this.requestedPacketSize) {
                        this.requestedPacketSize = 0;
                    } else if (0 == this.requestedPacketSize) {
                        this.requestedPacketSize = Short.MAX_VALUE;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.requestedPacketSize = -1;
                }
                if (0 != this.requestedPacketSize && (this.requestedPacketSize < 512 || this.requestedPacketSize > Short.MAX_VALUE)) {
                    object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPacketSize"));
                    objectArray2 = new Object[]{string2};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(objectArray2), null, false);
                }
            }
            this.sendStringParametersAsUnicode = null == this.activeConnectionProperties.getProperty(string = SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.toString()) ? SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.getDefaultValue() : this.booleanPropertyOn(string, this.activeConnectionProperties.getProperty(string));
            string = SQLServerDriverBooleanProperty.LAST_UPDATE_COUNT.toString();
            this.lastUpdateCount = this.booleanPropertyOn(string, this.activeConnectionProperties.getProperty(string));
            string = SQLServerDriverBooleanProperty.XOPEN_STATES.toString();
            this.xopenStates = this.booleanPropertyOn(string, this.activeConnectionProperties.getProperty(string));
            string = SQLServerDriverStringProperty.SELECT_METHOD.toString();
            this.selectMethod = null;
            if (this.activeConnectionProperties.getProperty(string) != null && this.activeConnectionProperties.getProperty(string).length() > 0) {
                this.selectMethod = this.activeConnectionProperties.getProperty(string);
            }
            string = SQLServerDriverStringProperty.RESPONSE_BUFFERING.toString();
            this.responseBuffering = null;
            if (this.activeConnectionProperties.getProperty(string) != null && this.activeConnectionProperties.getProperty(string).length() > 0) {
                this.responseBuffering = this.activeConnectionProperties.getProperty(string);
            }
            string = SQLServerDriverIntProperty.LOCK_TIMEOUT.toString();
            this.nLockTimeout = n = SQLServerDriverIntProperty.LOCK_TIMEOUT.getDefaultValue();
            if (this.activeConnectionProperties.getProperty(string) != null && this.activeConnectionProperties.getProperty(string).length() > 0) {
                try {
                    int n5 = new Integer(this.activeConnectionProperties.getProperty(string));
                    if (n5 >= n) {
                        this.nLockTimeout = n5;
                    } else {
                        object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                        objectArray = new Object[]{this.activeConnectionProperties.getProperty(string)};
                        SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                    objectArray = new Object[]{this.activeConnectionProperties.getProperty(string)};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                }
            }
            FailoverInfo failoverInfo = null;
            object = SQLServerDriverStringProperty.DATABASE_NAME.toString();
            objectArray = SQLServerDriverStringProperty.SERVER_NAME.toString();
            String string6 = SQLServerDriverStringProperty.FAILOVER_PARTNER.toString();
            String string7 = this.activeConnectionProperties.getProperty(string6);
            if (this.multiSubnetFailover && string7 != null) {
                SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_dbMirroringWithMultiSubnetFailover"), null, false);
            }
            if (this.applicationIntent != null && this.applicationIntent.equals((Object)ApplicationIntent.READ_ONLY) && string7 != null) {
                SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_dbMirroringWithReadOnlyIntent"), null, false);
            }
            if (null != this.activeConnectionProperties.getProperty((String)object)) {
                failoverInfo = FailoverMapSingleton.getFailoverInfo(this, this.activeConnectionProperties.getProperty((String)objectArray), this.activeConnectionProperties.getProperty(string4), this.activeConnectionProperties.getProperty((String)object));
            } else if (null != string7) {
                SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_failoverPartnerWithoutDB"), null, true);
            }
            String string8 = null;
            if (null == failoverInfo) {
                string8 = string7;
            }
            long l = System.currentTimeMillis();
            this.login(this.activeConnectionProperties.getProperty((String)objectArray), string3, n4, string8, failoverInfo, n2, l);
            if (1 == this.negotiatedEncryptionLevel || 3 == this.negotiatedEncryptionLevel) {
                int n6;
                int n7 = n6 = Util.isIBM() ? 8192 : 16384;
                if (this.tdsPacketSize > n6) {
                    connectionlogger.finer(this.toString() + " Negotiated tdsPacketSize " + this.tdsPacketSize + " is too large for SSL with JRE " + Util.SYSTEM_JRE + " (max size is " + n6 + ")");
                    MessageFormat messageFormat2 = new MessageFormat(SQLServerException.getErrString("R_packetSizeTooBigForSSL"));
                    Object[] objectArray5 = new Object[]{Integer.toString(n6)};
                    this.terminate(6, messageFormat2.format(objectArray5));
                }
            }
            this.state = State.Opened;
            if (connectionlogger.isLoggable(Level.FINER)) {
                connectionlogger.finer(this.toString() + " End of connect");
            }
        }
        finally {
            if (!this.state.equals((Object)State.Opened) && !this.state.equals((Object)State.Closed)) {
                this.close();
            }
        }
        return this;
    }

    private void login(String string, String string2, int n, String string3, FailoverInfo failoverInfo, int n2, long l) throws SQLServerException {
        Object object;
        Object[] objectArray;
        Object object2;
        boolean bl = null != string3 || null != failoverInfo;
        int n3 = 100;
        boolean bl2 = false;
        FailoverInfo failoverInfo2 = null;
        ServerPortPlaceHolder serverPortPlaceHolder = null;
        ServerPortPlaceHolder serverPortPlaceHolder2 = null;
        if (null != failoverInfo) {
            failoverInfo2 = failoverInfo;
            bl2 = failoverInfo.getUseFailoverPartner();
        } else if (bl) {
            failoverInfo2 = new FailoverInfo(string3, this, false);
        }
        boolean bl3 = this.getMultiSubnetFailover();
        if (0 == n2) {
            n2 = SQLServerDriverIntProperty.LOGIN_TIMEOUT.getDefaultValue();
        }
        long l2 = n2 * 1000;
        long l3 = l + l2;
        long l4 = bl || bl3 ? (long)(0.08f * (float)l2) : l2;
        long l5 = l + l4;
        if (connectionlogger.isLoggable(Level.FINER)) {
            connectionlogger.finer(this.toString() + " Start time: " + l + " Time out time: " + l3 + " Timeout Unit Interval: " + l4);
        }
        int n4 = 0;
        int n5 = 0;
        while (true) {
            block34: {
                this.clientConnectionId = null;
                this.state = State.Initialized;
                try {
                    if (bl && bl2) {
                        if (null == serverPortPlaceHolder) {
                            serverPortPlaceHolder = failoverInfo2.failoverPermissionCheck(this, this.integratedSecurity);
                        }
                        this.currentConnectPlaceHolder = serverPortPlaceHolder;
                    } else {
                        if (this.routingInfo != null) {
                            serverPortPlaceHolder2 = this.routingInfo;
                        } else if (null == serverPortPlaceHolder2) {
                            serverPortPlaceHolder2 = this.primaryPermissionCheck(string, string2, n);
                        }
                        this.currentConnectPlaceHolder = serverPortPlaceHolder2;
                    }
                    if (connectionlogger.isLoggable(Level.FINE)) {
                        connectionlogger.fine(this.toString() + " This attempt server name: " + this.currentConnectPlaceHolder.getServerName() + " port: " + this.currentConnectPlaceHolder.getPortNumber() + " InstanceName: " + this.currentConnectPlaceHolder.getInstanceName() + " useParallel: " + bl3);
                        connectionlogger.fine(this.toString() + " This attempt endtime: " + l5);
                        connectionlogger.fine(this.toString() + " This attempt No: " + n4);
                    }
                    this.connectHelper(this.currentConnectPlaceHolder, SQLServerConnection.TimerRemaining(l5), n2, bl3);
                    if (!this.isRoutedInCurrentAttempt) break;
                    if (bl) {
                        object2 = SQLServerException.getErrString("R_invalidRoutingInfo");
                        this.terminate(6, (String)object2);
                    }
                    if (++n5 > 1) {
                        object2 = SQLServerException.getErrString("R_multipleRedirections");
                        this.terminate(6, (String)object2);
                    }
                    if (this.tdsChannel != null) {
                        this.tdsChannel.close();
                    }
                    this.initResettableValues();
                    this.resetNonRoutingEnvchangeValues();
                    ++n4;
                    this.isRoutedInCurrentAttempt = false;
                    bl3 = false;
                    l5 = l3;
                    if (!SQLServerConnection.timerHasExpired(l3)) continue;
                    object2 = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                    objectArray = new Object[]{this.currentConnectPlaceHolder.getServerName(), Integer.toString(this.currentConnectPlaceHolder.getPortNumber()), SQLServerException.getErrString("R_timedOutBeforeRouting")};
                    object = ((Format)object2).format(objectArray);
                    this.terminate(6, (String)object);
                }
                catch (SQLServerException sQLServerException) {
                    long l6;
                    if (18456 == sQLServerException.getErrorCode() || 18488 == sQLServerException.getErrorCode() || 4 == sQLServerException.getDriverErrorCode() || 5 == sQLServerException.getDriverErrorCode() || 7 == sQLServerException.getDriverErrorCode() || 6 == sQLServerException.getDriverErrorCode() || SQLServerConnection.timerHasExpired(l3) || this.state.equals((Object)State.Connected) && !bl) {
                        this.close();
                        throw sQLServerException;
                    }
                    if (null != this.tdsChannel) {
                        this.tdsChannel.close();
                    }
                    if (bl && 1 != n4 % 2 || (l6 = (long)SQLServerConnection.TimerRemaining(l3)) > (long)n3) break block34;
                    throw sQLServerException;
                }
            }
            if (!bl || 1 == n4 % 2) {
                if (connectionlogger.isLoggable(Level.FINE)) {
                    connectionlogger.fine(this.toString() + " sleeping milisec: " + n3);
                }
                try {
                    Thread.sleep(n3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n3 = n3 < 500 ? n3 * 2 : 1000;
            }
            if ((l5 = bl3 ? System.currentTimeMillis() + l4 * (long)(n4 + 1) : (bl ? System.currentTimeMillis() + l4 * (long)(++n4 / 2 + 1) : l3)) > l3) {
                l5 = l3;
            }
            if (!bl) continue;
            bl2 = !bl2;
        }
        if (bl2 && null == this.failoverPartnerServerProvided) {
            object2 = this.currentConnectPlaceHolder.getServerName();
            if (null != serverPortPlaceHolder.getInstanceName()) {
                object2 = (String)object2 + "\\";
                object2 = (String)object2 + serverPortPlaceHolder.getInstanceName();
            }
            objectArray = new MessageFormat(SQLServerException.getErrString("R_invalidPartnerConfiguration"));
            object = new Object[]{new String(this.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.DATABASE_NAME.toString())), object2};
            this.terminate(6, objectArray.format(object));
        }
        if (null != this.failoverPartnerServerProvided) {
            if (this.multiSubnetFailover) {
                object2 = SQLServerException.getErrString("R_dbMirroringWithMultiSubnetFailover");
                this.terminate(6, (String)object2);
            }
            if (this.applicationIntent != null && this.applicationIntent.equals((Object)ApplicationIntent.READ_ONLY)) {
                object2 = SQLServerException.getErrString("R_dbMirroringWithReadOnlyIntent");
                this.terminate(6, (String)object2);
            }
            if (null == failoverInfo2) {
                failoverInfo2 = new FailoverInfo(this.failoverPartnerServerProvided, this, false);
            }
            if (null != failoverInfo) {
                failoverInfo.failoverAdd(this, bl2, this.failoverPartnerServerProvided);
            } else {
                object2 = SQLServerDriverStringProperty.DATABASE_NAME.toString();
                objectArray = SQLServerDriverStringProperty.INSTANCE_NAME.toString();
                object = SQLServerDriverStringProperty.SERVER_NAME.toString();
                if (connectionlogger.isLoggable(Level.FINE)) {
                    connectionlogger.fine(this.toString() + " adding new failover info server: " + this.activeConnectionProperties.getProperty((String)object) + " instance: " + this.activeConnectionProperties.getProperty((String)objectArray) + " database: " + this.activeConnectionProperties.getProperty((String)object2) + " server provided failover: " + this.failoverPartnerServerProvided);
                }
                failoverInfo2.failoverAdd(this, bl2, this.failoverPartnerServerProvided);
                FailoverMapSingleton.putFailoverInfo(this, string, this.activeConnectionProperties.getProperty((String)objectArray), this.activeConnectionProperties.getProperty((String)object2), failoverInfo2, bl2, this.failoverPartnerServerProvided);
            }
        }
    }

    void resetNonRoutingEnvchangeValues() {
        this.tdsPacketSize = 4096;
        this.databaseCollation = null;
        this.rolledBackTransaction = false;
        Arrays.fill(this.getTransactionDescriptor(), (byte)0);
        this.sCatalog = this.originalCatalog;
        this.failoverPartnerServerProvided = null;
    }

    ServerPortPlaceHolder primaryPermissionCheck(String string, String string2, int n) throws SQLServerException {
        block8: {
            if (0 == n) {
                if (null != string2) {
                    String string3 = this.getInstancePort(string, string2);
                    if (connectionlogger.isLoggable(Level.FINER)) {
                        connectionlogger.fine(this.toString() + "SQL Server port returned by SQL Browser: " + string3);
                    }
                    try {
                        if (null != string3) {
                            n = new Integer(string3);
                            if (n < 0 || n > 65535) {
                                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                                Object[] objectArray = new Object[]{Integer.toString(n)};
                                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
                            }
                            break block8;
                        }
                        n = DEFAULTPORT;
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                        Object[] objectArray = new Object[]{n};
                        SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
                    }
                } else {
                    n = DEFAULTPORT;
                }
            }
        }
        this.activeConnectionProperties.setProperty(SQLServerDriverIntProperty.PORT_NUMBER.toString(), String.valueOf(n));
        return new ServerPortPlaceHolder(string, n, string2, this.integratedSecurity);
    }

    static boolean timerHasExpired(long l) {
        boolean bl = System.currentTimeMillis() > l;
        return bl;
    }

    static int TimerRemaining(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l - l2;
        if (l3 > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        if (l3 <= 0L) {
            l3 = 1L;
        }
        return (int)l3;
    }

    private void connectHelper(ServerPortPlaceHolder serverPortPlaceHolder, int n, int n2, boolean bl) throws SQLServerException {
        if (connectionlogger.isLoggable(Level.FINE)) {
            connectionlogger.fine(this.toString() + " Connecting with server: " + serverPortPlaceHolder.getServerName() + " port: " + serverPortPlaceHolder.getPortNumber() + " Timeout slice: " + n + " Timeout Full: " + n2);
        }
        this.tdsChannel = new TDSChannel(this);
        if (0 == n2) {
            this.tdsChannel.open(serverPortPlaceHolder.getServerName(), serverPortPlaceHolder.getPortNumber(), 0, bl);
        } else {
            this.tdsChannel.open(serverPortPlaceHolder.getServerName(), serverPortPlaceHolder.getPortNumber(), n, bl);
        }
        this.setState(State.Connected);
        this.clientConnectionId = UUID.randomUUID();
        assert (null != this.clientConnectionId);
        this.Prelogin(serverPortPlaceHolder.getServerName(), serverPortPlaceHolder.getPortNumber());
        if (2 != this.negotiatedEncryptionLevel) {
            this.tdsChannel.enableSSL(serverPortPlaceHolder.getServerName(), serverPortPlaceHolder.getPortNumber());
        }
        this.executeCommand(new LogonCommand());
    }

    void Prelogin(String string, int n) throws SQLServerException {
        int n2;
        byte[] byArray = new byte[]{18, 1, 0, 67, 0, 0, 0, 0, 0, 0, 16, 0, 6, 1, 0, 22, 0, 1, 5, 0, 23, 0, 36, -1, 0, 0, 0, 0, 0, 0, this.requestedEncryptionLevel, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray2 = new byte[4096];
        String string2 = " Prelogin error: host " + string + " port " + n;
        ActivityId activityId = ActivityCorrelator.getNext();
        byte[] byArray3 = Util.asGuidByteArray(activityId.getId());
        byte[] byArray4 = Util.asGuidByteArray(this.clientConnectionId);
        int n3 = byArray.length - 36;
        System.arraycopy(byArray4, 0, byArray, n3, byArray4.length);
        System.arraycopy(byArray3, 0, byArray, n3 += byArray4.length, byArray3.length);
        long l = activityId.getSequence();
        Util.writeInt((int)l, byArray, n3 += byArray3.length);
        n3 += 4;
        if (connectionlogger.isLoggable(Level.FINER)) {
            connectionlogger.finer(this.toString() + " Requesting encryption level:" + TDS.getEncryptionLevel(this.requestedEncryptionLevel));
            connectionlogger.finer(this.toString() + " ActivityId " + activityId.toString());
        }
        if (this.tdsChannel.isLoggingPackets()) {
            this.tdsChannel.logPacket(byArray, 0, byArray.length, this.toString() + " Prelogin request");
        }
        try {
            this.tdsChannel.write(byArray, 0, byArray.length);
            this.tdsChannel.flush();
        }
        catch (SQLServerException sQLServerException) {
            connectionlogger.warning(this.toString() + string2 + " Error sending prelogin request: " + sQLServerException.getMessage());
            throw sQLServerException;
        }
        ActivityCorrelator.setCurrentActivityIdSentFlag();
        int n4 = byArray2.length;
        int n5 = 0;
        boolean bl = false;
        while (n5 < n4) {
            Object[] objectArray;
            MessageFormat messageFormat;
            try {
                n2 = this.tdsChannel.read(byArray2, n5, n4 - n5);
            }
            catch (SQLServerException sQLServerException) {
                connectionlogger.warning(this.toString() + string2 + " Error reading prelogin response: " + sQLServerException.getMessage());
                throw sQLServerException;
            }
            if (-1 == n2) {
                connectionlogger.warning(this.toString() + string2 + " Unexpected end of prelogin response after " + n5 + " bytes read");
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                objectArray = new Object[]{string, Integer.toString(n), SQLServerException.getErrString("R_notSQLServer")};
                this.terminate(3, messageFormat.format(objectArray));
            }
            assert (n2 >= 0);
            assert (n2 <= n4 - n5);
            if (this.tdsChannel.isLoggingPackets()) {
                this.tdsChannel.logPacket(byArray2, n5, n2, this.toString() + " Prelogin response");
            }
            if (bl || (n5 += n2) < 8) continue;
            if (4 != byArray2[0]) {
                connectionlogger.warning(this.toString() + string2 + " Unexpected response type:" + byArray2[0]);
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                objectArray = new Object[]{string, Integer.toString(n), SQLServerException.getErrString("R_notSQLServer")};
                this.terminate(3, messageFormat.format(objectArray));
            }
            if (1 != (1 & byArray2[1])) {
                connectionlogger.warning(this.toString() + string2 + " Unexpected response status:" + byArray2[1]);
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                objectArray = new Object[]{string, Integer.toString(n), SQLServerException.getErrString("R_notSQLServer")};
                this.terminate(3, messageFormat.format(objectArray));
            }
            n4 = Util.readUnsignedShortBigEndian(byArray2, 2);
            assert (n4 >= 0);
            if (n4 >= byArray2.length) {
                connectionlogger.warning(this.toString() + string2 + " Response length:" + n4 + " is greater than allowed length:" + byArray2.length);
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                objectArray = new Object[]{string, Integer.toString(n), SQLServerException.getErrString("R_notSQLServer")};
                this.terminate(3, messageFormat.format(objectArray));
            }
            bl = true;
        }
        n2 = 0;
        this.negotiatedEncryptionLevel = (byte)-1;
        int n6 = 8;
        block9: while (true) {
            byte by;
            if (n6 >= n4) {
                connectionlogger.warning(this.toString() + " Option token not found");
                this.throwInvalidTDS();
            }
            if (-1 == (by = byArray2[n6++])) break;
            if (n6 + 4 >= n4) {
                connectionlogger.warning(this.toString() + " Offset/Length not found for option:" + by);
                this.throwInvalidTDS();
            }
            int n7 = Util.readUnsignedShortBigEndian(byArray2, n6) + 8;
            n6 += 2;
            assert (n7 >= 0);
            int n8 = Util.readUnsignedShortBigEndian(byArray2, n6);
            n6 += 2;
            assert (n8 >= 0);
            if (n7 + n8 > n4) {
                connectionlogger.warning(this.toString() + " Offset:" + n7 + " and length:" + n8 + " exceed response length:" + n4);
                this.throwInvalidTDS();
            }
            switch (by) {
                case 0: {
                    if (n2 != 0) {
                        connectionlogger.warning(this.toString() + " Version option already received");
                        this.throwInvalidTDS();
                    }
                    if (6 != n8) {
                        connectionlogger.warning(this.toString() + " Version option length:" + n8 + " is incorrect.  Correct value is 6.");
                        this.throwInvalidTDS();
                    }
                    this.serverMajorVersion = byArray2[n7];
                    if (this.serverMajorVersion < 9) {
                        connectionlogger.warning(this.toString() + " Server major version:" + this.serverMajorVersion + " is not supported by this driver.");
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedServerVersion"));
                        Object[] objectArray = new Object[]{Integer.toString(byArray2[n7])};
                        this.terminate(6, messageFormat.format(objectArray));
                    }
                    if (connectionlogger.isLoggable(Level.FINE)) {
                        connectionlogger.fine(this.toString() + " Server returned major version:" + byArray2[n7]);
                    }
                    n2 = 1;
                    continue block9;
                }
                case 1: {
                    if (-1 != this.negotiatedEncryptionLevel) {
                        connectionlogger.warning(this.toString() + " Encryption option already received");
                        this.throwInvalidTDS();
                    }
                    if (1 != n8) {
                        connectionlogger.warning(this.toString() + " Encryption option length:" + n8 + " is incorrect.  Correct value is 1.");
                        this.throwInvalidTDS();
                    }
                    this.negotiatedEncryptionLevel = byArray2[n7];
                    if (0 != this.negotiatedEncryptionLevel && 1 != this.negotiatedEncryptionLevel && 3 != this.negotiatedEncryptionLevel && 2 != this.negotiatedEncryptionLevel) {
                        connectionlogger.warning(this.toString() + " Server returned " + TDS.getEncryptionLevel(this.negotiatedEncryptionLevel));
                        this.throwInvalidTDS();
                    }
                    if (connectionlogger.isLoggable(Level.FINER)) {
                        connectionlogger.finer(this.toString() + " Negotiated encryption level:" + TDS.getEncryptionLevel(this.negotiatedEncryptionLevel));
                    }
                    if (1 == this.requestedEncryptionLevel && 1 != this.negotiatedEncryptionLevel && 3 != this.negotiatedEncryptionLevel) {
                        this.terminate(5, SQLServerException.getErrString("R_sslRequiredNoServerSupport"));
                    }
                    if (2 != this.requestedEncryptionLevel || 2 == this.negotiatedEncryptionLevel) continue block9;
                    if (3 == this.negotiatedEncryptionLevel) {
                        this.terminate(5, SQLServerException.getErrString("R_sslRequiredByServer"));
                    }
                    connectionlogger.warning(this.toString() + " Client requested encryption level: " + TDS.getEncryptionLevel(this.requestedEncryptionLevel) + " Server returned unexpected encryption level: " + TDS.getEncryptionLevel(this.negotiatedEncryptionLevel));
                    this.throwInvalidTDS();
                    continue block9;
                }
            }
            if (!connectionlogger.isLoggable(Level.FINER)) continue;
            connectionlogger.finer(this.toString() + " Ignoring prelogin response option:" + by);
        }
        if (n2 == 0 || -1 == this.negotiatedEncryptionLevel) {
            connectionlogger.warning(this.toString() + " Prelogin response is missing version and/or encryption option.");
            this.throwInvalidTDS();
        }
    }

    final void throwInvalidTDS() throws SQLServerException {
        this.terminate(4, SQLServerException.getErrString("R_invalidTDS"));
    }

    final void throwInvalidTDSToken(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unexpectedToken"));
        Object[] objectArray = new Object[]{string};
        String string2 = SQLServerException.getErrString("R_invalidTDS") + messageFormat.format(objectArray);
        this.terminate(4, string2);
    }

    final void terminate(int n, String string) throws SQLServerException {
        this.terminate(n, string, null);
    }

    final void terminate(int n, String string, Throwable throwable) throws SQLServerException {
        String string2;
        String string3 = string2 = this.state.equals((Object)State.Opened) ? "08006" : "08001";
        if (!this.xopenStates) {
            string2 = SQLServerException.mapFromXopen(string2);
        }
        SQLServerException sQLServerException = new SQLServerException((Object)this, SQLServerException.checkAndAppendClientConnId(string, this), string2, 0, true);
        if (null != throwable) {
            sQLServerException.initCause(throwable);
        }
        sQLServerException.setDriverErrorCode(n);
        this.notifyPooledConnection(sQLServerException);
        this.close();
        throw sQLServerException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeCommand(TDSCommand tDSCommand) throws SQLServerException {
        Object object = this.schedulerLock;
        synchronized (object) {
            if (null != this.currentCommand) {
                this.currentCommand.detach();
                this.currentCommand = null;
            }
            boolean bl = false;
            try {
                bl = tDSCommand.execute(this.tdsChannel.getWriter(), this.tdsChannel.getReader(tDSCommand));
            }
            finally {
                assert (null == this.currentCommand);
                if (!bl && !this.isSessionUnAvailable()) {
                    this.currentCommand = tDSCommand;
                }
            }
            return bl;
        }
    }

    private final void connectionCommand(String string, String string2) throws SQLServerException {
        final class ConnectionCommand
        extends UninterruptableTDSCommand {
            final String sql;

            ConnectionCommand(String string, String string2) {
                super(string2);
                this.sql = string;
            }

            @Override
            final boolean doExecute() throws SQLServerException {
                this.startRequest((byte)1).writeString(this.sql);
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new ConnectionCommand(string, string2));
    }

    private String sqlStatementToInitialize() {
        String string = null;
        if (this.nLockTimeout > -1) {
            string = " set lock_timeout " + this.nLockTimeout;
        }
        return string;
    }

    void setCatalogName(String string) {
        if (string != null && string.length() > 0) {
            this.sCatalog = string;
        }
    }

    String sqlStatementToSetTransactionIsolationLevel() throws SQLServerException {
        String string = "set transaction isolation level ";
        switch (this.transactionIsolationLevel) {
            case 1: {
                string = string + " read uncommitted ";
                break;
            }
            case 2: {
                string = string + " read committed ";
                break;
            }
            case 4: {
                string = string + " repeatable read ";
                break;
            }
            case 8: {
                string = string + " serializable ";
                break;
            }
            case 4096: {
                string = string + " snapshot ";
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidTransactionLevel"));
                Object[] objectArray = new Object[]{Integer.toString(this.transactionIsolationLevel)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
            }
        }
        return string;
    }

    static String sqlStatementToSetCommit(boolean bl) {
        return true == bl ? "set implicit_transactions off " : "set implicit_transactions on ";
    }

    @Override
    public Statement createStatement() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "createStatement");
        Statement statement = this.createStatement(1003, 1007);
        loggerExternal.exiting(this.getClassNameLogging(), "createStatement", statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", string);
        PreparedStatement preparedStatement = this.prepareStatement(string, 1003, 1007);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", preparedStatement);
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareCall", string);
        CallableStatement callableStatement = this.prepareCall(string, 1003, 1007);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareCall", callableStatement);
        return callableStatement;
    }

    @Override
    public String nativeSQL(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "nativeSQL", string);
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "nativeSQL", string);
        return string;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAutoCommit", bl);
            if (Util.IsActivityTraceOn()) {
                loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
            }
        }
        String string = "";
        this.checkClosed();
        if (bl == this.databaseAutoCommitMode) {
            return;
        }
        if (bl) {
            string = "IF @@TRANCOUNT > 0 COMMIT TRAN ";
        }
        if (connectionlogger.isLoggable(Level.FINER)) {
            connectionlogger.finer(this.toString() + " Autocommitmode current :" + this.databaseAutoCommitMode + " new: " + bl);
        }
        this.rolledBackTransaction = false;
        this.connectionCommand(string + SQLServerConnection.sqlStatementToSetCommit(bl), "setAutoCommit");
        this.databaseAutoCommitMode = bl;
        loggerExternal.exiting(this.getClassNameLogging(), "setAutoCommit");
    }

    @Override
    public boolean getAutoCommit() throws SQLServerException {
        boolean bl;
        loggerExternal.entering(this.getClassNameLogging(), "getAutoCommit");
        this.checkClosed();
        boolean bl2 = bl = !this.inXATransaction && this.databaseAutoCommitMode;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getAutoCommit", bl);
        }
        return bl;
    }

    final byte[] getTransactionDescriptor() {
        return this.transactionDescriptor;
    }

    @Override
    public void commit() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "commit");
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        if (!this.databaseAutoCommitMode) {
            this.connectionCommand("IF @@TRANCOUNT > 0 COMMIT TRAN", "Connection.commit");
        }
        loggerExternal.exiting(this.getClassNameLogging(), "commit");
    }

    @Override
    public void rollback() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "rollback");
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, true);
        } else {
            this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "Connection.rollback");
        }
        loggerExternal.exiting(this.getClassNameLogging(), "rollback");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        Object[] objectArray;
        Object object;
        loggerExternal.entering(this.getClassNameLogging(), "abort", executor);
        DriverJDBCVersion.checkSupportsJDBC41();
        if (this.isClosed()) {
            return;
        }
        if (null == executor) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
            objectArray = new Object[]{"executor"};
            SQLServerException.makeFromDriverError(null, null, ((Format)object).format(objectArray), null, false);
        }
        if ((object = System.getSecurityManager()) != null) {
            try {
                objectArray = new SQLPermission(callAbortPerm);
                ((SecurityManager)object).checkPermission((Permission)objectArray);
            }
            catch (SecurityException securityException) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_permissionDenied"));
                Object[] objectArray2 = new Object[]{callAbortPerm};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray2), null, true);
            }
        }
        this.setState(State.Closed);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (null != SQLServerConnection.this.tdsChannel) {
                    SQLServerConnection.this.tdsChannel.close();
                }
            }
        });
        loggerExternal.exiting(this.getClassNameLogging(), "abort");
    }

    @Override
    public void close() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "close");
        this.setState(State.Closed);
        if (null != this.tdsChannel) {
            this.tdsChannel.close();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "close");
    }

    final void poolCloseEventNotify() throws SQLServerException {
        if (this.state.equals((Object)State.Opened) && null != this.pooledConnectionParent) {
            if (!this.databaseAutoCommitMode && !(this.pooledConnectionParent instanceof XAConnection)) {
                this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "close connection");
            }
            this.notifyPooledConnection(null);
            if (connectionlogger.isLoggable(Level.FINER)) {
                connectionlogger.finer(this.toString() + " Connection closed and returned to connection pool");
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "isClosed");
        loggerExternal.exiting(this.getClassNameLogging(), "isClosed", this.isSessionUnAvailable());
        return this.isSessionUnAvailable();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMetaData");
        this.checkClosed();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new SQLServerDatabaseMetaData(this);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getMetaData", this.databaseMetaData);
        return this.databaseMetaData;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setReadOnly", bl);
        }
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "setReadOnly");
    }

    @Override
    public boolean isReadOnly() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "isReadOnly");
        this.checkClosed();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "isReadOnly", false);
        }
        return false;
    }

    @Override
    public void setCatalog(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setCatalog", string);
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        if (string != null) {
            this.connectionCommand("use " + Util.escapeSQLId(string), "setCatalog");
            this.sCatalog = string;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setCatalog");
    }

    @Override
    public String getCatalog() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getCatalog");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getCatalog", this.sCatalog);
        return this.sCatalog;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTransactionIsolation", new Integer(n));
            if (Util.IsActivityTraceOn()) {
                loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
            }
        }
        this.checkClosed();
        if (n == 0) {
            return;
        }
        this.transactionIsolationLevel = n;
        String string = this.sqlStatementToSetTransactionIsolationLevel();
        this.connectionCommand(string, "setTransactionIsolation");
        loggerExternal.exiting(this.getClassNameLogging(), "setTransactionIsolation");
    }

    @Override
    public int getTransactionIsolation() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTransactionIsolation");
        this.checkClosed();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getTransactionIsolation", new Integer(this.transactionIsolationLevel));
        }
        return this.transactionIsolationLevel;
    }

    @Override
    public SQLWarning getWarnings() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getWarnings");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getWarnings", this.sqlWarnings);
        return this.sqlWarnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWarning(String string) {
        Integer n = this.warningSynchronization;
        synchronized (n) {
            SQLWarning sQLWarning = new SQLWarning(string);
            if (null == this.sqlWarnings) {
                this.sqlWarnings = sQLWarning;
            } else {
                this.sqlWarnings.setNextWarning(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLServerException {
        Integer n = this.warningSynchronization;
        synchronized (n) {
            loggerExternal.entering(this.getClassNameLogging(), "clearWarnings");
            this.checkClosed();
            this.sqlWarnings = null;
            loggerExternal.exiting(this.getClassNameLogging(), "clearWarnings");
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "createStatement", new Object[]{new Integer(n), new Integer(n2)});
        }
        this.checkClosed();
        SQLServerStatement sQLServerStatement = new SQLServerStatement(this, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "createStatement", sQLServerStatement);
        return sQLServerStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{string, new Integer(n), new Integer(n2)});
        }
        this.checkClosed();
        SQLServerPreparedStatement sQLServerPreparedStatement = new SQLServerPreparedStatement(this, string, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", sQLServerPreparedStatement);
        return sQLServerPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "prepareCall", new Object[]{string, new Integer(n), new Integer(n2)});
        }
        this.checkClosed();
        SQLServerCallableStatement sQLServerCallableStatement = new SQLServerCallableStatement(this, string, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareCall", sQLServerCallableStatement);
        return sQLServerCallableStatement;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setTypeMap", map);
        this.checkClosed();
        if (map != null && map instanceof HashMap && map.isEmpty()) {
            loggerExternal.exiting(this.getClassNameLogging(), "setTypeMap");
            return;
        }
        this.NotImplemented();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTypeMap");
        this.checkClosed();
        HashMap hashMap = new HashMap();
        loggerExternal.exiting(this.getClassNameLogging(), "getTypeMap", hashMap);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logon(LogonCommand logonCommand) throws SQLServerException {
        SSPIAuthentication sSPIAuthentication = null;
        if (this.integratedSecurity && AuthenticationScheme.nativeAuthentication == this.intAuthScheme) {
            sSPIAuthentication = new AuthenticationJNI(this, this.currentConnectPlaceHolder.getServerName(), this.currentConnectPlaceHolder.getPortNumber());
        }
        if (this.integratedSecurity && AuthenticationScheme.javaKerberos == this.intAuthScheme) {
            sSPIAuthentication = new KerbAuthentication(this, this.currentConnectPlaceHolder.getServerName(), this.currentConnectPlaceHolder.getPortNumber());
        }
        try {
            this.sendLogon(logonCommand, sSPIAuthentication);
            if (!this.isRoutedInCurrentAttempt) {
                this.originalCatalog = this.sCatalog;
                String string = this.sqlStatementToInitialize();
                if (string != null) {
                    this.connectionCommand(string, "Change Settings");
                }
            }
        }
        finally {
            if (this.integratedSecurity) {
                if (null != sSPIAuthentication) {
                    sSPIAuthentication.ReleaseClientContext();
                }
                sSPIAuthentication = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void processEnvChange(TDSReader tDSReader) throws SQLServerException {
        tDSReader.readUnsignedByte();
        int n = tDSReader.readUnsignedShort();
        TDSReaderMark tDSReaderMark = tDSReader.mark();
        int n2 = tDSReader.readUnsignedByte();
        switch (n2) {
            case 4: {
                try {
                    this.tdsPacketSize = Integer.parseInt(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                }
                catch (NumberFormatException numberFormatException) {
                    tDSReader.throwInvalidTDS();
                }
                if (!connectionlogger.isLoggable(Level.FINER)) break;
                connectionlogger.finer(this.toString() + " Network packet size is " + this.tdsPacketSize + " bytes");
                break;
            }
            case 7: {
                if (SQLCollation.tdsLength() != tDSReader.readUnsignedByte()) {
                    tDSReader.throwInvalidTDS();
                }
                try {
                    this.databaseCollation = new SQLCollation(tDSReader);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.terminate(4, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
                break;
            }
            case 8: 
            case 11: {
                this.rolledBackTransaction = false;
                byte[] byArray = this.getTransactionDescriptor();
                if (byArray.length != tDSReader.readUnsignedByte()) {
                    tDSReader.throwInvalidTDS();
                }
                tDSReader.readBytes(byArray, 0, byArray.length);
                if (!connectionlogger.isLoggable(Level.FINER)) break;
                String string = 8 == n2 ? " started" : " enlisted";
                connectionlogger.finer(this.toString() + string);
                break;
            }
            case 10: {
                this.rolledBackTransaction = true;
                if (this.inXATransaction) {
                    if (!connectionlogger.isLoggable(Level.FINER)) break;
                    connectionlogger.finer(this.toString() + " rolled back. (DTC)");
                    break;
                }
                if (connectionlogger.isLoggable(Level.FINER)) {
                    connectionlogger.finer(this.toString() + " rolled back");
                }
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 9: {
                if (connectionlogger.isLoggable(Level.FINER)) {
                    connectionlogger.finer(this.toString() + " committed");
                }
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 12: {
                if (connectionlogger.isLoggable(Level.FINER)) {
                    connectionlogger.finer(this.toString() + " defected");
                }
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 1: {
                this.setCatalogName(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                break;
            }
            case 13: {
                this.setFailoverPartnerServerProvided(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (!connectionlogger.isLoggable(Level.FINER)) break;
                connectionlogger.finer(this.toString() + " Ignored env change: " + n2);
                break;
            }
            case 20: {
                int n3 = -1;
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                String string = null;
                try {
                    n6 = tDSReader.readUnsignedShort();
                    if (n6 <= 5) {
                        this.throwInvalidTDS();
                    }
                    if ((n5 = tDSReader.readUnsignedByte()) != 0) {
                        this.throwInvalidTDS();
                    }
                    if ((n4 = tDSReader.readUnsignedShort()) <= 0 || n4 > 65535) {
                        this.throwInvalidTDS();
                    }
                    if ((n3 = tDSReader.readUnsignedShort()) <= 0 || n3 > 1024) {
                        this.throwInvalidTDS();
                    }
                    string = tDSReader.readUnicodeString(n3);
                    assert (string != null);
                    if (connectionlogger.isLoggable(Level.FINER)) {
                        connectionlogger.finer(this.toString() + " Received routing ENVCHANGE with the following values." + " routingDataValueLength:" + n6 + " protocol:" + n5 + " portNumber:" + n4 + " serverNameLength:" + n3 + " serverName:" + (string != null ? string : "null"));
                    }
                }
                catch (Throwable throwable) {
                    if (connectionlogger.isLoggable(Level.FINER)) {
                        connectionlogger.finer(this.toString() + " Received routing ENVCHANGE with the following values." + " routingDataValueLength:" + n6 + " protocol:" + n5 + " portNumber:" + n4 + " serverNameLength:" + n3 + " serverName:" + (string != null ? string : "null"));
                    }
                    throw throwable;
                }
                String string2 = this.activeConnectionProperties.getProperty("hostNameInCertificate");
                if (null != string2 && string2.startsWith("*") && string.indexOf(46) != -1) {
                    char[] cArray = string2.toCharArray();
                    char[] cArray2 = string.toCharArray();
                    boolean bl = true;
                    int n7 = string2.length() - 1;
                    for (int i = string.length() - 1; n7 > 0 && i > 0; --n7, --i) {
                        if (cArray2[i] == cArray[n7]) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        String string3 = "*" + string.substring(string.indexOf(46));
                        this.activeConnectionProperties.setProperty("hostNameInCertificate", string3);
                        if (connectionlogger.isLoggable(Level.FINER)) {
                            connectionlogger.finer(this.toString() + "Using new host to validate the SSL certificate");
                        }
                    }
                }
                this.isRoutedInCurrentAttempt = true;
                this.routingInfo = new ServerPortPlaceHolder(string, n4, null, this.integratedSecurity);
                break;
            }
            default: {
                connectionlogger.warning(this.toString() + " Unknown environment change: " + n2);
                this.throwInvalidTDS();
            }
        }
        tDSReader.reset(tDSReaderMark);
        tDSReader.readBytes(new byte[n], 0, n);
    }

    private final void executeDTCCommand(int n, byte[] byArray, String string) throws SQLServerException {
        final class DTCCommand
        extends UninterruptableTDSCommand {
            private final int requestType;
            private final byte[] payload;

            DTCCommand(int n, byte[] byArray, String string) {
                super(string);
                this.requestType = n;
                this.payload = byArray;
            }

            @Override
            final boolean doExecute() throws SQLServerException {
                TDSWriter tDSWriter = this.startRequest((byte)14);
                tDSWriter.writeShort((short)this.requestType);
                if (null == this.payload) {
                    tDSWriter.writeShort((short)0);
                } else {
                    assert (this.payload.length <= Short.MAX_VALUE);
                    tDSWriter.writeShort((short)this.payload.length);
                    tDSWriter.writeBytes(this.payload);
                }
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new DTCCommand(n, byArray, string));
    }

    final void JTAUnenlistConnection() throws SQLServerException {
        this.executeDTCCommand(1, null, "MS_DTC unenlist connection");
        this.inXATransaction = false;
    }

    final void JTAEnlistConnection(byte[] byArray) throws SQLServerException {
        this.executeDTCCommand(1, byArray, "MS_DTC enlist connection");
        this.connectionCommand(this.sqlStatementToSetTransactionIsolationLevel(), "JTAEnlistConnection");
        this.inXATransaction = true;
    }

    private byte[] toUCS16(String string) throws SQLServerException {
        if (string == null) {
            return new byte[0];
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = (byte)(c & 0xFF);
            byArray[n2++] = by;
            byArray[n2++] = (byte)(c >> 8 & 0xFF);
        }
        return byArray;
    }

    private byte[] encryptPassword(String string) {
        if (string == null) {
            string = "";
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            byte by;
            byte by2;
            int n2 = string.charAt(i) ^ 0x5A5A;
            n2 = (n2 & 0xF) << 4 | (n2 & 0xF0) >> 4 | (n2 & 0xF00) << 4 | (n2 & 0xF000) >> 4;
            byArray[i * 2 + 1] = by2 = (byte)((n2 & 0xFF00) >> 8);
            byArray[i * 2 + 0] = by = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    private void sendLogon(LogonCommand logonCommand, SSPIAuthentication sSPIAuthentication) throws SQLServerException {
        TDSReader tDSReader;
        String string = this.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.WORKSTATION_ID.toString());
        String string2 = this.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.USER.toString());
        String string3 = this.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.PASSWORD.toString());
        String string4 = this.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.APPLICATION_NAME.toString());
        String string5 = "Microsoft JDBC Driver 4.2";
        String string6 = this.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.DATABASE_NAME.toString());
        String string7 = null;
        string7 = null != this.currentConnectPlaceHolder ? this.currentConnectPlaceHolder.getServerName() : this.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.SERVER_NAME.toString());
        if (string7 != null && string7.length() > 128) {
            string7 = string7.substring(0, 128);
        }
        if (string == null || string.length() == 0) {
            string = Util.lookupHostName();
        }
        byte[] byArray = new byte[]{};
        boolean[] blArray = new boolean[]{false};
        if (null != sSPIAuthentication) {
            byArray = sSPIAuthentication.GenerateClientContext(byArray, blArray);
            string2 = null;
            string3 = null;
        }
        byte[] byArray2 = this.toUCS16(string);
        byte[] byArray3 = this.toUCS16(string2);
        byte[] byArray4 = this.encryptPassword(string3);
        int n = byArray4 != null ? byArray4.length : 0;
        byte[] byArray5 = this.toUCS16(string4);
        byte[] byArray6 = this.toUCS16(string7);
        byte[] byArray7 = this.toUCS16(string5);
        byte[] byArray8 = this.toUCS16(string6);
        byte[] byArray9 = new byte[6];
        int n2 = 0;
        int n3 = 0;
        if (this.serverMajorVersion >= 11) {
            this.tdsVersion = 0x74000004;
        } else if (this.serverMajorVersion >= 10) {
            this.tdsVersion = 1930100739;
        } else if (this.serverMajorVersion >= 9) {
            this.tdsVersion = 1913192450;
        } else assert (false) : "prelogin did not disconnect for the old version: " + this.serverMajorVersion;
        n2 = n + byArray2.length + byArray3.length + byArray5.length + byArray6.length + byArray7.length + byArray8.length + 94 + byArray.length;
        TDSWriter tDSWriter = logonCommand.startRequest((byte)16);
        tDSWriter.writeInt(n2);
        tDSWriter.writeInt(this.tdsVersion);
        tDSWriter.writeInt(this.requestedPacketSize);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeByte((byte)-32);
        tDSWriter.writeByte((byte)(3 | (this.integratedSecurity ? -128 : 0)));
        tDSWriter.writeByte((byte)(0 | (this.applicationIntent != null && this.applicationIntent.equals((Object)ApplicationIntent.READ_ONLY) ? 32 : 0)));
        tDSWriter.writeByte((byte)(0 | (this.serverMajorVersion >= 10 ? 8 : 0)));
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeShort((short)94);
        tDSWriter.writeShort((short)(string == null ? 0 : string.length()));
        n3 += byArray2.length;
        if (!this.integratedSecurity) {
            tDSWriter.writeShort((short)(94 + n3));
            tDSWriter.writeShort((short)(string2 == null ? 0 : string2.length()));
            tDSWriter.writeShort((short)(94 + (n3 += byArray3.length)));
            tDSWriter.writeShort((short)(string3 == null ? 0 : string3.length()));
            n3 += n;
        } else {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
        }
        tDSWriter.writeShort((short)(94 + n3));
        tDSWriter.writeShort((short)(string4 == null ? 0 : string4.length()));
        tDSWriter.writeShort((short)(94 + (n3 += byArray5.length)));
        tDSWriter.writeShort((short)(string7 == null ? 0 : string7.length()));
        n3 += byArray6.length;
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        assert (null != string5);
        tDSWriter.writeShort((short)(94 + n3));
        tDSWriter.writeShort((short)string5.length());
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)(94 + (n3 += byArray7.length)));
        tDSWriter.writeShort((short)(string6 == null ? 0 : string6.length()));
        n3 += byArray8.length;
        tDSWriter.writeBytes(byArray9);
        if (!this.integratedSecurity) {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
        } else {
            tDSWriter.writeShort((short)(94 + n3));
            if (65535 <= byArray.length) {
                tDSWriter.writeShort((short)-1);
            } else {
                tDSWriter.writeShort((short)byArray.length);
            }
        }
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        if (this.tdsVersion >= 1913192450) {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            if (65535 <= byArray.length) {
                tDSWriter.writeInt(byArray.length);
            } else {
                tDSWriter.writeInt(0);
            }
        }
        tDSWriter.writeBytes(byArray2);
        tDSWriter.setDataLoggable(false);
        if (!this.integratedSecurity) {
            tDSWriter.writeBytes(byArray3);
            tDSWriter.writeBytes(byArray4);
        }
        tDSWriter.setDataLoggable(true);
        tDSWriter.writeBytes(byArray5);
        tDSWriter.writeBytes(byArray6);
        tDSWriter.writeBytes(byArray7);
        tDSWriter.writeBytes(byArray8);
        tDSWriter.setDataLoggable(false);
        if (this.integratedSecurity) {
            tDSWriter.writeBytes(byArray, 0, byArray.length);
        }
        tDSWriter.setDataLoggable(true);
        final class LogonProcessor
        extends TDSTokenHandler {
            private final SSPIAuthentication auth;
            private byte[] secBlobOut;
            StreamLoginAck loginAckToken;

            LogonProcessor(SSPIAuthentication sSPIAuthentication) {
                super("logon");
                this.secBlobOut = null;
                this.auth = sSPIAuthentication;
                this.loginAckToken = null;
            }

            @Override
            boolean onSSPI(TDSReader tDSReader) throws SQLServerException {
                StreamSSPI streamSSPI = new StreamSSPI();
                streamSSPI.setFromTDS(tDSReader);
                boolean[] blArray = new boolean[]{false};
                this.secBlobOut = this.auth.GenerateClientContext(streamSSPI.sspiBlob, blArray);
                return true;
            }

            @Override
            boolean onLoginAck(TDSReader tDSReader) throws SQLServerException {
                this.loginAckToken = new StreamLoginAck();
                this.loginAckToken.setFromTDS(tDSReader);
                SQLServerConnection.this.sqlServerVersion = this.loginAckToken.sSQLServerVersion;
                SQLServerConnection.this.tdsVersion = this.loginAckToken.tdsVersion;
                return true;
            }

            final boolean complete(LogonCommand logonCommand, TDSReader tDSReader) throws SQLServerException {
                if (null != this.loginAckToken) {
                    return true;
                }
                if (null != this.secBlobOut && 0 != this.secBlobOut.length) {
                    logonCommand.startRequest((byte)17).writeBytes(this.secBlobOut, 0, this.secBlobOut.length);
                    return false;
                }
                logonCommand.startRequest((byte)17);
                logonCommand.onRequestComplete();
                ++((SQLServerConnection)SQLServerConnection.this).tdsChannel.numMsgsSent;
                TDSParser.parse(tDSReader, this);
                return true;
            }
        }
        LogonProcessor logonProcessor = new LogonProcessor(sSPIAuthentication);
        do {
            tDSReader = logonCommand.startResponse();
            TDSParser.parse(tDSReader, logonProcessor);
        } while (!logonProcessor.complete(logonCommand, tDSReader));
    }

    private void checkValidHoldability(int n) throws SQLServerException {
        if (n != 1 && n != 2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidHoldability"));
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(new Object[]{n}), null, true);
        }
    }

    private void checkMatchesCurrentHoldability(int n) throws SQLServerException {
        if (n != this.holdability) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_sqlServerHoldability"), null, false);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "createStatement", new Object[]{new Integer(n), new Integer(n2), n3});
        this.checkClosed();
        this.checkValidHoldability(n3);
        this.checkMatchesCurrentHoldability(n3);
        Statement statement = this.createStatement(n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "createStatement", statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{new Integer(n), new Integer(n2), n3});
        this.checkClosed();
        this.checkValidHoldability(n3);
        this.checkMatchesCurrentHoldability(n3);
        PreparedStatement preparedStatement = this.prepareStatement(string, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", preparedStatement);
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{new Integer(n), new Integer(n2), n3});
        this.checkClosed();
        this.checkValidHoldability(n3);
        this.checkMatchesCurrentHoldability(n3);
        CallableStatement callableStatement = this.prepareCall(string, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareCall", callableStatement);
        return callableStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{string, new Integer(n)});
        this.checkClosed();
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = n == 1;
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", sQLServerPreparedStatement);
        return sQLServerPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{string, nArray});
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", sQLServerPreparedStatement);
        return sQLServerPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{string, stringArray});
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", sQLServerPreparedStatement);
        return sQLServerPreparedStatement;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "releaseSavepoint", savepoint);
        this.NotImplemented();
    }

    private final Savepoint setNamedSavepoint(String string) throws SQLServerException {
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantSetSavepoint"), null, false);
        }
        SQLServerSavepoint sQLServerSavepoint = new SQLServerSavepoint(this, string);
        this.connectionCommand("IF @@TRANCOUNT = 0 BEGIN BEGIN TRAN IF @@TRANCOUNT = 2 COMMIT TRAN END SAVE TRAN " + Util.escapeSQLId(sQLServerSavepoint.getLabel()), "setSavepoint");
        return sQLServerSavepoint;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setSavepoint", string);
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        Savepoint savepoint = this.setNamedSavepoint(string);
        loggerExternal.exiting(this.getClassNameLogging(), "setSavepoint", savepoint);
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setSavepoint");
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        Savepoint savepoint = this.setNamedSavepoint(null);
        loggerExternal.exiting(this.getClassNameLogging(), "setSavepoint", savepoint);
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "rollback", savepoint);
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, false);
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN " + Util.escapeSQLId(((SQLServerSavepoint)savepoint).getLabel()), "rollbackSavepoint");
        loggerExternal.exiting(this.getClassNameLogging(), "rollback");
    }

    @Override
    public int getHoldability() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getHoldability");
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getHoldability", this.holdability);
        }
        return this.holdability;
    }

    @Override
    public void setHoldability(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setHoldability", n);
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkValidHoldability(n);
        this.checkClosed();
        if (this.holdability != n) {
            assert (1 == n || 2 == n) : "invalid holdability " + n;
            this.connectionCommand(n == 2 ? "SET CURSOR_CLOSE_ON_COMMIT ON" : "SET CURSOR_CLOSE_ON_COMMIT OFF", "setHoldability");
            this.holdability = n;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setHoldability");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC41();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC41();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getSchema");
        DriverJDBCVersion.checkSupportsJDBC41();
        this.checkClosed();
        SQLServerStatement sQLServerStatement = null;
        SQLServerResultSet sQLServerResultSet = null;
        try {
            sQLServerStatement = (SQLServerStatement)this.createStatement();
            sQLServerResultSet = sQLServerStatement.executeQueryInternal("SELECT SCHEMA_NAME()");
            if (sQLServerResultSet != null) {
                sQLServerResultSet.next();
                String string = sQLServerResultSet.getString(1);
                return string;
            }
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_getSchemaError"), null, true);
        }
        catch (SQLException sQLException) {
            if (this.isSessionUnAvailable()) {
                throw sQLException;
            }
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_getSchemaError"), null, true);
        }
        finally {
            if (sQLServerResultSet != null) {
                sQLServerResultSet.close();
            }
            if (sQLServerStatement != null) {
                sQLServerStatement.close();
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getSchema");
        return null;
    }

    @Override
    public void setSchema(String string) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "setSchema", string);
        DriverJDBCVersion.checkSupportsJDBC41();
        this.checkClosed();
        this.addWarning(SQLServerException.getErrString("R_setSchemaWarning"));
        loggerExternal.exiting(this.getClassNameLogging(), "setSchema");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public Blob createBlob() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return new SQLServerBlob(this);
    }

    @Override
    public Clob createClob() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return new SQLServerClob(this);
    }

    @Override
    public NClob createNClob() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return new SQLServerNClob(this);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "createSQLXML");
        DriverJDBCVersion.checkSupportsJDBC4();
        SQLServerSQLXML sQLServerSQLXML = null;
        sQLServerSQLXML = new SQLServerSQLXML(this);
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "createSQLXML", sQLServerSQLXML);
        }
        return sQLServerSQLXML;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getClientInfo");
        this.checkClosed();
        Properties properties = new Properties();
        loggerExternal.exiting(this.getClassNameLogging(), "getClientInfo", properties);
        return properties;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getClientInfo", string);
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getClientInfo", null);
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "setClientInfo", properties);
        try {
            this.checkClosed();
        }
        catch (SQLServerException sQLServerException) {
            SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
            sQLClientInfoException.initCause(sQLServerException);
            throw sQLClientInfoException;
        }
        if (!properties.isEmpty()) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidProperty"));
                Object[] objectArray = new Object[]{enumeration.nextElement()};
                this.addWarning(messageFormat.format(objectArray));
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setClientInfo");
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "setClientInfo", new Object[]{string, string2});
        try {
            this.checkClosed();
        }
        catch (SQLServerException sQLServerException) {
            SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
            sQLClientInfoException.initCause(sQLServerException);
            throw sQLClientInfoException;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidProperty"));
        Object[] objectArray = new Object[]{string};
        this.addWarning(messageFormat.format(objectArray));
        loggerExternal.exiting(this.getClassNameLogging(), "setClientInfo");
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        Object object;
        boolean bl = false;
        loggerExternal.entering(this.getClassNameLogging(), "isValid", n);
        DriverJDBCVersion.checkSupportsJDBC4();
        if (n < 0) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidQueryTimeOutValue"));
            Object[] objectArray = new Object[]{n};
            SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, true);
        }
        if (this.isSessionUnAvailable()) {
            return false;
        }
        try {
            object = new SQLServerStatement(this, 1003, 1007);
            if (0 != n) {
                ((SQLServerStatement)object).setQueryTimeout(n);
            }
            ((SQLServerStatement)object).executeQueryInternal("SELECT 1");
            ((SQLServerStatement)object).close();
            bl = true;
        }
        catch (SQLException sQLException) {
            connectionlogger.fine(this.toString() + " Exception checking connection validity: " + sQLException.getMessage());
        }
        loggerExternal.exiting(this.getClassNameLogging(), "isValid", bl);
        return bl;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isWrapperFor", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        boolean bl = clazz.isInstance(this);
        loggerExternal.exiting(this.getClassNameLogging(), "isWrapperFor", bl);
        return bl;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t;
        loggerExternal.entering(this.getClassNameLogging(), "unwrap", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            SQLServerException sQLServerException = new SQLServerException(classCastException.getMessage(), classCastException);
            throw sQLServerException;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "unwrap", t);
        return t;
    }

    String replaceParameterMarkers(String string, Parameter[] parameterArray, boolean bl) throws SQLServerException {
        char[] cArray = new char[string.length() + parameterArray.length * (6 + OUT.length)];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = ParameterUtils.scanSQLForChar('?', string, n2);
            string.getChars(n2, n5, cArray, n);
            n += n5 - n2;
            if (string.length() == n5) break;
            n += SQLServerConnection.makeParamName(n3++, cArray, n);
            n2 = n5 + 1;
            if (!parameterArray[n4++].isOutput() || bl && n4 <= 1) continue;
            System.arraycopy(OUT, 0, cArray, n, OUT.length);
            n += OUT.length;
        }
        while (n < cArray.length) {
            cArray[n++] = 32;
        }
        return new String(cArray);
    }

    static int makeParamName(int n, char[] cArray, int n2) {
        cArray[n2 + 0] = 64;
        cArray[n2 + 1] = 80;
        if (n < 10) {
            cArray[n2 + 2] = (char)(48 + n);
            return 3;
        }
        if (n < 100) {
            int n3 = 2;
            while (true) {
                if (n < n3 * 10) {
                    cArray[n2 + 2] = (char)(48 + (n3 - 1));
                    cArray[n2 + 3] = (char)(48 + (n - (n3 - 1) * 10));
                    return 4;
                }
                ++n3;
            }
        }
        String string = "" + n;
        string.getChars(0, string.length(), cArray, n2 + 2);
        return 2 + string.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPooledConnection(SQLServerException sQLServerException) {
        SQLServerConnection sQLServerConnection = this;
        synchronized (sQLServerConnection) {
            if (null != this.pooledConnectionParent) {
                this.pooledConnectionParent.notifyEvent(sQLServerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void DetachFromPool() {
        SQLServerConnection sQLServerConnection = this;
        synchronized (sQLServerConnection) {
            this.pooledConnectionParent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInstancePort(String string, String string2) throws SQLServerException {
        Object object;
        String string3 = null;
        DatagramSocket datagramSocket = null;
        String string4 = null;
        try {
            Object object2;
            block25: {
                string4 = "Failed to determine instance for the : " + string + " instance:" + string2;
                if (null == datagramSocket) {
                    try {
                        datagramSocket = new DatagramSocket();
                        datagramSocket.setSoTimeout(1000);
                    }
                    catch (SocketException socketException) {
                        string4 = "Unable to create local datagram socket";
                        throw socketException;
                    }
                }
                assert (null != datagramSocket);
                try {
                    if (this.multiSubnetFailover) {
                        object2 = InetAddress.getAllByName(string);
                        assert (null != object2);
                        for (InetAddress inetAddress : object2) {
                            try {
                                byte[] byArray = (" " + string2).getBytes();
                                byArray[0] = 4;
                                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 1434);
                                datagramSocket.send(datagramPacket);
                            }
                            catch (IOException iOException) {
                                string4 = "Error sending SQL Server Browser Service UDP request to address: " + inetAddress + ", port: " + 1434;
                                throw iOException;
                            }
                        }
                        break block25;
                    }
                    object2 = InetAddress.getByName(string);
                    assert (null != object2);
                    try {
                        object = (" " + string2).getBytes();
                        object[0] = (InetAddress)4;
                        DatagramPacket datagramPacket = new DatagramPacket((byte[])object, ((Object)object).length, (InetAddress)object2, 1434);
                        datagramSocket.send(datagramPacket);
                    }
                    catch (IOException iOException) {
                        string4 = "Error sending SQL Server Browser Service UDP request to address: " + object2 + ", port: " + 1434;
                        throw iOException;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    string4 = "Unable to determine IP address of host: " + string;
                    throw unknownHostException;
                }
            }
            try {
                object2 = new byte[4096];
                object = new DatagramPacket((byte[])object2, ((InetAddress[])object2).length);
                datagramSocket.receive((DatagramPacket)object);
                string3 = new String((byte[])object2, 3, ((InetAddress[])object2).length - 3);
                if (connectionlogger.isLoggable(Level.FINER)) {
                    connectionlogger.fine(this.toString() + "Received SSRP UDP response from IP address: " + ((DatagramPacket)object).getAddress().getHostAddress().toString());
                }
            }
            catch (IOException iOException) {
                string4 = "Error receiving SQL Server Browser Service UDP response from server: " + string;
                throw iOException;
            }
        }
        catch (IOException iOException) {
            object = new MessageFormat(SQLServerException.getErrString("R_sqlBrowserFailed"));
            Object[] objectArray = new Object[]{string, string2, iOException.toString()};
            connectionlogger.log(Level.FINE, this.toString() + " " + string4, iOException);
            SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), "08001", false);
        }
        finally {
            if (null != datagramSocket) {
                datagramSocket.close();
            }
        }
        assert (null != string3);
        int n = string3.indexOf("tcp;");
        if (-1 == n) {
            object = new MessageFormat(SQLServerException.getErrString("R_notConfiguredToListentcpip"));
            Object[] objectArray = new Object[]{string2};
            SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), "08001", false);
        }
        int n2 = n + 4;
        int n3 = string3.indexOf(59, n2);
        return string3.substring(n2, n3);
    }

    int getNextSavepointId() {
        ++this.nNextSavePointId;
        return this.nNextSavePointId;
    }

    void doSecurityCheck() {
        assert (null != this.currentConnectPlaceHolder);
        this.currentConnectPlaceHolder.doSecurityCheck();
    }

    private final class LogonCommand
    extends UninterruptableTDSCommand {
        LogonCommand() {
            super("logon");
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            SQLServerConnection.this.logon(this);
            return true;
        }
    }

    private static enum State {
        Initialized,
        Connected,
        Opened,
        Closed;

    }
}

