/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class ExpressionColumn
extends Expression {
    public static final ExpressionColumn[] emptyArray = new ExpressionColumn[0];
    static final HsqlNameManager.SimpleName rownumName = HsqlNameManager.getSimpleName("ROWNUM", false);
    public static final HashMappedList diagnosticsList = new HashMappedList();
    static final String[] diagnosticsVariableTokens = new String[]{"NUMBER", "MORE", "ROW_COUNT"};
    public static final int idx_number = 0;
    public static final int idx_more = 1;
    public static final int idx_row_count = 2;
    ColumnSchema column;
    String schema;
    String tableName;
    String columnName;
    RangeVariable rangeVariable;
    NumberSequence sequence;
    boolean isWritable;
    boolean isParam;

    ExpressionColumn(String string, String string2, String string3) {
        super(2);
        this.schema = string;
        this.tableName = string2;
        this.columnName = string3;
    }

    ExpressionColumn(ColumnSchema columnSchema) {
        super(2);
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
        this.columnName = columnSchema.getName().name;
    }

    ExpressionColumn(RangeVariable rangeVariable, int n) {
        super(2);
        this.columnIndex = n;
        this.setAutoAttributesAsColumn(rangeVariable, this.columnIndex);
    }

    ExpressionColumn(Expression expression, int n, int n2) {
        super(5);
        this.dataType = expression.dataType;
        this.columnIndex = n;
        this.alias = expression.alias;
        this.rangePosition = n2;
    }

    ExpressionColumn() {
        super(11);
    }

    ExpressionColumn(int n) {
        super(n);
        if (n == 8) {
            this.isParam = true;
        } else if (n == 14) {
            this.columnName = ExpressionColumn.rownumName.name;
            this.dataType = Type.SQL_INTEGER;
        }
    }

    ExpressionColumn(int n, int n2) {
        super(n);
        this.column = (ColumnSchema)diagnosticsList.get(n2);
        this.columnIndex = n2;
        this.dataType = this.column.dataType;
    }

    ExpressionColumn(Expression[] expressionArray, String string) {
        super(3);
        this.nodes = expressionArray;
        this.columnName = string;
    }

    ExpressionColumn(String string, String string2) {
        super(97);
        this.schema = string;
        this.tableName = string2;
    }

    ExpressionColumn(NumberSequence numberSequence, int n) {
        super(n);
        this.sequence = numberSequence;
        this.dataType = numberSequence.getDataType();
    }

    void setAutoAttributesAsColumn(RangeVariable rangeVariable, int n) {
        this.columnIndex = n;
        this.column = rangeVariable.getColumn(n);
        this.dataType = this.column.getDataType();
        this.columnName = rangeVariable.getColumnAlias((int)n).name;
        this.tableName = rangeVariable.getTableAlias().name;
        this.rangeVariable = rangeVariable;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    void setAttributesAsColumn(RangeVariable rangeVariable, int n) {
        this.columnIndex = n;
        this.column = rangeVariable.getColumn(n);
        this.dataType = this.column.getDataType();
        this.rangeVariable = rangeVariable;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    @Override
    public byte getNullability() {
        switch (this.opType) {
            case 2: {
                if (this.nullability == 2) {
                    return this.column.getNullability();
                }
                return this.nullability;
            }
            case 3: 
            case 12: 
            case 14: {
                return 0;
            }
        }
        return 2;
    }

    @Override
    void setAttributesAsColumn(ColumnSchema columnSchema, boolean bl) {
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
        this.isWritable = bl;
    }

    @Override
    HsqlNameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.rangeVariable != null && this.rangeVariable.hasColumnAlias()) {
            return this.rangeVariable.getColumnAlias(this.columnIndex);
        }
        if (this.column != null) {
            return this.column.getName();
        }
        if (this.opType == 3) {
            return this.nodes[0].getSimpleName();
        }
        if (this.opType == 14) {
            return rownumName;
        }
        return null;
    }

    @Override
    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        switch (this.opType) {
            case 2: 
            case 3: 
            case 14: {
                return this.columnName;
            }
        }
        return "";
    }

    @Override
    void collectObjectNames(Set set) {
        switch (this.opType) {
            case 12: {
                HsqlNameManager.HsqlName hsqlName = this.sequence.getName();
                set.add(hsqlName);
                return;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 97: {
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                set.add(this.column.getName());
                if (this.column.getName().parent != null) {
                    set.add(this.column.getName().parent);
                }
                return;
            }
        }
    }

    @Override
    String getColumnName() {
        switch (this.opType) {
            case 2: 
            case 6: 
            case 7: {
                if (this.column != null) {
                    return this.column.getName().name;
                }
                if (this.columnName == null) break;
                return this.columnName;
            }
        }
        return this.getAlias();
    }

    @Override
    public ColumnSchema getColumn() {
        return this.column;
    }

    String getSchemaName() {
        return this.schema;
    }

    @Override
    RangeVariable getRangeVariable() {
        return this.rangeVariable;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        switch (this.opType) {
            case 12: {
                if (bl) break;
                throw Error.error(5598);
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 97: {
                break;
            }
            case 3: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    this.nodes[i].resolveColumnReferences(session, rangeGroup, rangeGroupArray, hsqlList);
                }
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                boolean bl2 = false;
                boolean bl3 = this.tableName != null;
                RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
                if (this.rangeVariable != null) {
                    return hsqlList;
                }
                for (int i = 0; i < n; ++i) {
                    RangeVariable rangeVariable = rangeVariableArray[i];
                    if (rangeVariable == null) continue;
                    if (bl2) {
                        if (!session.database.sqlEnforceRefs || !this.resolvesDuplicateColumnReference(rangeVariable)) continue;
                        String string = this.getColumnName();
                        if (this.alias != null) {
                            StringBuffer stringBuffer = new StringBuffer(string);
                            stringBuffer.append(' ').append("AS").append(' ').append(this.alias.getStatementName());
                            string = stringBuffer.toString();
                        }
                        throw Error.error(5580, string);
                    }
                    if (!this.resolveColumnReference(rangeVariable, false)) continue;
                    bl2 = true;
                    if (!session.database.sqlEnforceRefs) break;
                }
                if (bl2) {
                    return hsqlList;
                }
                if ((session.database.sqlSyntaxOra || session.database.sqlSyntaxDb2) && bl && this.tableName != null) {
                    NumberSequence numberSequence;
                    if ("CURRVAL".equals(this.columnName) || "PREVVAL".equals(this.columnName)) {
                        NumberSequence numberSequence2 = session.database.schemaManager.getSequence(this.tableName, session.getSchemaName(this.schema), false);
                        if (numberSequence2 != null) {
                            this.opType = 13;
                            this.dataType = numberSequence2.getDataType();
                            this.sequence = numberSequence2;
                            this.schema = null;
                            this.tableName = null;
                            this.columnName = null;
                            bl2 = true;
                        }
                    } else if ("NEXTVAL".equals(this.columnName) && (numberSequence = session.database.schemaManager.getSequence(this.tableName, session.getSchemaName(this.schema), false)) != null) {
                        this.opType = 12;
                        this.dataType = numberSequence.getDataType();
                        this.sequence = numberSequence;
                        this.schema = null;
                        this.tableName = null;
                        this.columnName = null;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    return hsqlList;
                }
                if (this.resolveCorrelated(rangeGroup, rangeGroupArray)) {
                    return hsqlList;
                }
                if (hsqlList == null) {
                    hsqlList = new ArrayListIdentity();
                }
                hsqlList.add(this);
            }
        }
        return hsqlList;
    }

    private boolean resolveCorrelated(RangeGroup rangeGroup, RangeGroup[] rangeGroupArray) {
        for (int i = rangeGroupArray.length - 1; i >= 0; --i) {
            RangeVariable[] rangeVariableArray = rangeGroupArray[i].getRangeVariables();
            for (int j = 0; j < rangeVariableArray.length; ++j) {
                RangeVariable rangeVariable = rangeVariableArray[j];
                if (rangeVariable == null || !this.resolveColumnReference(rangeVariable, true)) continue;
                if (this.opType == 2) {
                    rangeGroup.setCorrelated();
                    for (int k = rangeGroupArray.length - 1; k > i; --k) {
                        rangeGroupArray[k].setCorrelated();
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean resolveColumnReference(RangeVariable rangeVariable, boolean bl) {
        ExpressionColumn expressionColumn;
        if (this.tableName == null && (expressionColumn = rangeVariable.getColumnExpression(this.columnName)) != null) {
            this.opType = expressionColumn.opType;
            this.nodes = expressionColumn.nodes;
            this.dataType = expressionColumn.dataType;
            return true;
        }
        int n = rangeVariable.findColumn(this.schema, this.tableName, this.columnName);
        if (n == -1) {
            return false;
        }
        switch (rangeVariable.rangeType) {
            case 3: 
            case 4: {
                if (this.tableName != null) {
                    return false;
                }
                ColumnSchema columnSchema = rangeVariable.getColumn(n);
                if (columnSchema.getParameterMode() == 4) {
                    return false;
                }
                this.opType = rangeVariable.rangeType == 4 ? 6 : 7;
                break;
            }
            case 2: {
                if (this.tableName == null) {
                    return false;
                }
                if (this.schema != null) {
                    return false;
                }
                this.opType = 9;
                break;
            }
        }
        this.setAttributesAsColumn(rangeVariable, n);
        return true;
    }

    boolean resolvesDuplicateColumnReference(RangeVariable rangeVariable) {
        ExpressionColumn expressionColumn;
        if (this.tableName == null && (expressionColumn = rangeVariable.getColumnExpression(this.columnName)) != null) {
            return false;
        }
        switch (rangeVariable.rangeType) {
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = rangeVariable.findColumn(this.schema, this.tableName, this.columnName);
        return n != -1;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        switch (this.opType) {
            case 4: {
                if (expression == null || expression.opType == 25) break;
                throw Error.error(5544);
            }
            case 3: {
                Type type = null;
                this.nullability = 0;
                for (int i = 0; i < this.nodes.length; ++i) {
                    type = Type.getAggregateType(this.nodes[i].dataType, type);
                }
                this.dataType = type;
                break;
            }
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 4: {
                return null;
            }
            case 10: {
                return this.getDiagnosticsVariable(session);
            }
            case 6: {
                return session.sessionContext.routineVariables[this.columnIndex];
            }
            case 7: {
                return session.sessionContext.routineArguments[this.columnIndex];
            }
            case 9: {
                return session.sessionContext.triggerArguments[this.rangeVariable.rangePosition][this.columnIndex];
            }
            case 2: {
                RangeIterator[] rangeIteratorArray = session.sessionContext.rangeIterators;
                Object object = rangeIteratorArray[this.rangeVariable.rangePosition].getCurrent(this.columnIndex);
                if (this.dataType != this.column.dataType) {
                    object = this.dataType.convertToType(session, object, this.column.dataType);
                }
                return object;
            }
            case 5: {
                Object object = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                return object;
            }
            case 3: {
                Object object = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    object = this.nodes[i].getValue(session, this.dataType);
                    if (object == null) continue;
                    return object;
                }
                return object;
            }
            case 8: {
                return session.sessionContext.dynamicArguments[this.parameterIndex];
            }
            case 12: {
                return session.sessionData.getSequenceValue(this.sequence);
            }
            case 13: {
                return session.sessionData.getSequenceCurrent(this.sequence);
            }
            case 14: {
                return ValuePool.getInt(session.sessionContext.rownum);
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    private Object getDiagnosticsVariable(Session session) {
        return session.sessionContext.diagnosticsVariables[this.columnIndex];
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 4: {
                return "DEFAULT";
            }
            case 8: {
                return "?";
            }
            case 11: {
                return "*";
            }
            case 3: {
                if (this.alias != null) {
                    return this.alias.getStatementName();
                }
                return "COALESCE";
            }
            case 6: 
            case 7: 
            case 10: {
                return this.column.getName().statementName;
            }
            case 14: {
                StringBuffer stringBuffer = new StringBuffer("ROWNUM");
                stringBuffer.append('(').append(')');
                return stringBuffer.toString();
            }
            case 2: {
                if (this.column == null) {
                    if (this.alias != null) {
                        return this.alias.getStatementName();
                    }
                    if (this.tableName == null) {
                        return this.columnName;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.tableName);
                    stringBuffer.append('.');
                    stringBuffer.append(this.columnName);
                    return stringBuffer.toString();
                }
                if (this.rangeVariable.tableAlias == null) {
                    return this.column.getName().getSchemaQualifiedStatementName();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.rangeVariable.tableAlias.getStatementName());
                stringBuffer.append('.');
                stringBuffer.append(this.column.getName().statementName);
                return stringBuffer.toString();
            }
            case 97: {
                if (this.nodes.length == 0) {
                    return "*";
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.nodes.length; ++i) {
                    Expression expression = this.nodes[i];
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    String string = expression.getSQL();
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 4: {
                stringBuffer.append("DEFAULT");
                break;
            }
            case 11: {
                stringBuffer.append("OpTypes.ASTERISK ");
                break;
            }
            case 6: {
                stringBuffer.append("VARIABLE: ");
                stringBuffer.append(this.column.getName().name);
                break;
            }
            case 7: {
                stringBuffer.append("PARAMETER").append(": ");
                stringBuffer.append(this.column.getName().name);
                break;
            }
            case 3: {
                stringBuffer.append("COLUMN").append(": ");
                stringBuffer.append(this.columnName);
                if (this.alias == null) break;
                stringBuffer.append(" AS ").append(this.alias.name);
                break;
            }
            case 2: {
                stringBuffer.append("COLUMN").append(": ");
                stringBuffer.append(this.column.getName().getSchemaQualifiedStatementName());
                if (this.alias == null) break;
                stringBuffer.append(" AS ").append(this.alias.name);
                break;
            }
            case 8: {
                stringBuffer.append("DYNAMIC PARAM: ");
                stringBuffer.append(", TYPE = ").append(this.dataType.getNameString());
                break;
            }
            case 12: {
                stringBuffer.append("SEQUENCE").append(": ");
                stringBuffer.append(this.sequence.getName().name);
                break;
            }
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    String getTableName() {
        if (this.opType == 97) {
            return this.tableName;
        }
        if (this.opType == 2) {
            if (this.rangeVariable == null) {
                return this.tableName;
            }
            return this.rangeVariable.getTable().getName().name;
        }
        return "";
    }

    static void checkColumnsResolved(HsqlList hsqlList) {
        if (hsqlList != null && !hsqlList.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            Expression expression = (Expression)hsqlList.get(0);
            if (expression instanceof ExpressionColumn) {
                ExpressionColumn expressionColumn = (ExpressionColumn)expression;
                if (expressionColumn.schema != null) {
                    stringBuffer.append(expressionColumn.schema + '.');
                }
                if (expressionColumn.tableName != null) {
                    stringBuffer.append(expressionColumn.tableName + '.');
                }
                stringBuffer.append(expressionColumn.getColumnName());
                throw Error.error(5501, stringBuffer.toString());
            }
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            expression.collectAllExpressions(orderedHashSet, Expression.columnExpressionSet, Expression.emptyExpressionSet);
            ExpressionColumn.checkColumnsResolved(orderedHashSet);
            throw Error.error(5501);
        }
    }

    @Override
    public OrderedHashSet getUnkeyedColumns(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].getUnkeyedColumns(orderedHashSet);
        }
        if (this.opType == 2 && !this.rangeVariable.hasKeyedColumnInGroupBy) {
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet();
            }
            orderedHashSet.add(this);
        }
        return orderedHashSet;
    }

    @Override
    OrderedHashSet collectRangeVariables(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].collectRangeVariables(orderedHashSet);
        }
        if (this.rangeVariable != null) {
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet();
            }
            orderedHashSet.add(this.rangeVariable);
        }
        return orderedHashSet;
    }

    @Override
    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet orderedHashSet) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            orderedHashSet = this.nodes[n].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        if (this.rangeVariable != null) {
            for (n = 0; n < rangeVariableArray.length; ++n) {
                if (rangeVariableArray[n] != this.rangeVariable) continue;
                if (orderedHashSet == null) {
                    orderedHashSet = new OrderedHashSet();
                }
                orderedHashSet.add(this.rangeVariable);
                break;
            }
        }
        return orderedHashSet;
    }

    @Override
    Expression replaceAliasInOrderBy(Session session, Expression[] expressionArray, int n) {
        int n2;
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            if (this.nodes[n2] == null) continue;
            this.nodes[n2] = this.nodes[n2].replaceAliasInOrderBy(session, expressionArray, n);
        }
        switch (this.opType) {
            case 2: 
            case 3: {
                Object object;
                int n3;
                n2 = -1;
                for (n3 = 0; n3 < n; ++n3) {
                    String string;
                    object = expressionArray[n3].alias;
                    String string2 = string = object == null ? null : ((HsqlNameManager.SimpleName)object).name;
                    if (this.schema != null || this.tableName != null || !this.columnName.equals(string)) continue;
                    if (n2 < 0) {
                        n2 = n3;
                        continue;
                    }
                    if (!session.database.sqlEnforceRefs) continue;
                    String string3 = this.getColumnName();
                    throw Error.error(5580, string3);
                }
                if (n2 >= 0) {
                    return expressionArray[n2];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    if (!(expressionArray[n3] instanceof ExpressionColumn)) continue;
                    if (this.equals(expressionArray[n3])) {
                        if (n2 < 0) {
                            n2 = n3;
                        } else if (session.database.sqlEnforceRefs) {
                            object = this.getColumnName();
                            throw Error.error(5580, (String)object);
                        }
                    }
                    if (this.tableName != null || this.schema != null || !this.columnName.equals(((ExpressionColumn)expressionArray[n3]).columnName)) continue;
                    if (n2 < 0) {
                        n2 = n3;
                        continue;
                    }
                    if (!session.database.sqlEnforceRefs) continue;
                    object = this.getColumnName();
                    throw Error.error(5580, (String)object);
                }
                if (n2 < 0) break;
                return expressionArray[n2];
            }
        }
        return this;
    }

    @Override
    Expression replaceColumnReferences(RangeVariable rangeVariable, Expression[] expressionArray) {
        if (this.opType == 2 && this.rangeVariable == rangeVariable) {
            return expressionArray[this.columnIndex];
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(rangeVariable, expressionArray);
        }
        return this;
    }

    @Override
    boolean hasReference(RangeVariable rangeVariable) {
        if (rangeVariable == this.rangeVariable) {
            return true;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(rangeVariable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (this.opType != expression.opType) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == expression.columnIndex;
            }
            case 3: {
                return this.nodes == expression.nodes;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return this.column == expression.getColumn() && this.rangeVariable == expression.getRangeVariable();
            }
        }
        return false;
    }

    @Override
    void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            this.nodes[n].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        for (n = 0; n < rangeVariableArray.length; ++n) {
            if (this.rangeVariable != rangeVariableArray[n]) continue;
            this.rangeVariable = rangeVariableArray2[n];
            break;
        }
    }

    @Override
    void resetColumnReferences() {
        this.rangeVariable = null;
        this.columnIndex = -1;
    }

    @Override
    public boolean isIndexable(RangeVariable rangeVariable) {
        if (this.opType == 2) {
            return this.rangeVariable == rangeVariable;
        }
        return false;
    }

    @Override
    public boolean isUnresolvedParam() {
        return this.isParam && this.dataType == null;
    }

    @Override
    boolean isDynamicParam() {
        return this.isParam;
    }

    @Override
    void getJoinRangeVariables(RangeVariable[] rangeVariableArray, HsqlList hsqlList) {
        if (this.opType == 2) {
            for (int i = 0; i < rangeVariableArray.length; ++i) {
                if (rangeVariableArray[i] != this.rangeVariable) continue;
                hsqlList.add(this.rangeVariable);
                return;
            }
        }
    }

    @Override
    double costFactor(Session session, RangeVariable rangeVariable, int n) {
        double d;
        if (rangeVariable.rangeTable instanceof TableDerived) {
            return 1024.0;
        }
        PersistentStore persistentStore = rangeVariable.rangeTable.getRowStore(session);
        int n2 = rangeVariable.rangeTable.indexTypeForColumn(session, this.columnIndex);
        switch (n2) {
            case 2: {
                if (n == 40) {
                    d = 1.0;
                    break;
                }
                d = (double)persistentStore.elementCount() / 2.0;
                break;
            }
            case 1: {
                if (n == 40) {
                    d = (double)persistentStore.elementCount() / 8.0;
                    if (!(d > 1024.0)) break;
                    d = 1024.0;
                    break;
                }
                d = (double)persistentStore.elementCount() / 2.0;
                break;
            }
            default: {
                d = persistentStore.elementCount();
            }
        }
        return d < 16.0 ? 16.0 : d;
    }

    @Override
    public Expression duplicate() {
        if (this.opType == 7) {
            return this;
        }
        return super.duplicate();
    }

    static {
        for (int i = 0; i < diagnosticsVariableTokens.length; ++i) {
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newSystemObjectName(diagnosticsVariableTokens[i], 22);
            Type type = Type.SQL_INTEGER;
            if (diagnosticsVariableTokens[i] == "MORE") {
                type = Type.SQL_CHAR;
            }
            ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, false, false, null);
            diagnosticsList.add(diagnosticsVariableTokens[i], columnSchema);
        }
    }
}

