/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.db.Selection_CODE;
import org.opengion.hayabusa.db.Selection_DB;
import org.opengion.hayabusa.db.Selection_DBRADIO;
import org.opengion.hayabusa.db.Selection_HM;
import org.opengion.hayabusa.db.Selection_KEYVAL;
import org.opengion.hayabusa.db.Selection_NULL;
import org.opengion.hayabusa.db.Selection_NUM;
import org.opengion.hayabusa.db.Selection_RADIO;
import org.opengion.hayabusa.db.Selection_YMD;
import org.opengion.hayabusa.resource.CodeData;

public final class SelectionFactory {
    private static final Map<String, Selection> dbMap = new WeakHashMap<String, Selection>(50);
    private static final Map<String, Selection> dbRadioMap = new WeakHashMap<String, Selection>(50);

    private SelectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selection newDBSelection(String string, String string2, String string3) {
        String string4 = string + string2 + string3;
        Selection selection = dbMap.get(string4);
        if (selection == null || selection.isTimeOver()) {
            Map<String, Selection> map = dbMap;
            synchronized (map) {
                selection = new Selection_DB(string, string2, string3);
                dbMap.put(string4, selection);
            }
        }
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selection newDBRadioSelection(String string, String string2, String string3) {
        String string4 = string + string2 + string3;
        Selection selection = dbRadioMap.get(string4);
        if (selection == null || selection.isTimeOver()) {
            Map<String, Selection> map = dbRadioMap;
            synchronized (map) {
                selection = new Selection_DBRADIO(string, string2, string3);
                dbRadioMap.put(string4, selection);
            }
        }
        return selection;
    }

    public static Selection newSelection(String string, String string2) {
        Selection_NULL selection_NULL = null;
        if ("KEYVAL".equalsIgnoreCase(string)) {
            selection_NULL = new Selection_KEYVAL(string2);
        } else if ("HM".equalsIgnoreCase(string)) {
            selection_NULL = new Selection_HM(string2);
        } else if ("NUM".equalsIgnoreCase(string)) {
            selection_NULL = new Selection_NUM(string2);
        } else if ("YMD".equalsIgnoreCase(string)) {
            selection_NULL = new Selection_YMD(string2);
        } else if ("NULL".equalsIgnoreCase(string)) {
            selection_NULL = new Selection_NULL(string2);
        } else {
            selection_NULL = new Selection_NULL(string2);
            String string3 = "\u6307\u5b9a\u306e\u30bf\u30a4\u30d7[" + string + "]\u304c\u3001\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30bf\u30a4\u30d7\u4e00\u89a7=[KEYVAL,HM,NUM,YMD]" + HybsSystem.CR;
            throw new HybsSystemException(string3);
        }
        return selection_NULL;
    }

    public static Selection newSelection(String string, CodeData codeData) {
        Selection_NULL selection_NULL = null;
        if (codeData != null) {
            if ("MENU".equalsIgnoreCase(string)) {
                selection_NULL = new Selection_CODE(codeData);
            } else if ("RADIO".equalsIgnoreCase(string)) {
                selection_NULL = new Selection_RADIO(codeData);
            } else {
                String string2 = "\u6307\u5b9a\u306e\u30bf\u30a4\u30d7[" + string + "]\u304c\u3001\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30bf\u30a4\u30d7\u4e00\u89a7=[MENU,RADIO]" + HybsSystem.CR;
                throw new HybsSystemException(string2);
            }
        }
        return selection_NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, Selection> map = dbMap;
        synchronized (map) {
            dbMap.clear();
        }
        map = dbRadioMap;
        synchronized (map) {
            dbRadioMap.clear();
        }
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                SelectionFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }
}

