/************************************************************************************/
/* 入力値自動変換機能 (query画面用)                                                 */
/* dbType に従って、カンマやスラッシュの削除を行います                              */
/* 完全にエンジンのチェックと一致しているわけではありません。                       */
/*                                                                                  */
/* S9,R：カンマ削除                                                                 */
/* PN  ：ハイフン削除                                                               */
/* YM,DATE系：スラッシュ削除                                                        */
/* HSM ：コロン削除                                                                 */
/*                                                                                  */
/* @og.rev 5.6.0.3 (2013/01/24) 新規追加                                            */
/* @og.rev 5.6.2.3 (2013/03/22) queryScriptPre.jsp → queryConvert.js 変更          */
/* @og.rev 5.9.5.0 (2016/02/05) PN2追加                                             */
/* Revision: $Id$                                                                   */
/************************************************************************************/
$(function(){
	setEvent( "textarea,input[type=\"text\"]", "focusout", function(){ queryConvert( this ); } );
});

function queryConvert( obj ) {
	var val , cls ;

	val = obj.value;
	cls = obj.className;
	if( val != null && cls != null ) {
		if( (cls.match( /S9/ ) || cls.match( /R/ ) || cls.match( /XU9/ )) && !cls.match( /\S+R\S*/ ) && !cls.match( /\S*R\S+/ ) ) {
//			obj.value = val.replace(',','');
			obj.value = val.replace(/,/g,'');
		}
		else if( cls.match( /PN2/ ) ) {	// 5.9.5.0 
			val = val.replace(/(^\s+)|(\s+$)/g, "");	// val = val.trim(); はIE7で動作しない 5.9.7.1
			if( (val.length == 12 || val.length == 13) &&
				val.indexOf('-') == 3 && val.lastIndexOf('-') == 9 && val.indexOf('-',4) == 9){
				val = val.replace(/-/g,'');
			}
			obj.value = val;
		}
		else if( cls.match( /PN/ ) ) {
//			obj.value = val.replace('-','');
			obj.value = val.replace(/-/g,'');
		}
		else if( cls.match( /YM/ ) || cls.match( /DATE/ ) ) {
//			obj.value = val.replace('/','');
			obj.value = val.replace(/\//g,'');
			if( cls.match( /YMDH/ ) ) {
				obj.value = val.replace(/[\/: ]/g,'');
			}
		}
		else if( cls.match( /HMS/ ) ) {
//			obj.value = val.replace(':','');
			obj.value = val.replace(/:/g,'');
		}
	}
	return true;
}