/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GET_RESOURCE ( FUNCTION )                                                */
/* Created : 2016/10/07 10:39:31                                            */
/****************************************************************************/
CREATE     
FUNCTION GET_RESOURCE(
	XPRJCODE       IN VARCHAR2 ,
	XTASK_ID       IN VARCHAR2   )
RETURN VARCHAR2
IS
    RTN     VARCHAR2(1000);
	SEP     VARCHAR2(1)  ;

	CURSOR CODEC1 IS
		SELECT A.NAME_JA
			FROM GF63 A,GF66 B
			WHERE	B.PRJCODE      = XPRJCODE
			AND		B.TASK_ID      = XTASK_ID
			AND		A.RESOURCE_ID  = B.RESOURCE_ID
			AND		A.FGJ         IN ( '0','1' )
			AND		B.FGJ         IN ( '0','1' )
			ORDER BY B.SEQ ;

	CODEREC CODEC1%ROWTYPE;

BEGIN
	RTN := '' ;
	SEP := '' ;

	OPEN	CODEC1;
	LOOP
		FETCH CODEC1 INTO CODEREC;
		EXIT WHEN CODEC1%NOTFOUND;

		RTN := RTN || SEP || CODEREC.NAME_JA ;
		SEP := ',' ;

	END LOOP;
	CLOSE CODEC1;

	RETURN RTN;

END GET_RESOURCE;
/
