/**
 *
 * 指定箇所のhttpもしくはhttpsの文字列をリンク付に変換
 *
 * @og.rev 5.6.5.0 (2013/06/03) JavaScript分離・イベントにJQuery利用     
 * KaZuhiro FuRuhata氏のソースを参考
 */

/**
 * [ファンクションの概要]
 * http://もしくはhttps://から開始する文字に対して、
 * 改行、スペース等の空文字か、全角が出現するまでをURLと見なして
 * 該当URLにリンクを張ります。
 *
 * 該当部分で、他のタグで囲われている文字や、属性についても変換するため注意して下さい。
 * (divタグに対して利用した場合、内部のaタグのアドレスに対しても処理されます）
 *
 * jQueryのプラグインとなっているので、
 * $(".hoge").urlAutoLink();として下さい。
 * urlAutoLinkのブラウザターゲットを引数に設定可能です。
 */
$.fn.urlAutoLink = function(_target){   
    return this.each(function(){
        var srcText = this.innerHTML;   
        if( srcText.indexOf('http') >= 0){
	        this.innerHTML = srcText.replace(/(https?:\/\/[\x21-\x3b\x3d\x3e-\x7e]+)/gi, "<a href='$1' target="+_target+">$1</a>");
	    }
    });   
}

