/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opengion.fukurou.util.Closer;

public class MakeImage
extends HttpServlet {
    private static final long serialVersionUID = 400020050131L;
    private static final String FORM_NAME = "png";
    private String imageFile = null;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("text");
        httpServletResponse.setContentType("image/png");
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
            BufferedImage bufferedImage = this.createImage(string);
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(FORM_NAME);
            ImageWriter imageWriter = iterator.next();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(servletOutputStream);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(bufferedImage);
            servletOutputStream.flush();
            imageOutputStream.close();
        }
        finally {
            Closer.ioClose((Closeable)servletOutputStream);
        }
    }

    private BufferedImage createImage(String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(this.imageFile));
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n = string.length() == 1 ? 8 : 2;
        graphics2D.setFont(new Font("Serif", 1, 14));
        graphics2D.setColor(new Color(0, 0, 255));
        graphics2D.drawString(string, n, 15);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.imageFile = servletConfig.getInitParameter("imageFile");
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(stringArray[0]));
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (bufferedImage.getRGB(j, i) == -1) {
                    bufferedImage2.setRGB(j, i, 0);
                    continue;
                }
                bufferedImage2.setRGB(j, i, bufferedImage.getRGB(j, i));
            }
        }
        ImageIO.write((RenderedImage)bufferedImage2, FORM_NAME, new File(stringArray[1]));
    }
}

