<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6100"
	title	= "カレンダー登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- データが選ばれていなければエラー -->
<og:columnCheck minRowCount="1" command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command = "MODIFY" がセットされて遷移してきます。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" />

<og:message lbl="MSG0046" comment="変更処理を行います。" /><br />
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンと、EXCEL(CSV)変更リンクを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
</og:writeCheck>

<og:view
	viewFormType = "HTMLCalendar"
	command      = "{@command}"
	startNo      = "{@startNo}"
	noWritable   = "FGJ,CDJGS,YYYYMM"
	pageSize     = "{@pageSize}"
/>

<!-- 登録データは、entry.jsp に送られます。-->
<!-- ここでは、各ページで登録方法（INSERT,UPDATE,DELETE）を指定して、entry.jspを共通で使用します。-->
<!-- 下記に示す方法は、SQL文の直接記述方式です。-->

<og:hidden name="SQL" >
	UPDATE GF13 SET
			DY1=[DY1],DY2=[DY2],DY3=[DY3],DY4=[DY4],DY5=[DY5],DY6=[DY6],DY7=[DY7],
			DY8=[DY8],DY9=[DY9],DY10=[DY10],DY11=[DY11],DY12=[DY12],DY13=[DY13],DY14=[DY14],
			DY15=[DY15],DY16=[DY16],DY17=[DY17],DY18=[DY18],DY19=[DY19],DY20=[DY20],DY21=[DY21],
			DY22=[DY22],DY23=[DY23],DY24=[DY24],DY25=[DY25],DY26=[DY26],DY27=[DY27],DY28=[DY28],
			DY29=[DY29],DY30=[DY30],DY31=[DY31]
	WHERE CDJGS  = [CDJGS]
	AND   YYYYMM = [YYYYMM]
	AND   FGJ    = '1'
</og:hidden>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
