/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.xml.XSLT;

public class Process_XSLT
extends AbstractProcess
implements ChainProcess {
    private static final String PARAM_KEY = "param_";
    private static final String HEADER_KEY = "header";
    private static final String FOOTER_KEY = "footer";
    private static final String FILE_KEY = "File";
    private static final String HEADER_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String HEADER_ROWSET = "<ROWSET tableName=\"TABLENAME\">";
    private static final String FOOTER_ROWSET = "</ROWSET>";
    private XSLT xslt;
    private HybsEntry[] footerEntry;
    private String xslfile;
    private String outfile;
    private boolean errAbend = true;
    private boolean errXmlIn;
    private boolean jspInclude = true;
    private String realPath;
    private boolean display;
    private boolean debug;
    private int clmNo = -1;
    private int inCount;
    private int errCount;
    private String tableName;
    private static final Map<String, String> MUST_PROPARTY = new LinkedHashMap<String, String>();
    private static final Map<String, String> USABLE_PROPARTY;

    public Process_XSLT() {
        super("org.opengion.fukurou.process.Process_XSLT", MUST_PROPARTY, USABLE_PROPARTY);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.xslfile = argument.getProparty("xslfile");
        this.outfile = argument.getProparty("outfile");
        this.tableName = argument.getProparty("addROWSET");
        this.footerEntry = argument.getEntrys(FOOTER_KEY);
        this.errAbend = argument.getProparty("errAbend", this.errAbend);
        this.errXmlIn = argument.getProparty("errXmlIn", this.errXmlIn);
        this.jspInclude = argument.getProparty("jspInclude", this.jspInclude);
        this.realPath = argument.getProparty("realPath", this.realPath);
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        if (this.outfile == null) {
            throw new OgRuntimeException("outfile \u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        File file = new File(this.outfile);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            String string = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file2 + "]";
            throw new OgRuntimeException(string);
        }
        this.xslt = new XSLT();
        boolean bl = argument.getProparty("append", false);
        boolean bl2 = argument.getProparty("useFileInfo", false);
        HybsEntry[] hybsEntryArray = argument.getEntrys(PARAM_KEY);
        HybsEntry[] hybsEntryArray2 = argument.getEntrys(HEADER_KEY);
        this.xslt.setOutFile(this.outfile, bl);
        this.xslt.setXslFile(this.xslfile);
        this.xslt.setParamEntry(hybsEntryArray);
        this.xslt.useFileInfo(bl2);
        this.xslt.errClose(this.errAbend);
        this.xslt.useErrXmlIn(this.errXmlIn);
        this.xslt.jspInclude(this.jspInclude);
        this.xslt.setRealPath(this.realPath);
        if (this.tableName != null) {
            this.xslt.setOutData(HEADER_XML);
            this.xslt.setOutData(HEADER_ROWSET.replace("TABLENAME", this.tableName));
        }
        int n = hybsEntryArray2.length;
        for (int i = 0; i < n; ++i) {
            this.xslt.setOutData(hybsEntryArray2[i].getValue());
        }
    }

    @Override
    public LineModel action(LineModel lineModel) {
        File file;
        ++this.inCount;
        if (this.display) {
            this.println(lineModel.dataLine());
        }
        if (this.clmNo < 0) {
            this.clmNo = lineModel.getColumnNo(FILE_KEY);
        }
        if (!(file = (File)lineModel.getValue(this.clmNo)).isFile()) {
            return lineModel;
        }
        String string = file.getPath();
        try {
            if (this.debug) {
                this.println(string);
            }
            this.xslt.transform(string);
        }
        catch (RuntimeException runtimeException) {
            ++this.errCount;
            if (this.errAbend) {
                throw runtimeException;
            }
            this.logging(runtimeException.getMessage());
            this.logging("xslfile  = " + this.xslfile);
            this.logging("outfile  = " + this.outfile);
            this.logging("xmlFile  = " + string);
        }
        return lineModel;
    }

    @Override
    public void end(boolean bl) {
        if (this.xslt != null) {
            if (bl) {
                int n = this.footerEntry.length;
                for (int i = 0; i < n; ++i) {
                    this.xslt.setOutData(this.footerEntry[i].getValue());
                }
                if (this.tableName != null) {
                    this.xslt.setOutData(FOOTER_ROWSET);
                }
            }
            this.xslt.close();
        }
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + '\t' + "XSL File   : " + this.xslfile + CR + '\t' + "OUT File   : " + this.outfile + CR + '\t' + "Table Name : " + this.tableName + CR + '\t' + "File Count : " + this.inCount + CR + '\t' + "Err  Count : " + this.errCount;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(1000).append("XSLT\u5909\u63db\u7d50\u679c\u3092\u6307\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u306b\u51fa\u529b\u3057\u307e\u3059\u3002").append(CR).append(CR).append("Process_XSLT \u306f\u3001AbstractProcess \u3092\u7d99\u627f\u3057\u305f\u3001ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9").append(CR).append("\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append("\u4e0a\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u6e21\u3055\u308c\u307e\u3059\u3002)\u304b\u3089\u306eLineModel \u306e").append(CR).append("\u30d5\u30a1\u30a4\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u5bfe\u3057\u3066\u3001\u6307\u5b9a\u306e XSL \u30d5\u30a1\u30a4\u30eb\u3092\u9069\u7528\u3057\u3066\u3001XSL\u5909\u63db\u3092").append(CR).append("\u884c\u3044\u307e\u3059\u3002\u51fa\u529b\u7d50\u679c\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u3001\u307e\u305f\u306f \u6a19\u6e96\u51fa\u529b\u306b\u51fa\u529b\u3067\u304d\u307e\u3059\u3002").append(CR).append(CR).append("\u4e0a\u6d41\u30d7\u30ed\u30bb\u30b9\u3067\u306f\u3001Name \u5c5e\u6027\u3068\u3057\u3066\u3001\u300eFile\u300f\u3092\u6301\u3061\u3001\u5024\u306f\u3001File\u30aa\u30d6\u30b8\u30a7\u30af\u30c8").append(CR).append("\u3067\u3042\u308b\u3001Process_FileSearch \u3092\u4f7f\u7528\u3059\u308b\u306e\u304c\u3001\u4fbf\u5229\u3067\u3059\u3002\u305d\u308c\u4ee5\u5916\u306e\u30af\u30e9\u30b9\u3092").append(CR).append("\u4f7f\u7528\u3059\u308b\u5834\u5408\u3067\u3082\u3001Name\u5c5e\u6027\u3068\u3001File \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6301\u3064 LineModel \u3092\u53d7\u3051\u6e21\u3057").append(CR).append("\u3067\u304d\u308c\u3070\u3001\u4f7f\u7528\u53ef\u80fd\u3067\u3059\u3002").append(CR).append(CR).append("-param_XXXX=\u56fa\u5b9a\u5024 \u3092\u4f7f\u7528\u3057\u3066\u3001XSLT\u306b\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u3059\u3002").append(CR).append(CR).append("\u305d\u308c\u4ee5\u5916\u3067\u306f\u3001org.opengion.fukurou.xml.XSLT \u3067\u3001\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u60c5\u5831\u306e\u8a2d\u5b9a\u304c\u53ef\u80fd\u306b").append(CR).append("\u306a\u3063\u3066\u3044\u308b\u70ba\u3001\u5185\u90e8\u60c5\u5831\u3092\u4f7f\u7528\u3059\u308b\u304b\u3069\u3046\u304b -useFileInfo \u3092\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002").append(CR).append("-useFileInfo=true \u3068\u30bb\u30c3\u30c8\u3059\u308b\u3068\u3001\u4ee5\u4e0b\u306e\uff14\u9805\u76ee\u304c\u5185\u90e8\u7684\u306b\u30bb\u30c3\u30c8\u3055\u308c\u307e\u3059\u3002").append(CR).append(CR).append("\u5165\u529b\u30d5\u30a1\u30a4\u30eb(inXML\u306e\u30d5\u30eb\u30d1\u30b9)     : FILEPATH  (\u4f8b: G:/temp/DOC10/query.jsp)").append(CR).append("\u5165\u529b\u89aa\u30d5\u30a9\u30eb\u30c0(inXML\u306e\u89aa\u30d5\u30a9\u30eb\u30c0) : ADDRESS   (\u4f8b: DOC10)").append(CR).append("\u5165\u529b\u30d5\u30a1\u30a4\u30eb(inXML\u306e\u30d5\u30a1\u30a4\u30eb\u540d)   : FILENAME  (\u4f8b: query.jsp)").append(CR).append("\u5165\u529b\u30d5\u30a1\u30a4\u30eb(inXML\u306e\u66f4\u65b0\u65e5\u4ed8  )   : MODIFIED  (\u4f8b: yyyyMMddHHmmss\u5f62\u5f0f)").append(CR).append(CR).append("xsl \u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3001xsl:param \u3067\u5ba3\u8a00\u3057\u3001xsl:value-of \u3067\u53d6\u308a\u51fa\u3057\u307e\u3059\u3002").append(CR).append("<xsl:param name=\"ADDRESS\" select=\"\" /> \u3068\u5ba3\u8a00\u3057\u3066\u304a\u304d\u3001\u5fc5\u8981\u306a\u7b87\u6240\u3067").append(CR).append("<xsl:value-of select=\"$ADDRESS\"     /> \u3068\u3059\u308c\u3070\u3001\u53d6\u5f97\u3067\u304d\u307e\u3059\u3002").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_XSLT().usage());
    }

    static {
        MUST_PROPARTY.put("xslfile", "\u5909\u63db\u3092\u884c\u3046 XSL\u30d5\u30a1\u30a4\u30eb(\u5fc5\u9808)");
        USABLE_PROPARTY = new LinkedHashMap<String, String>();
        USABLE_PROPARTY.put("outfile", "\u5909\u63db\u7d50\u679c\u306e\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d");
        USABLE_PROPARTY.put("append", "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u3001\u8ffd\u8a18\u3059\u308b(true)\u304b\u65b0\u898f\u4f5c\u6210\u3059\u308b(false)\u304b");
        USABLE_PROPARTY.put("useFileInfo", "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u60c5\u5831\u3092\u3001XSLT\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u306b\u30bb\u30c3\u30c8\u3059\u308b(true)\u304b\u3057\u306a\u3044\u304b(false)\u304b");
        USABLE_PROPARTY.put("addROWSET", "\u30d8\u30c3\u30c0\u30fc/\u30d5\u30c3\u30bf\u30fc\u306b ROWSET \u3092\u8ffd\u8a18\u3057\u307e\u3059\u3002");
        USABLE_PROPARTY.put(HEADER_KEY, "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306b\u3001\u30d8\u30c3\u30c0\u30fc\u6587\u5b57\u5217\u3092\u8ffd\u8a18\u3057\u307e\u3059\u3002" + CR + "\u6dfb\u3048\u5b57(XX)\u304c\u7570\u306a\u308c\u3070\u8907\u6570\u306e\u30d8\u30c3\u30c0\u30fc\u304c\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002");
        USABLE_PROPARTY.put(FOOTER_KEY, "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306b\u3001\u30d5\u30c3\u30bf\u30fc\u6587\u5b57\u5217\u3092\u8ffd\u8a18\u3057\u307e\u3059\u3002" + CR + "\u6dfb\u3048\u5b57(XX)\u304c\u7570\u306a\u308c\u3070\u8907\u6570\u306e\u30d8\u30c3\u30c0\u30fc\u304c\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002");
        USABLE_PROPARTY.put(PARAM_KEY, "XSL\u30d1\u30fc\u30b5\u30fc\u306b\u5bfe\u3057\u3066\u3001paramater \u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002" + CR + "\u30ad\u30fc\u304c\u7570\u306a\u308c\u3070\u3001\u8907\u6570\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002" + CR + "\u4f8b: -param_SYSTEM_ID=GE");
        USABLE_PROPARTY.put("errAbend", "\u7570\u5e38\u767a\u751f\u6642\u306b\u3001\u51e6\u7406\u3092\u4e2d\u65ad(true)\u3059\u308b\u304b\u3001\u7d99\u7d9a(false)\u3059\u308b\u304b" + CR + "(\u521d\u671f\u5024:true:\u4e2d\u65ad\u3059\u308b)");
        USABLE_PROPARTY.put("errXmlIn", "\u7570\u5e38\u767a\u751f\u6642\u306b\u3001\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306b\u3001XML\u5f62\u5f0f\u3067\u30a8\u30e9\u30fc\u3092\u8ffd\u8a18\u3059\u308b\u304b\u3092\u6307\u5b9a\u3059\u308b" + CR + "(\u521d\u671f\u5024:false:\u4f7f\u7528\u3057\u306a\u3044)");
        USABLE_PROPARTY.put("jspInclude", "jsp:directive.include \u767a\u898b\u6642\u306b\u3001\u305d\u306e\u30d5\u30a1\u30a4\u30eb\u3092 INCLUDE \u3059\u308b\u304b\u3092\u6307\u5b9a\u3059\u308b" + CR + "(\u521d\u671f\u5024:true:\u4f7f\u7528\u3059\u308b)");
        USABLE_PROPARTY.put("realPath", "jspInclude=\"true\" \u6642\u306b\u3001/jsp/common/\u4ee5\u4e0b\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u5f97\u5148\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002" + CR + "(\u521d\u671f\u5024:null)");
        USABLE_PROPARTY.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        USABLE_PROPARTY.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

