<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE"
	pgid     = "TRANS01"
	title    = "伝送定義"
	date     = "2008/10/14"
	author   = "M.Takahashi"
	text     = "新規作成"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,KBREAD,READOBJ,DMN_GRP,KBEXEC,EXECOBJ"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select KBREAD,READOBJ,READPRM,KBEXEC,EXECDBID,EXECOBJ,EXECPRM
				,DMN_GRP,DMN_TIME,ERROR_SENDTO,SYSTEM_ID,FGJ,USRUPD,DYUPD,UNIQ
		from GE62
	<og:where>
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"  />
		<og:and value = "KBREAD      =  '{@KBREAD}'"     />
		<og:and value = "READOBJ     like '{@READOBJ}'" />
		<og:and value = "DMN_GRP     like '{@DMN_GRP}'" />
		<og:and value = "KBEXEC      =  '{@KBEXEC}'"     />
		<og:and value = "EXECOBJ     like '{@EXECOBJ}'" />
		<og:and value = "FGJ         =    '{@FGJ}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,KBREAD,DMN_GRP,KBEXEC,UNIQ" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor columns="KBREAD,KBEXEC" must="true" addNoValue="true" />
<og:columnEditor columns="READOBJ,EXECOBJ" must="true" size="20" />
<og:columnEditor columns="READPRM,EXECPRM,EXECDBID,ERROR_SENDTO" size="15" />
<og:columnEditor columns="DMN_GRP" must="true" size="15" />
<og:columnEditor columns="DMN_TIME,SYSTEM_ID,FGJ" must="true" />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="COPY"    noWritable="USRUPD,DYUPD" />
	<og:submit  action="MODIFY"  noWritable="USRUPD,DYUPD" />
	<og:submit  action="DELETE"  columnWritable="null" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
