<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:upload
	fileURL     = "{@USER.ID}"
	maxPostSize = "20000000"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "file1"
/>

<!-- アップロードされたファイルは、UPLOAD_FILES をキーに、Listオブジェクトに格納されています。 -->
<c:forEach items="${UPLOAD_FILES}" var="filename" varStatus="status" >
	<og:file fileURL="{@USER.ID}" file1="${filename}" action="existsLength" >
		<og:message lbl="MSG0064" comment="ファイルが存在していません。" />
		<og:text>fileURL="{@USER.ID}" file1="tempUpload.xls"</og:text>
	</og:file>

	<og:readTable
		command		= "NEW"
		readerClass = "Excel"
		useNumber   = "false"
		skipRowCount= "6"
		modifyType	= "A"
		fileURL		= "{@USER.ID}"
		filename	= "${filename}"
		encode		= "UnicodeLittle"
		adjustColumns	= "*"
		sheetNos    = "{@sheetNos}"
		sheetConstKeys	= "TABLE_NAME,NAME_JA"
		sheetConstAdrs	= "A4,H7"
		nullBreakClm	= "SEQNO"
		columns		= "SEQNO,CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,NOT_NULL,UK,CLM_NAME,TABLE_NAME,NAME_JA"
		maxRowCount	= "0"
		debug		= "{@debug}"
	/>

	<!-- データ長は、表示桁数に、小数点以下の桁数を設定しているので合成する。 -->
	<og:value command="SET" key="LENGTH_FUNC">
	case when [VIEW_LENGTH] is null or [VIEW_LENGTH]=0 then [USE_LENGTH] else [USE_LENGTH] || ',' || [VIEW_LENGTH] end
	</og:value>

	<!-- NOT_NULLは、何か設定されていれば、1 をセットします。 -->
	<og:value command="SET" key="NOT_NULL">
	case when [NOT_NULL] is null then null else 1 end
	</og:value>

	<!-- ファイル名の拡張子で、分割する。SPLIT は、正規表現で separator を指定するので、注意。 -->
	<og:value command="SET" key="FNAME" action="SPLIT" value="${filename}" separator="\." />
	<og:entry command="ALLACTION" selectedAll="true" useConsistency="false" >
		<!-- ファイル名が、テーブルの日本語名になっています。 -->
		<og:columnSet command="ALLACTION" columnId="NAME_JA" action="SET" value="{@FNAME}" />
	</og:entry>

	<!-- 登録処理をおこないます。 -->
	<!-- constObjKey="GF" で、DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD を自動セットします。 -->
	<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" debug="{@debug}" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF80"
			omitNames	= "VIEW_LENGTH"
			funcKeys	= "USE_LENGTH,NOT_NULL"
			funcVals	= "{@LENGTH_FUNC},{@NOT_NULL}"
			constKeys	= "KBCLM,SYSTEM_ID,TBLSYU,FGJ"
			constVals	= "0,{@MEM.SYSTEM_ID},{@MEM.TBLSYU},1"
		/>
	</og:tableUpdate>
	<og:file fileURL="{@USER.ID}" file1="${filename}" action="delete" />
</c:forEach>

<og:forward page="result.jsp" keys="command" vals="RENEW" debug="{@debug}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
