<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7070"
	title	= "Valueタグ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<og:entry command = "{@command}"  />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
		select SYSTEM_ID,TBLSYU,TABLE_NAME,NAME_JA,TABLESPACE_NAME,COMMENTS,JKENSU,FGJ,UNIQ
		from GF02
	<og:where>
		<og:and value = "FGJ             in  ('0','1')"           />
		<og:and value = "SYSTEM_ID       =  'GF'"                 />
		<og:and value = "TBLSYU          =  'D'"                  />
		<og:and value = "TABLE_NAME      in ( {@TABLE_NAME} )"      multi="true" />
		<og:and value = "TABLESPACE_NAME in ( {@TABLESPACE_NAME} )" multi="true" separator="," />
	</og:where>
	order by TABLE_NAME
</og:query>

<og:value command="SET"		action="LOWER"			key="TS_NM_LOW"		value="{@TABLESPACE_NAME}" />
<og:value command="SET"		action="UPPER"			key="TS_NM_UP"		value="{@TS_NM_LOW}" />
<og:value command="SETTBL"	action="ALL_MAX_MIN"	key="JKENSU"		/>
<og:value command="SETTBL"	action="ALL_MAX_MIN"	key="TABLE_NAME"	/>
<og:value command="SET"		action="MAX_MIN"		key="NUM_SU"		value="2,6,-12,8,4"	separator="," />
<og:value command="SETTBL"	action="ALL_LIST"		key="NAME_JA"	/>
<og:value command="SETTBL"	action="ALL_MAP"		key="TABLE_NAME"	value="NAME_JA" />
<og:value command="SET"		action="REPLACE"		key="TS_NM_REP"		value="{@TABLESPACE_NAME}"	fromVal="GE" toVal="XX" />
<og:value command="SET"		action="SUBSTR"			key="TS_NM_SUB"		value="{@TABLESPACE_NAME}"	fromVal="5"  toVal="10" />
<og:value command="SET"		action="SPLIT"			key="TS_NM"			value="{@TABLESPACE_NAME}"	separator="," />
<og:value command="SET"		action="DAY_WEEK"		key="DAY_WEEK"		value="{@DATE.YMD}" />
<og:value command="SET"		action="EXEC"			key="EXEC_ANS"		value="{@EXEC_VAL}" />
<og:value command="SET"		action="CASE"			key="CASE_ANS"		value="{@CASE_VAL}"	fromVal="{@CASE_FRM}"  />

	<og:value command="SQL" action="ROW_APPEND">
		select substrb(TABLE_NAME,1,3) as TBL_SEL from GF02
		where SYSTEM_ID='GF' AND  FGJ in ('0','1') AND TBLSYU='D'
		order by TABLE_NAME
	</og:value>
	<og:value command="SET"		action="MERGE"			key="TBL_SEL"		value="{@TBL_SEL}" separator="," />

<og:text>
<table rules="all" border="1" bordercolor="black">
  <tr><th>action		</th><th>value						</th><th>return			</th></tr>
  <tr><td>LOWER			</td><td>{@TABLESPACE_NAME}			</td><td>{@TS_NM_LOW}	</td></tr>
  <tr><td>UPPER			</td><td>{@TS_NM_LOW}				</td><td>{@TS_NM_UP}	</td></tr>
  <tr><td>ALL_MAX_MIN	</td><td>JKENSU (MIN MAX SUM AVG)	</td><td>MIN={@MIN.JKENSU}		</td><td>MAX={@MAX.JKENSU}		</td><td>SUM={@SUM.JKENSU}</td><td>AVG={@AVG.JKENSU}</td></tr>
  <tr><td>ALL_MAX_MIN	</td><td>TABLE_NAME  (MIN MAX)		</td><td>MIN={@MIN.TABLE_NAME}	</td><td>MAX={@MAX.TABLE_NAME}	</td></tr>
  <tr><td>MAX_MIN		</td><td>SET (2,6,-12,8,4)			</td><td>MIN={@MIN.NUM_SU}		</td><td>MAX={@MAX.NUM_SU}		</td><td>SUM={@SUM.NUM_SU}</td><td>AVG={@AVG.NUM_SU}</td></tr>
  <tr><td>MERGE			</td><td>substrb(TABLE_NAME,1,3)	</td><td colspan="5">{@TBL_SEL}		</td></tr>
  <tr><td>ALL_LIST		</td><td colspan="6">NAME_JA={@NAME_JA}			</td></tr>
  <tr><td>ALL_MAP		</td><td>TABLE_NAME					</td><td>NAME_JA		</td></tr>
  <tr><td>				</td><td>BONUS						</td><td>{@BONUS}		</td></tr>
  <tr><td>				</td><td>DEPT						</td><td>{@DEPT}		</td></tr>
  <tr><td>				</td><td>EMP						</td><td>{@EMP}			</td></tr>
  <tr><td>				</td><td>GF01						</td><td>{@GF01}		</td></tr>
  <tr><td>				</td><td>GF02						</td><td>{@GF02}		</td></tr>
  <tr><td>REPLACE		</td><td>{@TABLESPACE_NAME} GE→XX	</td><td>{@TS_NM_REP}	</td></tr>
  <tr><td>SUBSTR		</td><td>{@TABLESPACE_NAME}	5～10	</td><td>{@TS_NM_SUB}	</td></tr>
  <tr><td>SPLIT			</td><td>{@TABLESPACE_NAME}			</td><td>{@TS_NM}		</td><td>0={@TS_NM0}</td><td>1={@TS_NM1}</td><td>2={@TS_NM2}</td><td>3={@TS_NM3}</td></tr>
  <tr><td>DAY_WEEK		</td><td>本日={@DATE.YMD}			</td><td>月曜={@DAY_WEEK}	</td></tr>
  <tr><td>EXEC			</td><td>{@EXEC_VAL}				</td><td>{@EXEC_ANS}		</td></tr>
  <tr><td>CASE			</td><td>case {@CASE_VAL} when {@CASE_FRM}</td><td>{@CASE_ANS}</td></tr>
</table>
</og:text>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
	useScrollBar= "false"
	startNo		= "{@startNo}"
	checked		= "{@checked}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
