<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result">
	<link rel="stylesheet"	type="text/css" href="joint.css" />
	<script src="joint.all.min.js"	type="text/javascript"><!--  --></script>
	<script src="draw.js"	type="text/javascript"><!--  --></script>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7222"
	title	= "ﾜｰｸﾌﾛｰ"
	date	= "2015/08/25"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "PRJCODE"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select A.PRJCODE,B.NAME_JA AS PRJ_NAME,A.TASK_ID,A.NAME_JA,
				lag(A.PRJCODE ) over( partition by A.PRJCODE order by A.SEQ) as PRE_PRJCODE ,
				lag(A.TASK_ID ) over( partition by A.PRJCODE order by A.SEQ) as PRE_TASK_ID
		from GF64 A left outer join GF62 B
				on A.PRJCODE = B.PRJCODE
	<og:where>
		<og:and value = "A.FGJ			in  ('0','1')"			/>
		<og:and value = "A.PRJCODE		like '{@PRJCODE}'"		/>
		<og:and value = "A.TASK_ID		like '{@TASK_ID}'"		/>
		<og:and value = "A.NAME_JA		like '{@NAME_JA}'"		/>
		<og:and value = "A.DYSTART		&gt;= '{@DYSTART}'"		/>
		<og:and value = "A.TASK_LEVEL	&lt;= '{@TASK_LEVEL}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}" 
				defaultVal = "A.PRJCODE,A.SEQ" />
</og:query>

<!-- 図表示	-->
<div id="graphDiv" />
	<!-- 進捗状況表示	-->
	<og:view
		viewFormType	= "HTMLCustomTable"
		command			= "NEW"
		writable		= "false"
		numberType		= "none"
		useScrollBar	= "false"
		noMessage		= "true"
	>
		<og:thead rowspan="1">
			<tr><td></td></tr>
		</og:thead>
		<og:tbody rowspan="1">
			<tr>
				<td><iStruct id="S_[I]" keyBreak="X"
						preNode	= "[PRE_TASK_ID]_[PRE_PRJCODE]"
						prelbl	= "[PRJ_NAME] ([PRJCODE])"
						color1	= "palegreen"
						pstNode	= "[TASK_ID]_[PRJCODE]"
						pstlbl	= "[NAME_JA] ([PRJCODE])"
						color2	= "lemonchiffon"
					/>
				</td>
			</tr>
		</og:tbody>
	</og:view>

<script for="window" event="onload" type="text/javascript" >
	draw();
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
