<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "ORA10"
	title	= "DBオブジェクト内容"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:text>{@NAME}</og:text>

<og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="0">
		select TABLE_NAME,COLUMN_ID NO,COLUMN_NAME,DATA_TYPE,
			    (CASE WHEN DATA_PRECISION IS NULL THEN DATA_LENGTH ELSE (DATA_PRECISION+0.1*DATA_SCALE) END) AS DATA_LENGTH,
				( CASE	WHEN DATA_TYPE = 'BLOB' or DATA_TYPE = 'CLOB'
							THEN NULL
						WHEN DATA_TYPE = 'NUMBER' AND DATA_PRECISION IS NULL 
							THEN NULL
						WHEN DATA_TYPE = 'VARCHAR2'
							THEN to_char(DATA_LENGTH)
						WHEN DATA_PRECISION IS NULL 
							THEN to_char(DATA_LENGTH)
							ELSE (	CASE WHEN DATA_SCALE = 0 or DATA_SCALE is null
										THEN to_char(DATA_PRECISION)
										ELSE DATA_PRECISION || ',' || DATA_SCALE
								  	END )
						 END ) AS USE_LENGTH ,
			    (CASE NULLABLE WHEN 'N' THEN 'NN' ELSE '' END) AS NN,
				DATA_DEFAULT
		from DBA_TAB_COLS
		where	OWNER			= '{@OWNER}'
		and		TABLE_NAME		= '{@NAME}'
		and		INSTR(TABLE_NAME,'$') < 1
		and		HIDDEN_COLUMN	= 'NO'
		order by COLUMN_ID
</og:query>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	numberType = "none"
	startNo    = "{@startNo}"
	pageSize   = "100000" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
