/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CertificateDetails;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

class KeyStoreProviderCommon {
    static final String rsaEncryptionAlgorithmWithOAEP = "RSA_OAEP";
    static byte[] version = new byte[]{1};

    KeyStoreProviderCommon() {
    }

    static void validateEncryptionAlgorithm(String string, boolean bl) throws SQLServerException {
        String string2;
        String string3 = string2 = bl ? "R_NullKeyEncryptionAlgorithm" : "R_NullKeyEncryptionAlgorithmInternal";
        if (null == string) {
            throw new SQLServerException(null, SQLServerException.getErrString(string2), null, 0, false);
        }
        String string4 = string2 = bl ? "R_InvalidKeyEncryptionAlgorithm" : "R_InvalidKeyEncryptionAlgorithmInternal";
        if (!rsaEncryptionAlgorithmWithOAEP.equalsIgnoreCase(string.trim())) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString(string2));
            Object[] objectArray = new Object[]{string, rsaEncryptionAlgorithmWithOAEP};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
    }

    static void validateNonEmptyMasterKeyPath(String string) throws SQLServerException {
        if (null == string || string.trim().length() == 0) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_InvalidMasterKeyDetails"), null, 0, false);
        }
    }

    static byte[] decryptColumnEncryptionKey(String string, String string2, byte[] byArray, CertificateDetails certificateDetails) throws SQLServerException {
        if (null == byArray) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullEncryptedColumnEncryptionKey"), null, 0, false);
        }
        if (0 == byArray.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_EmptyEncryptedColumnEncryptionKey"), null, 0, false);
        }
        KeyStoreProviderCommon.validateEncryptionAlgorithm(string2, false);
        int n = version.length;
        short s = KeyStoreProviderCommon.convertTwoBytesToShort(byArray, n);
        short s2 = KeyStoreProviderCommon.convertTwoBytesToShort(byArray, n += 2);
        n += 2;
        int n2 = byArray.length - (n += s) - s2;
        byte[] byArray2 = new byte[s2];
        System.arraycopy(byArray, n, byArray2, 0, s2);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n += s2, byArray3, 0, n2);
        byte[] byArray4 = new byte[byArray.length - byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length - byArray3.length);
        if (!KeyStoreProviderCommon.verifyRSASignature(byArray4, byArray3, certificateDetails.certificate, string)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidCertificateSignature"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        byte[] byArray5 = KeyStoreProviderCommon.decryptRSAOAEP(byArray2, certificateDetails);
        return byArray5;
    }

    private static byte[] decryptRSAOAEP(byte[] byArray, CertificateDetails certificateDetails) throws SQLServerException {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(2, certificateDetails.privateKey);
            cipher.update(byArray);
            byArray2 = cipher.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CEKDecryptionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        return byArray2;
    }

    private static boolean verifyRSASignature(byte[] byArray, byte[] byArray2, X509Certificate x509Certificate, String string) throws SQLServerException {
        boolean bl = false;
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(x509Certificate.getPublicKey());
            signature.update(byArray);
            bl = signature.verify(byArray2);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidCertificateSignature"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        return bl;
    }

    private static short convertTwoBytesToShort(byte[] byArray, int n) throws SQLServerException {
        short s = -1;
        if (n + 1 >= byArray.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_ByteToShortConversion"), null, 0, false);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray[n]);
        byteBuffer.put(byArray[n + 1]);
        s = byteBuffer.getShort(0);
        return s;
    }
}

