/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ValueMapTag
extends CommonTagSupport {
    private static final String VERSION = "6.7.2.0 (2017/01/16)";
    private static final long serialVersionUID = 672020170116L;
    private DBTableModel table;
    private String tableId = "h_tblmdl";
    private boolean selectedAll = true;
    private String keys;
    private String valClm;
    private String nnClms;
    private String clsClms;
    private String holdTag;
    private String scope = "session";
    private String separator = "_";
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private int[] clsClmsNo;
    private int valClmNo = 1;
    private String body;
    private final Map<String, String[]> mapObj = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            this.useXssCheck(this.xssCheck);
            this.table = (DBTableModel)this.getObject(this.tableId);
            if (this.table != null && this.table.getRowCount() > 0 && this.table.getColumnCount() > 0) {
                this.makeMapObj(this.table);
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        this.body = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag() && this.body != null) {
            this.jspPrint(this.body);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.table = null;
        this.tableId = "h_tblmdl";
        this.selectedAll = true;
        this.keys = null;
        this.valClm = null;
        this.nnClms = null;
        this.clsClms = null;
        this.holdTag = null;
        this.scope = "session";
        this.separator = "_";
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.body = null;
        this.mapObj.clear();
        this.clsClmsNo = null;
        this.valClmNo = 1;
    }

    private void makeMapObj(DBTableModel dBTableModel) {
        int[] nArray = this.getParameterRows();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this.getClmNos(dBTableModel, this.keys, 0);
        int[] nArray3 = this.getClmNos(dBTableModel, this.nnClms, -1);
        this.clsClmsNo = this.getClmNos(dBTableModel, this.clsClms, -1);
        for (int i = 0; i < nArray.length; ++i) {
            String[] stringArray = (String[])dBTableModel.getValues(i);
            if (!this.isNotNullCheck(stringArray, nArray3)) continue;
            String string2 = this.getAppendKeys(stringArray, nArray2, this.separator);
            this.mapObj.computeIfAbsent(string2, string -> stringArray);
        }
        this.valClmNo = this.valClm == null || this.valClm.isEmpty() ? 1 : dBTableModel.getColumnNo(this.valClm.trim());
    }

    private int[] getClmNos(DBTableModel dBTableModel, String string, int n) {
        int[] nArray;
        if (string == null || string.isEmpty()) {
            nArray = n < 0 ? new int[]{} : new int[]{n};
        } else {
            String[] stringArray = string.split(",");
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = dBTableModel.getColumnNo(stringArray[i].trim());
            }
        }
        return nArray;
    }

    private boolean isNotNullCheck(String[] stringArray, int[] nArray) {
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            String string = stringArray[nArray[i]];
            if (string != null && !string.isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private String getAppendKeys(String[] stringArray, int[] nArray, String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        if (nArray.length > 0) {
            stringBuilder.append(stringArray[nArray[0]]);
            for (int i = 1; i < nArray.length; ++i) {
                String string2 = stringArray[nArray[i]];
                if (string2 == null || string2.isEmpty()) continue;
                stringBuilder.append(string).append(string2);
            }
        }
        return stringBuilder.toString().trim();
    }

    private String getMapVals(String[] stringArray, int n, boolean bl, String string, String string2) {
        String string3;
        String string4 = string3 = string2 == null || string2.isEmpty() ? stringArray[n] : string2;
        if (!bl && this.holdTag != null && !this.holdTag.isEmpty()) {
            String string5 = string == null ? this.getAppendKeys(stringArray, this.clsClmsNo, " ") : string;
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append('<').append(this.holdTag);
            if (!string5.isEmpty()) {
                stringBuilder.append(" class=\"").append(string5).append('\"');
            }
            stringBuilder.append('>').append(string3).append("</").append(this.holdTag).append('>');
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    @Override
    protected String getRequestValue(String string2) {
        int n;
        char c = string2.charAt(0);
        boolean bl = c == '$';
        boolean bl2 = c == '*';
        String string3 = bl || bl2 ? string2.substring(1) : string2;
        int n2 = string3.lastIndexOf(32);
        int n3 = this.valClmNo;
        if (n2 > 0) {
            try {
                n3 = Integer.parseInt(string3.substring(n2 + 1));
                string3 = string3.substring(0, n2).trim();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string4 = null;
        int n4 = string3.lastIndexOf("cls=");
        if (n4 > 0) {
            string4 = string3.substring(n4 + 4);
            string3 = string3.substring(0, n4).trim();
            n = string4.charAt(0);
            int n5 = string4.indexOf(n, 1);
            if (n5 >= 0) {
                string4 = string4.substring(1, n5);
            }
        }
        int n6 = string3.endsWith("!*") ? 2 : (n = string3.endsWith("*") ? 1 : 0);
        if (n > 0) {
            string3 = string3.substring(0, string3.length() - n);
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        if (n == 0) {
            String[] stringArray = this.mapObj.get(string3);
            if (stringArray != null && n3 < stringArray.length) {
                stringBuilder.append(this.getMapVals(stringArray, n3, bl, string4, null));
            } else {
                stringBuilder.append(super.getRequestValue(string2));
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, String[]> entry : this.mapObj.entrySet()) {
                String[] stringArray;
                String string5 = entry.getKey();
                if (!string5.startsWith(string3) || (stringArray = entry.getValue()) == null || n3 >= stringArray.length) continue;
                String string6 = bl2 ? string5.substring(string3.length()) : null;
                arrayList.add(this.getMapVals(stringArray, n3, bl, string4, string6));
            }
            if (n == 2) {
                Collections.reverse(arrayList);
            }
            arrayList.forEach(string -> stringBuilder.append((String)string));
        }
        return stringBuilder.toString();
    }

    @Override
    protected int[] getParameterRows() {
        int[] nArray;
        if (this.selectedAll) {
            int n = this.table.getRowCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = super.getParameterRows();
        }
        return nArray;
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setKeys(String string) {
        this.keys = StringUtil.nval((String)this.getRequestParameter(string), (String)this.keys);
    }

    public void setValClm(String string) {
        this.valClm = StringUtil.nval((String)this.getRequestParameter(string), (String)this.valClm);
    }

    public void setNnClms(String string) {
        this.nnClms = StringUtil.nval((String)this.getRequestParameter(string), (String)this.nnClms);
    }

    public void setClsClms(String string) {
        this.clsClms = StringUtil.nval((String)this.getRequestParameter(string), (String)this.clsClms);
    }

    public void setHoldTag(String string) {
        this.holdTag = StringUtil.nval((String)this.getRequestParameter(string), (String)this.holdTag);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    @Override
    public String toString() {
        String string = ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("selectedAll", (Object)this.selectedAll).println("keys", (Object)this.keys).println("valClm", (Object)this.valClm).println("nnClms", (Object)this.nnClms).println("clsClms", (Object)this.clsClms).println("holdTag", (Object)this.holdTag).println("scope", (Object)this.scope).println("separator", (Object)this.separator).println("xssCheck", (Object)this.xssCheck).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
        return string.toString();
    }
}

