/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* DYDIFF ( FUNCTION )                                                      */
/* Created : 2017/01/05 15:19:16                                            */
/****************************************************************************/

CREATE 
FUNCTION DYDIFF(
	DATE1   IN VARCHAR2  ,
	DATE2   IN VARCHAR2 := NULL ,
	PLUS    IN NUMBER   := 0 ,
	VIEW_ZOOM IN VARCHAR2 := NULL )
RETURN NUMBER
/**********************************************************************/
/* 日にちの差分を求めます。                                           */
/* ただし、マイナス日にちは、０ として返します。                      */
/*          DYDIFF( DATE1,[DATE2],[PLUS] )                            */
/*                                                                    */
/*	  DATE1      IN VARCHAR2  YYYYMMDD 形式 の文字列                  */
/*	 [DATE2]     IN VARCHAR2  YYYYMMDD 形式 の文字列 [本日]           */
/*	 [PLUS]      IN NUMBER    日付け計算時に加算する日数  [=0]        */
/*	 [VIEW_ZOOM] IN VARCHAR2  VIEW_ZOOMの値  [=NULL]                  */
/*                                                                    */
/*	 リターン値   DATE1-DATE2+PLUS （0以上の整数）                    */
/*                                                                    */
/*	DATE1とDATE2の差（日数）を求めます。                              */
/*  DATE2をセットしない場合は、本日の日付けで計算します。             */
/*  ガントチャート等の画面表示用の差計算ですので、マイナス値は        */
/*	0 として返します。                                                */
/*  入力の順番にご注意ください。                                      */
/*  また、第４引数のVIEW_ZOOMが指定されており、かつそのVIEW_ZOOMが    */
/*  月ベースの表示の場合(5,6,7,8,9)、日付は月ベース(1月=30日)として   */
/*  日付計算されます。                                                */
/*                                                                    */
/**********************************************************************/
IS
    RTN     NUMBER(4);

BEGIN

	IF DATE2 IS NULL THEN
		-- 5.4.0.0 (2011/10/01) 月ベースの場合のみ(1ヶ月=30日計算)を行う。
		IF VIEW_ZOOM in ( '5','6','7','8','9' ) THEN
			-- 5.3.5.0 (2011/05/01) 長さ計算のバグ修正
			RTN := MONTHS_BETWEEN(TO_DATE( SUBSTRB(DATE1,1,8),'YYYYMMDD' ),TRUNC(SYSDATE))*30 + PLUS;
		ELSE
			RTN := TO_DATE( SUBSTRB(DATE1,1,8),'YYYYMMDD') - TRUNC(SYSDATE) + PLUS;
		END IF;
	ELSE
		-- 5.4.0.0 (2011/10/01) 月ベースの場合のみ(1ヶ月=30日計算)を行う。
		IF VIEW_ZOOM in ( '5','6','7','8','9' ) THEN
			-- 5.3.5.0 (2011/05/01) 長さ計算のバグ修正
			RTN := MONTHS_BETWEEN(TO_DATE( SUBSTRB(DATE1,1,8),'YYYYMMDD' ),TO_DATE( SUBSTRB(DATE2,1,8),'YYYYMMDD' ))*30 + PLUS;
		ELSE
			RTN := TO_DATE( SUBSTRB(DATE1,1,8),'YYYYMMDD' ) - TO_DATE( SUBSTRB(DATE2,1,8),'YYYYMMDD' ) + PLUS;
		END IF;
	END IF;

	IF RTN < 0 THEN RTN := 0; END IF;

	RETURN RTN;

END DYDIFF;
;
