/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.daemon;

import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;	// 5.5.2.6 (2012/05/25) findbugs対応

import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.report2.ExecThreadManager;
import org.opengion.hayabusa.report2.QueueManager_DB;

/**
 * 【レポート出力】帳票要求テーブルを監視して、帳票処理プログラムを呼び出します。
 * このクラスは、HybsTimerTask を継承した タイマータスククラスです。
 * startDaemon() がタイマータスクによって、呼び出されます。
 *
 * @og.rev 4.3.4.4 (2009/01/01) プラグイン化
 * @og.group デーモン
 *
 * @version  4.0
 * @author   Hiroki.Nakamura
 * @since    JDK1.6
 */
public class Daemon_Report2 extends HybsTimerTask {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.4.2.0 (2016/01/29)" ;

	private static final int LOOP_COUNTER = 24; // カウンタを24回に設定
	private static AtomicBoolean debug = new AtomicBoolean( false );		// 5.5.2.6 (2012/05/25) findbugs対応

	private int loopCnt;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public Daemon_Report2() {
		super();		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	}

	/**
	 * このタイマータスクによって初期化されるアクションです。
	 * パラメータを使用した初期化を行います。
	 *
	 * @og.rev 5.5.2.6 (2012/05/25) findbugs対応。staticフィールドへの書き込みに、AtomicInteger を利用します。
	 */
	@Override
	public void initDaemon() {
		final boolean flag = StringUtil.nval( getValue( "DEBUG" ),debug.get() );
		ExecThreadManager.setDebug( flag ); // 4.3.0.0 (2008/04/15) デバッグ処理の追加
		debug.set( flag );
	}

	/**
	 * タイマータスクのデーモン処理の開始ポイントです。
	 *
	 */
	@Override
	protected void startDaemon() {
		if( loopCnt % LOOP_COUNTER == 0 ) {
			loopCnt = 1;
			System.out.println( toString() + " " + new Date()  + " " );
		}
		else {
			loopCnt++ ;
		}

		QueueManager_DB.getInstance().create();
	}
}
