package org.opengion.hayabusa.io;

// import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.fukurou.system.HybsConst ;		// 6.1.0.0 (2014/12/26)

/**
 * JsChartData は、JsChartData の個別属性を管理しているデータ管理クラスです。
 * 
 * @version	5.9.17.2		2017/02/08
 * @author	T.OTA
 * @sinse	JDK7.0
 *
 */
public class JsChartData {
	private String	chartColumn			; // ﾁｬｰﾄｶﾗﾑ
	private String	label				; // ﾗﾍﾞﾙ
	private String	fill				; // ﾌｨﾙ
	private String	tension				; // 伸張
	private String	borderColor			; // 線の色
	private String	borderWidth			; // 線の幅
	private String	backgroundColor		; // 背景色
	private String	optionAttributes	; // オプション

	/**
	 * チャートカラムを設定します。
	 * 
	 * @param chartColumn チャートカラム
	 */
	public void setChartColumn( final String chartColumn ) {
		this.chartColumn = chartColumn;
	}

	/**
	 * JsChartData オブジェクトを作成する時のチャートカラムを取得します。
	 * 
	 * @return チャートカラム
	 */
	public String getChartColumn() {
		return chartColumn;
	}

	/**
	 * ラベルを設定します。
	 * 
	 * @param label ラベル
	 */
	public void setLabel( final String label ) {
		this.label = label;
	}

	/**
	 * ラベルを取得します。
	 * 
	 * @return ラベル
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * フィル を設定します。
	 * @param fill フィル
	 */
	public void setFill( final String fill ) {
		this.fill = fill;
	}

	/**
	 * 線の伸張 を設定します。
	 * 
	 * @param tension 線の伸張
	 */
	public void setTension( final String tension ) {
		this.tension = tension;
	}

	/**
	 * 線の色 を設定します。
	 * 
	 * @param borderColor 線の色
	 */
	public void setBorderColor( final String borderColor ) {
		this.borderColor = borderColor;
	}

	/**
	 * 線の幅 を設定します。
	 * 
	 * @param borderWidth 線の幅
	 */
	public void setBorderWidth( final String borderWidth ) {
		this.borderWidth = borderWidth;
	}

	/**
	 * 背景色 を設定します。
	 * 
	 * @param backgroundColor 背景色
	 */
	public void setBackgroundColor( final String backgroundColor ) {
		this.backgroundColor = backgroundColor;
	}

	/**
	 * オプション情報 を設定します。
	 * 
	 * @param optionAttributes オプション情報
	 */
	public void setOptionAttributes( final String optionAttributes ) {
		this.optionAttributes = optionAttributes;
	}

	/**
	 * JsChartData オブジェクトを作成する時のオプション情報を取得します。
	 * 
	 * @return オプション情報
	 */
	public String getOptionAttributes() {
		return optionAttributes;
	}

	/**
	 * JsChartData オブジェクトを作成するときのパラメータ情報を取得します。
	 * chartColumnとoptionAttributesを使用して、
	 * パラメータ情報を作成します。 
	 * 
	 * @return ﾊﾟﾗﾒｰﾀ文字列
	 */
	public String getParameter() {
		final StringBuilder rtn = new StringBuilder( HybsConst.BUFFER_SMALL );
		rtn.append( "{" );
		if( label != null && label.length() > 0 ) {
			rtn.append( "label:'" ).append( label ).append( "'," );
		}
		rtn.append( "data:" ).append( chartColumn );
		setProp( rtn, ",fill:"				, fill								);
		setProp( rtn, ",tension:"			, tension							);
		setProp( rtn, ",borderColor:"		, setParaOrArray( borderColor )		);
		setProp( rtn, ",borderWidth:"		, borderWidth						);
		setProp( rtn, ",backgroundColor:"	, setParaOrArray( backgroundColor )	);
		setProp( rtn, ","					, optionAttributes					);
		rtn.append( "}" );

		return rtn.toString();
	}

	/**
	 * 配列が指定される事がある場合の、値設定。
	 * 
	 * @param str 引数(配列形式もありえる)
	 * @return ﾊﾟﾗﾒｰﾀ文字
	 */
	private String setParaOrArray( final String str ) {
		final StringBuilder sb = new StringBuilder( HybsConst.BUFFER_MIDDLE );

		// 引数が配列形式の記載であるかを判定。(頭文字が「[」であるかどうか)
		if( str != null && str.length() > 0 && !"[".equals( str.substring( 0, 1 ) ) ) {
			// 配列でない場合は、ｼﾝｸﾞﾙｸｫﾃｰｼｮﾝを付与
			sb.append( "'" ).append( str ).append( "'" );
		} else {
			// 配列の場合はそのまま
			sb.append( str );
		}

		return sb.toString();
	}

	/**
	 * ﾌﾟﾛﾊﾟﾃｨ設定用ﾒｿｯﾄﾞ。
	 * 
	 * setに値が存在する場合,
	 * sbにstr + setの形で値を追加する。
	 * 
	 * @param sb	ベースとなるStringBuilder
	 * @param str	文字列１
	 * @param set	文字列２
	 */
	private void setProp( final StringBuilder sb, final String str, final String set ) {
		if( set != null && set.length() > 0 ) {
			sb.append( str ).append( set );
		}
	}
}
