<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX013"
	title	= "DB登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:value command="SET" key="C_KEYS"  value="{@SEL_CLMS}" action="APPEND" />
<og:value command="SET" key="C_KCLMS" value="{@KEY_CLMS}" action="APPEND" />
<og:value command="SET" key="C_DCLMS" value="{@DEF_CLMS}" action="APPEND" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}" quotCheck="false" debug="{@debug}">
		select '1' as WRITABLE,{@C_KEYS}
		from {@TABLE_NAME} A
	<og:where>
		<og:and xssCheck="false" value = "{@CLM__0} {@CONDITION__0} '{@VAL__0}'"	/>
		<og:and xssCheck="false" value = "{@CLM__1} {@CONDITION__1} '{@VAL__1}'"	/>
		<og:and xssCheck="false" value = "{@CLM__2} {@CONDITION__2} '{@VAL__2}'"	/>
		<og:and xssCheck="false" value = "{@CLM__3} {@CONDITION__3} '{@VAL__3}'"	/>
		<og:and xssCheck="false" value = "{@CLM__4} {@CONDITION__4} '{@VAL__4}'"	/>
		<og:and xssCheck="false" value = "{@CLM__5} {@CONDITION__5} '{@VAL__5}'"	/>
		<og:and xssCheck="false" value = "{@CLM__6} {@CONDITION__6} '{@VAL__6}'"	/>
		<og:and xssCheck="false" value = "{@CLM__7} {@CONDITION__7} '{@VAL__7}'"	/>
		<og:and xssCheck="false" value = "{@CLM__8} {@CONDITION__8} '{@VAL__8}'"	/>
		<og:and xssCheck="false" value = "{@CLM__9} {@CONDITION__9} '{@VAL__9}'"	/>
		<og:and xssCheck="false" value = "{@CLM}    {@CONDITION}    '{@VAL}'"		/>
		<og:and xssCheck="false" value = "{@AND}"	 quotCheck="false" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}" />
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:value command="SET" key="writable" value="false" />	<!-- view の書込み禁止判定 -->
	<og:writeCheck caseNN="{@UNIQ_KEYS}">
		<og:equals val1="{@ACTION}" nullCheck="true">
			<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
			<og:submit  action="COPY"    noWritable="null"  />
			<og:submit  action="MODIFY"  noWritable="{@UNIQ_KEYS}" />
			<og:submit  action="DELETE" lbl="DELETE_PH" columnWritable="null" />
		</og:equals>
		<og:equals val1="{@ACTION}" val2="MINUS">
			<og:submit  action="COPY" noWritable="null" />
			<og:submit  value="entry" command="ENTRY" lbl="DIRECT" keys="sqlType,ALL" vals="INSERT,true" />
		</og:equals>
		<og:equals val1="{@ACTION}" val2="DIFFERENCE">
			<og:submit  action="MODIFY" noWritable="{@UNIQ_KEYS}" />
		</og:equals>
		<br />
		<og:value command="SET" key="writable" value="true" /><!-- view の書込み禁止判定 -->
	</og:writeCheck>

	<og:equals val1="{@ACTION}" val2="{@ACTION}">
		<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
			{@USER.LASTSQL}
		</og:query>

		<og:tableMerge
			action        = "{@ACTION}"
			masterScope   = "session"
			masterKeys    = "{@C_KCLMS}"
			diffKeys      = "{@C_DCLMS}"
			slaveScope    = "request"
			modifyClms    = "{@UNIQ_KEYS}"
			display       = "true"
		/>
	</og:equals>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable" 
		command    = "{@command}" 
		checked    = "{@checked}"
		startNo    = "{@startNo}" 
		pageSize   = "{@pageSize}"
		writable   = "{@writable}"
	/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
