/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.EncryptionKeyInfo;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class CekTableEntry {
    private static final Logger aeLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.AE");
    Vector<EncryptionKeyInfo> columnEncryptionKeyValues;
    int ordinal;
    int databaseId;
    int cekId;
    int cekVersion;
    byte[] cekMdVersion;

    Vector<EncryptionKeyInfo> getColumnEncryptionKeyValues() {
        return this.columnEncryptionKeyValues;
    }

    int getOrdinal() {
        return this.ordinal;
    }

    int getDatabaseId() {
        return this.databaseId;
    }

    int getCekId() {
        return this.cekId;
    }

    int getCekVersion() {
        return this.cekVersion;
    }

    byte[] getCekMdVersion() {
        return this.cekMdVersion;
    }

    CekTableEntry(int n) {
        this.ordinal = n;
        this.databaseId = 0;
        this.cekId = 0;
        this.cekVersion = 0;
        this.cekMdVersion = null;
        this.columnEncryptionKeyValues = new Vector();
    }

    int getSize() {
        return this.columnEncryptionKeyValues.size();
    }

    void add(byte[] byArray, int n, int n2, int n3, byte[] byArray2, String string, String string2, String string3) {
        assert (null != this.columnEncryptionKeyValues) : "columnEncryptionKeyValues should already be initialized.";
        if (aeLogger.isLoggable(Level.FINE)) {
            aeLogger.fine("Retrieving CEK values");
        }
        EncryptionKeyInfo encryptionKeyInfo = new EncryptionKeyInfo(byArray, n, n2, n3, byArray2, string, string2, string3);
        this.columnEncryptionKeyValues.add(encryptionKeyInfo);
        if (0 == this.databaseId) {
            this.databaseId = n;
            this.cekId = n2;
            this.cekVersion = n3;
            this.cekMdVersion = byArray2;
        } else {
            assert (this.databaseId == n);
            assert (this.cekId == n2);
            assert (this.cekVersion == n3);
            assert (null != this.cekMdVersion && null != byArray2 && this.cekMdVersion.length == byArray2.length);
        }
    }
}

