/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.penguin.math.statistics;

import java.util.Arrays;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;

public class HybsMultiRegression {
    private double[] coe;
    private double rsquare;
    private boolean noIntercept;

    public HybsMultiRegression(double[][] dArray, double[] dArray2, boolean bl) {
        this.noIntercept = bl;
        OLSMultipleLinearRegression oLSMultipleLinearRegression = new OLSMultipleLinearRegression();
        oLSMultipleLinearRegression.setNoIntercept(bl);
        oLSMultipleLinearRegression.newSampleData(dArray2, dArray);
        this.coe = oLSMultipleLinearRegression.estimateRegressionParameters();
        this.rsquare = oLSMultipleLinearRegression.calculateRSquared();
    }

    public HybsMultiRegression(double[] dArray, boolean bl) {
        this.coe = dArray;
        this.noIntercept = bl;
    }

    public double[] getParam() {
        return this.coe;
    }

    public double getRSquare() {
        return this.rsquare;
    }

    public double predict(double[] dArray) {
        int n;
        double d = 0.0;
        int n2 = n = this.noIntercept ? 0 : 1;
        if (dArray.length < this.coe.length - n) {
            return 0.0;
        }
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * this.coe[i + n];
        }
        if (!this.noIntercept) {
            d += this.coe[0];
        }
        return d;
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{50.0, 60.0, 65.0, 65.0, 70.0, 75.0, 80.0, 85.0, 90.0, 95.0};
        double[][] dArrayArray = new double[][]{{165.0, 65.0}, {170.0, 68.0}, {172.0, 70.0}, {175.0, 65.0}, {170.0, 80.0}, {172.0, 85.0}, {183.0, 78.0}, {187.0, 79.0}, {180.0, 95.0}, {185.0, 97.0}};
        HybsMultiRegression hybsMultiRegression = new HybsMultiRegression(dArrayArray, dArray, true);
        System.out.println(hybsMultiRegression.getRSquare());
        System.out.println(Arrays.toString(hybsMultiRegression.getParam()));
        System.out.println(hybsMultiRegression.predict(new double[]{169.0, 85.0}));
    }
}

