/****************************************************************************/
/* GF95 ( DBｾｯﾄ基準書 )                                                     */
/*                                                                          */
/* Created : 2017/05/02 11:07:39                                            */
/****************************************************************************/
CREATE TABLE GF95 (
   SYSTEM_ID    VARCHAR2 (  10 )                                        /*  10 ｼｽﾃﾑID       */
 , PGID         VARCHAR2 (  30 )                    NOT NULL            /*  20 PG-ID        */
 , NMSYORI      VARCHAR2 ( 100 )                                        /*  30 処理ｸﾞﾙｰﾌﾟ名 */
 , SEQ          NUMBER   (   7 )        DEFAULT 0   NOT NULL            /*  40 順           */
 , TABLE_NAME   VARCHAR2 (  50 )                    NOT NULL            /*  50 ﾃｰﾌﾞﾙ名      */
 , CLM          VARCHAR2 (  30 )                                        /*  60 項目         */
 , MOTO         VARCHAR2 (  30 )                                        /*  70 入力元       */
 , ADDACT       VARCHAR2 ( 500 )                                        /*  80 追加時       */
 , MODIACT      VARCHAR2 ( 500 )                                        /*  90 更新時       */
 , DELACT       VARCHAR2 ( 500 )                                        /* 100 削除時       */
 , UNIQ         NUMBER   (   9 )        DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (   1 )        DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (  14 )                                        /* 820 登録日時     */
 , PGSET        VARCHAR2 (  10 )                                        /* 830 作成PG       */
 , PGPSET       VARCHAR2 (  10 )                                        /* 840 作成親PG     */
 , USRSET       VARCHAR2 (  10 )                                        /* 850 作成社員     */
 , DYUPD        VARCHAR2 (  14 )                                        /* 860 更新日時     */
 , PGUPD        VARCHAR2 (  10 )                                        /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (  10 )                                        /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (  10 )                                        /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K );

CREATE SEQUENCE GF95S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF95T00 
  BEFORE INSERT ON GF95
  FOR EACH ROW 
  BEGIN 
    SELECT GF95S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
