/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* VIEW_ZOOM ( FUNCTION )                                                   */
/* Created : 2017/05/02 11:07:40                                            */
/****************************************************************************/
CREATE     
FUNCTION VIEW_ZOOM(
	XVAL    IN NUMBER   ,
	XZOOM   IN VARCHAR2 ,
	XBASE   IN NUMBER := 12  )
RETURN NUMBER
IS
    RTN     NUMBER(6);

BEGIN

	IF    XZOOM = '0'  THEN RTN := TRUNC( XVAL * XBASE * 4.0  );
	ELSIF XZOOM = '1'  THEN RTN := TRUNC( XVAL * XBASE * 2.0  );
	ELSIF XZOOM = '2'  THEN RTN := TRUNC( XVAL * XBASE        );
	ELSIF XZOOM = '3'  THEN RTN := TRUNC( XVAL * XBASE / 1.5  );
	ELSIF XZOOM = '4'  THEN RTN := TRUNC( XVAL * XBASE / 3.0  );
	ELSIF XZOOM = '5'  THEN RTN := TRUNC( XVAL * XBASE / 4.0  );
	ELSIF XZOOM = '6'  THEN RTN := TRUNC( XVAL * XBASE / 6.0  );
	ELSIF XZOOM = '7'  THEN RTN := TRUNC( XVAL * XBASE / 12.0 );
	ELSIF XZOOM = '8'  THEN RTN := TRUNC( XVAL * XBASE / 24.0 );
	ELSIF XZOOM = '9'  THEN RTN := TRUNC( XVAL * XBASE / 36.0 );
	ELSIF XZOOM = '10' THEN RTN := TRUNC( XVAL * XBASE / 3.5  );
	ELSIF XZOOM = '20' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  100.0 );
	ELSIF XZOOM = '21' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  100.0 );
	ELSIF XZOOM = '22' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  200.0 );
	ELSIF XZOOM = '23' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  200.0 );
	ELSIF XZOOM = '24' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  400.0 );
	ELSIF XZOOM = '25' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  400.0 );
	ELSIF XZOOM = '26' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  600.0 );
	ELSIF XZOOM = '27' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  600.0 );
	ELSIF XZOOM = '28' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  800.0 );
	ELSIF XZOOM = '29' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  800.0 );
	ELSIF XZOOM = '30' THEN RTN := TRUNC( XVAL * XBASE * 4.0 / 1200.0 );
	ELSIF XZOOM = '31' THEN RTN := TRUNC( XVAL * XBASE * 2.0 / 1200.0 );
	END IF ;

	RETURN RTN;

END VIEW_ZOOM;
/
